"""
/***************************************************************************
 CSVTools
                                 A QGIS plugin
 Adds new processing algorithms and models that deal with CSV files
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-02-19
        copyright            : (C) 2019 by Yann Voté
        email                : ygversil@lilo.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Yann Voté'
__date__ = '2019-02-19'
__copyright__ = '(C) 2019 by Yann Voté'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'


from contextlib import AbstractContextManager

from qgis.core import QgsProcessingException


class QgisStepManager(AbstractContextManager):
    """Context manager that manages steps, that is child algorithms, in a QGIS
    processing flow."""

    def __init__(self, feedback, abort_message='Aborting on user request'):
        self.feedback = feedback
        self.current_step = 0
        self.abort_message = abort_message

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.current_step += 1
        self.feedback.setCurrentStep(self.current_step)
        if self.feedback.isCanceled():
            raise QgsProcessingException(self.abort_message)
        return False
