# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CSVTools
                                 A QGIS plugin
 Adds new processing algorithms and models that deal with CSV files
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-02-19
        copyright            : (C) 2019 by Yann Voté
        email                : ygversil@lilo.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Yann Voté'
__date__ = '2019-02-19'
__copyright__ = '(C) 2019 by Yann Voté'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'


from qgis.core import (
    QgsDataSourceUri,
    QgsProcessingException,
    QgsProviderRegistry,
)
import psycopg2


def pg_conn(qgis_conn_name):
    return psycopg2.connect(
        QgsDataSourceUri(
            QgsProviderRegistry.instance().providerMetadata('postgres').createConnection(
                qgis_conn_name
            ).uri()
        ).connectionInfo()
    )


def pg_copy(cursor, select_sql, dstf):
    """Copy the given ``SELECT`` query to the given destination file."""
    try:
        cursor.copy_expert(
            'copy ({select_sql}) to stdout '
            'with (format csv, '
            "delimiter '|', "
            "null '', "
            "header true, "
            "quote '\"')".format(select_sql=select_sql),
            dstf
        )
    except psycopg2.Error as e:
        raise QgsProcessingException(
            '{e} QUERY: {query}'.format(
                e=str(e),
                query=e.cursor.query.decode(
                    e.cursor.connection.encoding
                )
            )
        )
