# CSV Geometry Export Plugin

A QGIS plugin that allows you to export vector layers as CSV files with customizable geometry column names.

## Features

- Export vector layers as CSV with geometry as WKT
- Customizable geometry column name (instead of default "WKT")
- Access via toolbar button or right-click context menu on layers
- Field selection similar to standard QGIS export dialog
- Support for exporting only selected features
- Multiple encoding options (UTF-8, Latin1, CP1252, ISO-8859-1)
- CRS transformation options

## Installation

1. Copy the plugin folder to your QGIS plugins directory
2. Enable the plugin in QGIS Plugin Manager
3. The plugin will add a toolbar button and context menu option

## Usage

### From Toolbar
1. Select a vector layer
2. Click the "Export as CSV with Geometry" toolbar button
3. Configure export options in the dialog
4. Click OK to export

### From Context Menu
1. Right-click on a vector layer in the layer panel
2. Select "Export as CSV with Geometry"
3. Configure export options in the dialog
4. Click OK to export

## Configuration Options

- **Output File**: Choose where to save the CSV file
- **Geometry Column Name**: Customize the name of the geometry column
- **Encoding**: Select text encoding for the output file
- **CRS**: Choose coordinate reference system for geometry
- **Field Selection**: Choose which fields to include in the export
- **Selected Features Only**: Export only selected features

## Requirements

- QGIS 3.0 or higher
- PyQt5 (included with QGIS)

## License

GPL v2 or later
