# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CRSguesser
                                 A QGIS plugin
 Guesses unknown CRS for layers
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-08-05
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Brigit Danthine
        email                : brigit.danthine@uibk.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QProgressBar
from qgis.core import Qgis, QgsVectorLayer, QgsProject, QgsMapLayerProxyModel, QgsField, QgsPointXY, QgsFeature, QgsGeometry

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .crs_guesser_dialog import CRSguesserDialog
import os.path
import webbrowser
import pyproj
import os

class CRSguesser:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CRSguesser_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&CRS Guesser')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CRSguesser', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/crs_guesser/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Start CRS Guesser'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&CRS Guesser'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def hilfe(self):
        webbrowser.open('https://wiki.uibk.ac.at/archaeologien-howtodigitalarchaeology/index.php?title=CRS_Guesser', new=2)
    
    def custom_edit(self):
        filename = self.plugin_dir + '/CRS_files/CRS_list_custom.txt'
        os.system("start " + filename)
        
    def check_manual(self):
        if self.dlg.checkbox_manual.isChecked() == True:
            self.dlg.checkbox_layer.setChecked(False)
    
    def check_layer(self):
        if self.dlg.checkbox_layer.isChecked() == True:
            self.dlg.checkbox_manual.setChecked(False)
    
    def button_ok(self):
        #Fehlermeldung wenn keine Liste ausgewählt
        if self.dlg.wahl_test_kbs.currentText() == "":
            self.iface.messageBar().pushMessage("Please define a list of coordinates to be searched!", level=Qgis.Critical)
        #Fehlermeldung wenn kein KBS ausgewählt ist
        if self.dlg.eingabe_ausgabe_kbs.crs() == "QgsCoordinateReferenceSystem: invalid":
            self.iface.messageBar().pushMessage("Please define an output CRS!", level=Qgis.Critical)
        
        #wenn checkbox manuelle Koordinateneingabe
        if self.dlg.checkbox_manual.isChecked() == True:             
            if self.dlg.eingabe_x_koordinate.value() != 0:
                if self.dlg.eingabe_y_koordinate.value() != 0:
                    #Konvertierung manuelle Koordinateneingabe
                    x1, y1 = (self.dlg.eingabe_x_koordinate.value(), self.dlg.eingabe_y_koordinate.value())
                    Konvertierte_Koordinaten = open(self.plugin_dir + "/output/Guessed_CRS.csv", "w")
                    crs_input = self.dlg.eingabe_ausgabe_kbs.crs()
                    crs_authid = crs_input.authid()
                    out_kbs = int(crs_authid.split(":")[1])
                    Konvertierte_Koordinaten.write("CRS" + ";" + "x" + ";" + "y" + "\n")
                    
                    crs_path = self.plugin_dir + '/CRS_files'
                    if self.dlg.wahl_test_kbs.currentText() == "All":
                        KBS_list = open(crs_path + '/CRS_list_all.txt', "r")
                    if self.dlg.wahl_test_kbs.currentText() == "Austria":
                        KBS_list = open(crs_path + '/CRS_list_austria.txt', "r")
                    if self.dlg.wahl_test_kbs.currentText() == "Custom":
                        KBS_list = open(crs_path + '/CRS_list_custom.txt', "r")
                    
                    count = 0
                    progress_count = 0
                    line_text = KBS_list.readlines()
                    print(line_text)
                    line_count = len(line_text)
                    progress_count_plus = 100/line_count
                    
                    if self.dlg.wahl_test_kbs.currentText() == "All":
                        KBS_list = open(crs_path + '/CRS_list_all.txt', "r")
                    if self.dlg.wahl_test_kbs.currentText() == "Austria":
                        KBS_list = open(crs_path + '/CRS_list_austria.txt', "r")
                    if self.dlg.wahl_test_kbs.currentText() == "Custom":
                        KBS_list = open(crs_path + '/CRS_list_custom.txt', "r")
                    
                    for line in KBS_list:
                        in_kbs = int(line.strip())
                        print(in_kbs)
                        projection = pyproj.Transformer.from_crs(in_kbs, out_kbs, always_xy=True) 
                        x2, y2 = projection.transform(x1, y1)
                        Konvertierte_Koordinaten.write(str(in_kbs) + ";" + str(x2) + ";" + str(y2) + "\n")
                        count +=1
                        # Progress
                        progress_count += progress_count_plus
                        self.dlg.progressBar.setValue(progress_count)
                        
                    Konvertierte_Koordinaten.close()
                    KBS_list.close()
                    
                    #CSV laden
                    in_csv = "file:///" + self.plugin_dir + "/output/Guessed_CRS.csv"
                    in_csv_uri = in_csv + "?type=csv&encoding=%s&delimiter=%s&xField=%s&yField=%s&crs=%s" % ("UTF-8",";","x","y",crs_authid)
                    guessed_crs=QgsVectorLayer(in_csv_uri,"guessed_crs","delimitedtext")
                    if not guessed_crs.isValid():
                        print ("Layer not loaded")
                    QgsProject.instance().addMapLayer(guessed_crs)
                    
                    self.iface.messageBar().pushMessage("Done", level=Qgis.Success)  #Success/Info, Warning, Critical,

                else: self.iface.messageBar().pushMessage("Please Enter Y-Coordinate!", level=Qgis.Critical)
            if self.dlg.eingabe_x_koordinate.value() == 0:
                if self.dlg.eingabe_y_koordinate.value() > 0:
                    self.iface.messageBar().pushMessage("Please Enter X-Coordinate!", level=Qgis.Critical)
                else:
                    self.iface.messageBar().pushMessage("Please Enter X- and Y-Coordinate!", level=Qgis.Critical)
       
        #wenn checkbox Layer-Eingabe 
        if self.dlg.checkbox_layer.isChecked() == True:
            print("Checkbox Layer")
            crs_input = self.dlg.eingabe_ausgabe_kbs.crs()
            crs_authid = crs_input.authid()
            out_kbs = int(crs_authid.split(":")[1])
            #Shapelayer erstellen
            #path_guessed_crs_layer = self.plugin_dir + "/output/Guessed_CRS.shp"
            vl = QgsVectorLayer("Polygon", "guessed_crs_layer", "memory")
            crs = vl.crs()
            crs.createFromId(out_kbs)
            vl.setCrs(crs)
            #Attribute erstellen
            pr = vl.dataProvider()
            pr.addAttributes([QgsField("EPSG", QVariant.String)])
            vl.updateFields() 
            #Layer extend
            layer = self.dlg.eingabe_layer.currentLayer()
            ex = layer.extent()
            xmax = ex.xMaximum()
            ymax = ex.yMaximum()
            xmin = ex.xMinimum()
            ymin = ex.yMinimum()
            #Projizierung von Polygon mit Koordinaten extend von Listen etc in Ausgabecrs            
            crs_path = self.plugin_dir + '/CRS_files'
            if self.dlg.wahl_test_kbs.currentText() == "All":
                KBS_list = open(crs_path + '/CRS_list_all.txt', "r")
            if self.dlg.wahl_test_kbs.currentText() == "Austria":
                KBS_list = open(crs_path + '/CRS_list_austria.txt', "r")
            if self.dlg.wahl_test_kbs.currentText() == "Custom":
                KBS_list = open(crs_path + '/CRS_list_custom.txt', "r")
            
            count = 0
            progress_count = 0
            line_text = KBS_list.readlines()
            line_count = len(line_text)
            progress_count_plus = 100/line_count
            
            if self.dlg.wahl_test_kbs.currentText() == "All":
                KBS_list = open(crs_path + '/CRS_list_all.txt', "r")
            if self.dlg.wahl_test_kbs.currentText() == "Austria":
                KBS_list = open(crs_path + '/CRS_list_austria.txt', "r")
            if self.dlg.wahl_test_kbs.currentText() == "Custom":
                KBS_list = open(crs_path + '/CRS_list_custom.txt', "r")
            
            for line in KBS_list:
                in_kbs = int(line.strip())
                projection = pyproj.Transformer.from_crs(in_kbs, out_kbs, always_xy=True) 
                
                x_l_o, y_l_o = projection.transform(xmin, ymax)
                x_r_o, y_r_o = projection.transform(xmax, ymax)
                x_l_u, y_l_u = projection.transform(xmin, ymin)
                x_r_u, y_r_u = projection.transform(xmax, ymin)
                
                #Polygongeometrie mit den oberen Punkten in Layer schreiben inkl Attribute
                points = [QgsPointXY(x_l_o, y_l_o),QgsPointXY(x_r_o, y_r_o),QgsPointXY(x_r_u, y_r_u),QgsPointXY(x_l_u, y_l_u),QgsPointXY(x_l_o, y_l_o)]
                f = QgsFeature()
                f.setGeometry(QgsGeometry.fromPolygonXY([points]))
                #f.setGeometry(QgsGeometry.fromPolygon(QgsPoint(x_l_o, y_l_o),QgsPoint(x_r_o, y_r_o),QgsPoint(x_l_u, y_l_u),QgsPoint(x_r_u, y_r_u),QgsPoint(x_l_o, y_l_o))
                f.setAttributes([in_kbs])
                pr.addFeature(f)
                vl.updateExtents()
                
                #Konvertierte_Koordinaten.write(str(in_kbs) + ";" + str(x2) + ";" + str(y2) + "\n")
                
                count +=1
                # Progress
                progress_count += progress_count_plus
                self.dlg.progressBar.setValue(progress_count)
            QgsProject.instance().addMapLayer(vl)
            
        #wenn keine checkbox
        if not self.dlg.checkbox_manual.isChecked() == True:
            if not self.dlg.checkbox_layer.isChecked() == True:
                self.iface.messageBar().pushMessage("Please select whether coordinate is to be entered manuelly or read from a layer", level=Qgis.Critical)
  

    def prof(self):
        self.progressBar.reset()
        for i in range(101):
            self.progressBar.setValue(i)
    
    def close_plugin(self):
        self.dlg.close()
            
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = CRSguesserDialog()
            # uncheck combobox if other is selected
            self.dlg.checkbox_manual.clicked.connect(self.check_manual)
            self.dlg.checkbox_layer.clicked.connect(self.check_layer)
            #nur Vektor-Layer
            self.dlg.eingabe_layer.setFilters(QgsMapLayerProxyModel.VectorLayer)
            self.dlg.ok_run.clicked.connect(self.button_ok)
            #Inhalte ComboBox
            self.dlg.wahl_test_kbs.addItems(["","Austria", "All", "Custom"])
            #für editieren der custom-liste
            self.dlg.file_edit_custom.clicked.connect(self.custom_edit)
            #hilfe
            self.dlg.hilfe.clicked.connect(self.hilfe)
            #schliessen
            self.dlg.schliessen.clicked.connect(self.close_plugin)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass