# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CreateGridsAngle
                                 A QGIS plugin
 Create grids under specific angle
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Memic Emir
        email                : emir_memic@windowslive.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox, QFileDialog

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .create_grids_angle_dialog import CreateGridsAngleDialog
import os.path

from qgis.core import *
from qgis.utils import *
from qgis.PyQt import *
import qgis.utils
import re
import processing
from qgis.utils import reloadPlugin
import math
import numpy as np
from PyQt5.QtGui import QFont, QColor
from PyQt5.QtCore import Qt

class CreateGridsAngle:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CreateGridsAngle_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Create Grids Angle')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CreateGridsAngle', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/create_grids_angle/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Create grids angle'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Create Grids Angle'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = CreateGridsAngleDialog()

#
#### me
        reloadPlugin('create_grids_angle')
        
        #self.dlg.pushButton.clicked.connect(self.split_into_grids)
        #self.dlg.pushButton_2.clicked.connect(self.rotate_grids)
        #self.dlg.pushButton_3.clicked.connect(self.move_grids)        
        self.dlg.pushButton_4.clicked.connect(self.create_layer_for_line)
        self.dlg.pushButton_5.clicked.connect(self.create_layer_for_polygon)
        self.dlg.pushButton_6.clicked.connect(self.automatically_create_grids)        
        self.dlg.pushButton_7.clicked.connect(self.guide_to_user)
        #self.dlg.pushButton_8.clicked.connect(self.setting_up_crs)
        self.dlg.listWidget.clicked.connect(self.setting_up_crs)
        self.dlg.pushButton_9.clicked.connect(self.draw_tractor_grids)
        self.dlg.pushButton_10.clicked.connect(self.select_output_directory_manually)
        
        self.dlg.pushButton_11.setEnabled(False)
        self.dlg.lineEdit_5.setEnabled(False)
        self.dlg.pushButton_11.clicked.connect(self.export_shape_file)
        
        # add available layers into interface
        layers = self.iface.mapCanvas().layers()
        self.dlg.listWidget.clear()
        listOfLayers = []
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                
                feature = layer.getFeatures()
                for featt in feature:
                    geom = featt.geometry()
                    if geom.type() == QgsWkbTypes.PolygonGeometry:                
                        #not sure if this is good solution...               
                        if '_grided_cliped' not in str(layer.name()):
                            listOfLayers.append(str(layer.name()))
            QCoreApplication.processEvents()
        self.dlg.listWidget.addItems(listOfLayers)
        

        # add available line type layers into interface
        layersS = self.iface.mapCanvas().layers()
        self.dlg.listWidget_2.clear()
        listOfLayersS = []
        for layerS in layersS:
            if layerS.type() == QgsMapLayer.VectorLayer:
                #print ('layerS type', layerS.type())                
                featureM = layerS.getFeatures()
                for feat in featureM:
                    geomM = feat.geometry()
                    if geomM.type() == QgsWkbTypes.LineGeometry:                
                        if '_clipedTracks' not in str(layerS.name()):
                            listOfLayersS.append(str(layerS.name()))
                    QCoreApplication.processEvents()        
            QCoreApplication.processEvents()
        
        self.dlg.listWidget_2.addItems(listOfLayersS)
        
        self.dlg.listWidget_2.clicked.connect(self.extend_field_edge_line)
        
#

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def guide_to_user(self):
        QMessageBox.information(None, 'Guide to user!', 
        '1. Input layer - Field Bounds (Polygon type shape file) based on which site-specific units/grids are created!\n'        
        + '   - by selecting other layer available in QGIS layers form the list window of Create Grids Angle interface, a user can automatically take over CRS, or enter it manually.\n'
        + '   - a user can use "Draw field outter bounds" to draw new temporary polygon layer of corresponding field. "Mouse-Left" button to draw points of polygon and mouse "Right-button" to commit the change to the layer.\n\n'        
        + '2. Input layer - Field edge (Line type) parallel to tractor tracks (Line type shape file).\n'
        + '   - a user can use "Draw field edge" push button to add new temporary line layer indicating desired field edge. "Mouse-Left" button to draw points of line and mouse "Right-button" to commit the change to the layer.\n\n'
        + '3. Polygon (site-specific) units dimensions width*height (size) in meter.\n\n'
        + '4. Create Grids, and optional a user can create vehicle tracks with m distance from the edge line.\n\n'
        + '5. Export layer as shape file. User selects output directory where to save layer output ESRI shape file.'        
        )   

    def setting_up_crs(self):
        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        layer1=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        print ('layer', layer)
        myfilepathP = layer.source()
        myfilepathP = os.path.dirname(myfilepathP)
        print ('myfilepathP', myfilepathP)

        lyrCRS = layer.crs().authid() # returns a reference to the active QgsMapLayer
        print('lyrCRS', lyrCRS)
        self.dlg.lineEdit_3.setText(lyrCRS)

    def automatically_create_grids(self):
        self.split_into_grids()
        self.rotate_grids()
        self.move_grids()
        
        lineEdgeHorizontalTest = 'lineEdgeHorizontalTest'
        input_layer0 = QgsProject.instance().mapLayersByName(lineEdgeHorizontalTest)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        lineEdgeTest = 'lineEdgeTest'
        input_layer0 = QgsProject.instance().mapLayersByName(lineEdgeTest)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        findEdgeOfFieldBound = 'findEdgeOfFieldBound'
        input_layer0 = QgsProject.instance().mapLayersByName(findEdgeOfFieldBound)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        foundRightEdgeIntersect = 'foundRightEdgeIntersect'
        input_layer0 = QgsProject.instance().mapLayersByName(foundRightEdgeIntersect)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        coordinate_0 = 'coordinate_0'
        input_layer0 = QgsProject.instance().mapLayersByName(coordinate_0)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        coordinate_1 = 'coordinate_1'
        input_layer0 = QgsProject.instance().mapLayersByName(coordinate_1)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        coordinate_2 = 'coordinate_2'
        input_layer0 = QgsProject.instance().mapLayersByName(coordinate_2)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        coordinate_3 = 'coordinate_3'
        input_layer0 = QgsProject.instance().mapLayersByName(coordinate_3)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)         
        QgsProject.instance().removeMapLayer(input_layer0)
        
        centerOfGriddedBoundingBox = 'centerOfGriddedBoundingBox'
        input_layer0 = QgsProject.instance().mapLayersByName(centerOfGriddedBoundingBox)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        selectedLayer = str(self.dlg.listWidget.currentItem().text())

        originalcopy = selectedLayer + '_original-copy'
        input_layer0 = QgsProject.instance().mapLayersByName(originalcopy)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        
        grided = selectedLayer + '_grided'
        input_layer0 = QgsProject.instance().mapLayersByName(grided)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)

        QgsProject.instance().reloadAllLayers()
       # add available layers into interface
        layers = self.iface.mapCanvas().layers()
        self.dlg.comboBox.clear()
        listOfLayers = []
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                listOfLayers.append(str(layer.name()))
            QCoreApplication.processEvents()
        
        self.dlg.comboBox.addItems(listOfLayers)
        QCoreApplication.processEvents()


    def create_layer_for_polygon(self):
        print ('create polygon - field bounds')

        selectedLayer = 'Field'
        #lyrCRS = layer.crs().authid() # returns a reference to the active QgsMapLayer
        #print('lyrCRS', lyrCRS)
        #self.dlg.lineEdit_3.setText(lyrCRS)
        lyrCRS = str(self.dlg.lineEdit_3.text())
        print('lyrCRS', lyrCRS)

        newLineLayer = QgsVectorLayer("Polygon?crs=" + str(lyrCRS), str(selectedLayer) + '-fieldBoundsTest', "memory")

        def feature_added():            
            newLineLayer.featureAdded.disconnect() # Disconnect from the signal            
            newLineLayer.commitChanges()  # Save changes and end edit mode

            self.dlg.listWidget.clear()
            layers = self.iface.mapCanvas().layers()
            listOfLayers = []
            for layer in layers:
                if layer.type() == QgsMapLayer.VectorLayer:

                    feature = layer.getFeatures()
                    for featt in feature:
                        geom = featt.geometry()
                        if geom.type() == QgsWkbTypes.PolygonGeometry:                
                            #listOfLayersS.append(str(layerS.name())) 

                            listOfLayers.append(str(layer.name()))
                QCoreApplication.processEvents()
            self.dlg.listWidget.addItems(listOfLayers)
            #iface.setActiveLayer(layer1)

            try:
                nameToSelectAuto = str(selectedLayer) + '-fieldBoundsTest'
                print ('nameToSelectAuto', nameToSelectAuto)
                setAutoSelction = self.dlg.listWidget.findItems(str(nameToSelectAuto),Qt.MatchExactly)
                print ('row to select - check', setAutoSelction)
                if len(setAutoSelction)>0:
                    print ('row to select - check')
                    for selectMe in setAutoSelction:
                        
                        rowToSelect = int(self.dlg.listWidget.row(selectMe))
                        print ('row to select', rowToSelect)
                        self.dlg.listWidget.setCurrentRow(rowToSelect)
            except:
                print ('failed auto selection of field bunds in listwidget')
    
        newLineLayer.featureAdded.connect(feature_added) # Connect the layer to the signal featureAdded, so when a feature is added to the layer, the feature_added function is called         
        newLineLayer.startEditing() # Set the layer in edit mode        
        iface.actionAddFeature().trigger()  # Activate the QGIS add feature tool
        
        QgsProject.instance().addMapLayer(newLineLayer)

        newLineLayer.triggerRepaint()

        #newLineLayer.renderer().symbol().setColor(QColor.fromRgb(255, 0, 0))
        #newLineLayer.renderer().symbol().setOpacity(0.25) #setWidth(0.5)
        newLineLayer.renderer().symbol().setColor(QColor("transparent"))
        newLineLayer.renderer().symbol().symbolLayer(0).setStrokeColor(QColor("red")) #setStrokeColor(QColor("black"))
        newLineLayer.renderer().symbol().symbolLayer(0).setStrokeWidth(0.5) #setWidth(3)

        newLineLayer.triggerRepaint()
        QgsProject.instance().reloadAllLayers()
        


    def create_layer_for_line(self):
        print ('create line')

        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        layer1=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        print ('layer', layer)
        myfilepathP = layer.source()
        myfilepathP = os.path.dirname(myfilepathP)
        print ('myfilepathP', myfilepathP)

        #lyrCRS = layer.crs().authid() # returns a reference to the active QgsMapLayer
        #print('lyrCRS', lyrCRS)
        lyrCRS = str(self.dlg.lineEdit_3.text())
        print('lyrCRS', lyrCRS)

        newLineLayer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), str(selectedLayer) + '-fieldEdge', "memory")

        def feature_added():            
            newLineLayer.featureAdded.disconnect() # Disconnect from the signal            
            newLineLayer.commitChanges()  # Save changes and end edit mode

            self.dlg.listWidget_2.clear()

            # add available line type layers into interface
            layersS = self.iface.mapCanvas().layers()
            listOfLayersS = []
            for layerS in layersS:
                if layerS.type() == QgsMapLayer.VectorLayer:
                    #print ('layerS type', layerS.type())                
                    featureM = layerS.getFeatures()
                    for feat in featureM:
                        geomM = feat.geometry()
                        if geomM.type() == QgsWkbTypes.LineGeometry:                
                            listOfLayersS.append(str(layerS.name()))
                        QCoreApplication.processEvents()    
                QCoreApplication.processEvents()
            
            self.dlg.listWidget_2.addItems(listOfLayersS)            
    
            iface.setActiveLayer(layer1)

            try:
                nameToSelectAuto = str(selectedLayer) + '-fieldEdge'
                print ('nameToSelectAuto', nameToSelectAuto)
                setAutoSelction = self.dlg.listWidget_2.findItems(str(nameToSelectAuto),Qt.MatchExactly)
                print ('row to select - check', setAutoSelction)
                if len(setAutoSelction)>0:
                    print ('row to select - check')
                    for selectMe in setAutoSelction:
                        
                        rowToSelect = int(self.dlg.listWidget_2.row(selectMe))
                        print ('row to select', rowToSelect)
                        self.dlg.listWidget_2.setCurrentRow(rowToSelect)
                        QCoreApplication.processEvents()
                        self.extend_field_edge_line()
            except:
                print ('failed auto selection of field bunds in listWidget_2')
    
        newLineLayer.featureAdded.connect(feature_added) # Connect the layer to the signal featureAdded, so when a feature is added to the layer, the feature_added function is called         
        newLineLayer.startEditing() # Set the layer in edit mode        
        iface.actionAddFeature().trigger()  # Activate the QGIS add feature tool
        
        QgsProject.instance().addMapLayer(newLineLayer)

        newLineLayer.renderer().symbol().setWidth(0.5)
        newLineLayer.renderer().symbol().setColor(QColor.fromRgb(0, 0, 0))

        newLineLayer.triggerRepaint()

    def extend_field_edge_line(self):

        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer) 
        
        # improve this 
        findLongestLine = []
        for feature in layer.getFeatures():
            i = 0
            for v in feature.geometry().vertices():
                i += 1
                x = v.x()
                y = v.y()
                #print (i, x, y)
                
                if i >= 2:
                    print ('x', x, 'y', y)
                    print ('x1', x1, 'y1', y1)
                    print ('distance', math.dist([x,y], [x1,y1]))
                    findLongestLine.append(float(math.dist([x,y], [x1,y1])))
                x1 = x
                y1 = y
        findLongestLineFound = max(findLongestLine)
        print ('findLongestLineFound', findLongestLineFound)
        
        self.findLongestLineFoundUseLater = findLongestLineFound
        
        # extend line
        selectedLayer = str(self.dlg.listWidget_2.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer) 

        lengthExtend = findLongestLineFound/2 #100.0
        print ('lengthExtend', lengthExtend)

        def extend_line(feat, length):        
            g = feat.geometry()
            v = [v for v in g.vertices()]
            #n = g.extendLine(float(length), 0.0)
            n = g.extendLine(0.0, float(length))
            return QgsGeometry(n)        
        
        layer.selectByIds([1])
        with edit(layer):
            for f in layer.selectedFeatures():
                layer.changeGeometry(f.id(), extend_line(f, lengthExtend))
            # for f in layer.selectedFeatures():
                # layer.changeGeometry(f.id(), extend_line(f, lengthExtend))                
                         
        #retrieve feature geometry and check its new length
        f = layer.getFeature(1)
        print(f.geometry().length())
        #layer.commitChanges()
        layer.triggerRepaint()

        def extend_line(feat, length):        
            g = feat.geometry()
            v = [v for v in g.vertices()]
            n = g.extendLine(float(length), 0.0)
            #n = g.extendLine(0.0, float(length))
            return QgsGeometry(n)        
        
        layer.selectByIds([1])
        with edit(layer):
            for f in layer.selectedFeatures():
                layer.changeGeometry(f.id(), extend_line(f, lengthExtend))
            # for f in layer.selectedFeatures():
                # layer.changeGeometry(f.id(), extend_line(f, lengthExtend))                
                         
        #retrieve feature geometry and check its new length
        f = layer.getFeature(1)
        print(f.geometry().length())
        #layer.commitChanges()
        layer.triggerRepaint()

    def split_into_grids(self):

        #self.dlg.textBrowser.append('split into grids') 

        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer)

        # automatically select area based of selected layer in list of layers
        activeLayer = self.iface.activeLayer()
        for feature in activeLayer.getFeatures():
            activeLayer.select(feature.id())

        # center of field bounds
        ##############
        features = layer.selectedFeatures()
        for f in features:
            #geom = f.geometry()
            #print ('geom', geom)        
            centerOfPolygon = f.geometry().centroid().asPoint()
            print ('centerOfPolygon', centerOfPolygon)

        # field edge line
        keepLayerName = str(self.dlg.listWidget_2.currentItem().text())       
        layer = QgsProject.instance().mapLayersByName(keepLayerName)[0]
        
        #layer = iface.activeLayer()
        #selected = layer.selectedFeatures()
        for feature in layer.getFeatures():
            meI = 0
            for v in feature.geometry().vertices():
                if meI == 0:
                    meX1 = v.x()
                    meY1 = v.y()                    
                if meI == 1:
                    meX2 = v.x()
                    meY2 = v.y()                       
                meI = meI + 1
        print ('me----difMeC:', meX1, meY1, meX2, meY2)
        #difMeC = (y2-y1)/(x2-x1)
        difMeC = (meX2-meX1)    
        print ('me----difMeC:', difMeC)
        difMeCy = (meY2-meY1)    
        print ('me----difMeC Y:', difMeCy)

        #if difMeC >= 0:
        if meX2 < meX1:    
            x1 = meX1
            y1 = meY1            
            x2 = meX2
            y2 = meY2   
        #if difMeC < 0:
        if meX2 > meX1:            
            x1 = meX2
            y1 = meY2            
            x2 = meX1
            y2 = meY1

        #test
        def slopeTest(x1, y1, x2, y2): 
            return (y2-y1)/(x2-x1)
        def angleTest(s1, s2): 
            return math.degrees(math.atan((s2-s1)/(1+(s2*s1))))            
            
        lineATest = ((x1, y1), (x2, y2))
        lineBTest = ((x1, y1), (x2, y1))  

        slope1Test = slopeTest(lineATest[0][0], lineATest[0][1], lineATest[1][0], lineATest[1][1])
        slope2Test = slopeTest(lineBTest[0][0], lineBTest[0][1], lineBTest[1][0], lineBTest[1][1])        

        angTest = angleTest(slope1Test, slope2Test)
        # not good

        def slopeCheckHV(x1, x2, y1, y2):
            s = (abs(y2)-abs(y1))/(abs(x2)-abs(x1))
            return s        
        
        slopeChekcForLater = slopeCheckHV(x1, y1, x2, y2)
        print('slopeChekcForLater in = ', slopeChekcForLater)
        slopeChekcForLaterDegre = math.sin(math.radians(slopeChekcForLater))
        print('slopeChekcForLaterDegre in = ', slopeChekcForLaterDegre)

        angTest = angTest 

        self.angTest = angTest
        print('AngleTest in = ', angTest)

        # just for checking
        #lyrCRS = layer.crs().authid() # returns a reference to the active QgsMapLayer
        lyrCRS = str(self.dlg.lineEdit_3.text())
        print('lyrCRS', lyrCRS)

        v_layer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), 'lineEdgeTest', "memory")         
        v_layer.startEditing()

        pr = v_layer.dataProvider()
        seg = QgsFeature()

        start_point = QgsPoint(x1, y1)
        end_point = QgsPoint(x2, y2)
        #add first line
        seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
        pr.addFeatures([ seg ])
        v_layer.commitChanges()
        v_layer.triggerRepaint()
        QgsProject.instance().addMapLayers([v_layer])

        v_layer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), 'lineEdgeHorizontalTest', "memory")
        v_layer.startEditing()

        pr = v_layer.dataProvider()
        seg = QgsFeature()

        start_point = QgsPoint(x1, y1)
        end_point = QgsPoint(x2, y1)
        #add first line
        seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
        pr.addFeatures([ seg ])
        v_layer.commitChanges()
        v_layer.triggerRepaint()
        QgsProject.instance().addMapLayers([v_layer])

        # just for checking
        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer)


        ##############
        features = layer.selectedFeatures()
        for f in features:
            #geom = f.geometry()
            #print ('geom', geom)        
            centerOfPolygonTest = f.geometry().centroid().asPoint()
            print ('centerOfPolygonTest', centerOfPolygonTest)


        #layer.selectAll()
        clone_layer = processing.run("native:saveselectedfeatures", {'INPUT': layer, 'OUTPUT': 'memory:{}'.format(str(selectedLayer)+'_original-copy')})['OUTPUT']
        #layer.removeSelection()
        QgsProject.instance().addMapLayer(clone_layer)       

        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer + '_original-copy')[0]
        iface.setActiveLayer(layer)


        ##############
        features = layer.selectedFeatures()
        for f in features:
            #geom = f.geometry()
            #print ('geom', geom)        
            centerOfPolygonTest = f.geometry().centroid().asPoint()
            print ('centerOfPolygonTest', centerOfPolygonTest)

        #the spacing of the cut grid
        horizontalSpacing = float(self.dlg.lineEdit.text()) #10
        verticalSpacing = float(self.dlg.lineEdit_2.text()) #10

        selectedLayer = str(self.dlg.listWidget.currentItem().text())
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer)


        #get current layer, selection, CRS from QGIS map canvas
        layer = qgis.utils.iface.activeLayer()
        selected = layer.selectedFeatures()
        crs = qgis.utils.iface.activeLayer().crs().authid()



        for feature in selected:
            #get the extent of the selected feature
            #x_max, y_max, x_min, y_min = re.split(":|,",  feature.geometry().boundingBox().toString().replace(" ", ""))
            x_min, y_min, x_max, y_max = re.split(":|,",  feature.geometry().boundingBox().toString().replace(" ", ""))

        ## this might cause problems in some casees - pull it into checkbox condition MAYBE....
            x_min = str(float(x_min) - self.findLongestLineFoundUseLater/2)
            y_min = str(float(y_min) - self.findLongestLineFoundUseLater/2) 
            
            x_max = str(float(x_max) + self.findLongestLineFoundUseLater/2)
            y_max = str(float(y_max) + self.findLongestLineFoundUseLater/2)
            
            extent = x_min + "," + x_max + "," + y_min + "," + y_max
            print('extent----------', extent)

            #create our grid in memory - type 2 refers to rectangle
            grid_parameters = {"TYPE":  2,
                                            "EXTENT": extent,
                                            "HSPACING": horizontalSpacing,
                                            "VSPACING": verticalSpacing,
                                            "HOVERLAY": 0,
                                            "VOVERLAY": 0,
                                            "CRS": crs,
                                            "OUTPUT": "memory"}

            out1 = processing.run('native:creategrid', grid_parameters)

            #grid = QgsVectorLayer(out1['OUTPUT'], 'gridMe', 'ogr')
            grid = QgsVectorLayer(out1['OUTPUT'], str(activeLayer.name()) + '_grided', 'ogr')
            QgsProject().instance().addMapLayer(grid)


        self.dlg.x_min = float(x_min)   #(x_min)
        self.dlg.y_min = float(y_min)   #(y_min)
        self.dlg.x_max = float(x_max)   #(x_max)
        self.dlg.y_max = float(y_max)   #(y_min)  

        keepLayerName = str(self.dlg.listWidget.currentItem().text())       
        layer = QgsProject.instance().mapLayersByName(keepLayerName + '_grided')[0]
        iface.setActiveLayer(layer)
        print('extent------real----')
        print ('layer', layer)
        ext = layer.extent()
        print('extent------real----', ext)
        x_min = ext.xMinimum()
        y_min = ext.yMinimum()
        x_max = ext.xMaximum()
        y_max = ext.yMaximum()

        # rotate back to origianl
        keepLayerName = str(self.dlg.listWidget.currentItem().text())       
        layer = QgsProject.instance().mapLayersByName(keepLayerName + '_grided')[0]

        angTest = angTest #*(-1)

        provider = layer.dataProvider()
        couples_id_geom = []
        for feature in layer.getFeatures():
            geom = feature.geometry()
            centroid = QgsPointXY(centerOfPolygonTest) #xMe, yMe) #feature.geometry().centroid().asPoint()
            #centroid = feature.geometry().centroid().asPoint()
            #print ('centroid me as centar of all selected feature', centroid)
            #geom.rotate(rotation, centroid)
            geom.rotate(angTest, centroid)
            # accumulate args to avoid rotation feature by feature
            couples_id_geom.append([feature.id(), geom])

        # Change the layer features rotation in one go
        provider.changeGeometryValues({couple_id_geom[0]: couple_id_geom[1] for couple_id_geom in couples_id_geom})

    def rotate_grids(self):     
    
        # these horizontal and vertical spacing are oposite for use - not an error and are used later directly for shifting grids to aligne with field edge
        horizontalSpacing = float(self.dlg.lineEdit.text()) #10
        verticalSpacing = float(self.dlg.lineEdit_2.text()) #10

        widthMe = float(self.dlg.x_max)-float(self.dlg.x_min)
        print ('width', widthMe)
        heightMe = float(self.dlg.y_max)-float(self.dlg.y_min)
        print ('height', heightMe)        
        
        countFahrGme = heightMe/verticalSpacing
        #print('countFahrGme', str(countFahrGme))  
        counter = math.ceil(abs(countFahrGme)) *(-1)
        addingForExtension = counter * verticalSpacing #* 2 #float(self.dlg.lineEdit.text())

        print('countFahrGme', str(countFahrGme))
        print('addingForExtension', str(addingForExtension))
        self.addingForExtensionLaterMeasure = addingForExtension / 2
        
        angleMove = self.angTest #* (-1) #self.angle

        keepLayerName = str(self.dlg.listWidget.currentItem().text())       
        layer = QgsProject.instance().mapLayersByName(keepLayerName + '_grided')[0]
        #iface.setActiveLayer(layer)


        x = []
        y = []
        for f in layer.getFeatures():
            feat = QgsFeature()
            pt = f.geometry().centroid().asPoint()
            #print ('pt', pt[0], pt[1])
            x.append(float(pt[0]))
            y.append(float(pt[1]))
        
        xc, yc = sum(x)/len(x), sum(y)/len(y)
        print ('center', xc, yc)

        lyrCRS = str(self.dlg.lineEdit_3.text())
        print('lyrCRS', lyrCRS)

        #layer =  QgsVectorLayer('Point?crs=epsg:4326', 'MyPoint' , "memory")
        layer = QgsVectorLayer("Point?crs=" + str(lyrCRS), 'centerOfGriddedBoundingBox', "memory")
        pr = layer.dataProvider()
        pt = QgsFeature()
        point1 = QgsPointXY(xc, yc)  #1 correction
        pt.setGeometry(QgsGeometry.fromPointXY(point1)) #2 correction
        pr.addFeatures([pt])
        layer.updateExtents()
        QgsProject.instance().addMapLayers([layer])

        plotCoordinate = 'coordinate'
        for i in range(0,4):
            angleMove = angleMove
            print ('angle', angleMove)
            v_layer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), str(plotCoordinate) + '_' + str(i) , "memory") 
            v_layer.startEditing()
            pr = v_layer.dataProvider()
            seg = QgsFeature()
            
            start_point = QgsPoint(xc, yc)             
            #new_x = xc + ((addingForExtension) /2) * math.sin(math.radians(angleMove))
            #new_y = yc + ((addingForExtension) /2) * math.cos(math.radians(angleMove)) 
            new_x = xc + ((addingForExtension)) * math.sin(math.radians(angleMove))
            new_y = yc + ((addingForExtension)) * math.cos(math.radians(angleMove))      
            
            end_point = QgsPoint(new_x, new_y)

            seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
            pr.addFeatures([ seg ])
            v_layer.commitChanges()
            v_layer.triggerRepaint()
            QgsProject.instance().addMapLayers([v_layer])
            

            QgsProject.instance().reloadAllLayers()
            QCoreApplication.processEvents()
            
            layer2Name =  str(plotCoordinate) + '_' + str(i)
            print ('layer2', layer2Name)
            
            try:
                f = v_layer.getFeature(1)
                keepLayerName = str(self.dlg.listWidget_2.currentItem().text())
                layer1 = QgsProject.instance().mapLayersByName(keepLayerName)[0]
                #layer2Name =  str(plotCoordinate) + '_' + str(i)
                layer2 = QgsProject.instance().mapLayersByName(layer2Name)[0]

            
                for f in layer1.getFeatures():
                    for a in layer2.getFeatures():
                        if a.geometry().intersects(f.geometry()):
                            intersection = a.geometry().intersection(f.geometry()).asPoint()
                            print ('intersection', i)
                            print ('intersection angle', angleMove)
                            angleMoveIntersect = angleMove
                            print ('intersection angle', angleMoveIntersect)
                            
                            #check this here
                            edgelinelenghtNewDiffAgainC = float(a.geometry().length())
                            print ('edgelinelenghtNewDiffAgainC', edgelinelenghtNewDiffAgainC)                            
                            
            except:
                print ('doesnt intersect', i)
            
            QgsProject.instance().reloadAllLayers()
            QCoreApplication.processEvents()
            
            angleMove = angleMove + 90
        print ('intersection angle', angleMoveIntersect)
        self.angleMoveIntersectTest  = angleMoveIntersect
        
        v_layer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), 'foundRightEdgeIntersect' , "memory") 
        v_layer.startEditing()
        pr = v_layer.dataProvider()
        seg = QgsFeature()
        
        start_point = QgsPoint(xc, yc)             
        #new_x = xc + ((addingForExtension) /2) * math.sin(math.radians(angleMoveIntersect))
        #new_y = yc + ((addingForExtension) /2) * math.cos(math.radians(angleMoveIntersect))
        new_x = xc + ((addingForExtension)) * math.sin(math.radians(angleMoveIntersect))
        new_y = yc + ((addingForExtension)) * math.cos(math.radians(angleMoveIntersect))          
        end_point = QgsPoint(new_x, new_y)

        seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
        pr.addFeatures([ seg ])
        v_layer.commitChanges()
        v_layer.triggerRepaint()
        QgsProject.instance().addMapLayers([v_layer])        



        v_layer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), 'findEdgeOfFieldBound', "memory")
        v_layer.startEditing()

        pr = v_layer.dataProvider()
        seg = QgsFeature()

        start_point = QgsPoint(xc, yc)
        end_point = QgsPoint(intersection)
        
        #add first line
        seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
        pr.addFeatures([ seg ])
        v_layer.commitChanges()
        v_layer.triggerRepaint()
        QgsProject.instance().addMapLayers([v_layer])


        f = v_layer.getFeature(1)
        #print('needed lenght', f.geometry().length())
        edgelinelenghtNewDiffAgainCc = float(f.geometry().length())
        print ('edgelinelenghtNewDiffAgainCc', edgelinelenghtNewDiffAgainCc)

        #angle = self.angle
        #self.difference = edgelinelenghtNewDiffAgainC - edgelinelenghtNewDiffAgainCc #10 #self.difference #10
        self.difference =  abs(self.addingForExtensionLaterMeasure) - edgelinelenghtNewDiffAgainCc
        #difference = edgelinelenghtNewDiffAgainCc - edgelinelenghtNewDiffAgainC  #10 #self.difference #10
        print ('self.difference', self.difference)


    def move_grids(self):

        difference = self.difference
        print ('difference', difference)

        keepLayerName = str(self.dlg.listWidget.currentItem().text())       
        layer = QgsProject.instance().mapLayersByName(keepLayerName + '_grided')[0]
        iface.setActiveLayer(layer)
        print ('layer', layer)

        angleMove = self.angleMoveIntersectTest #self.angTest * (-1)
        print ('angleMove', angleMove)    
    
        for feat in layer.getFeatures():
            geom = feat.geometry()
            

            factorReduceY = math.cos(math.radians((angleMove))) * float(difference)
            factorReduceX = math.sin(math.radians((angleMove))) * float(difference) #factorReduceY

            geom.translate(factorReduceX, factorReduceY) # translation
            fid = feat.id()
            layer.dataProvider().changeGeometryValues({ fid : geom })

        layer.triggerRepaint()
        #QgsProject.instance().reloadAllLayers()            
        QgsProject.instance().reloadAllLayers()
        QCoreApplication.processEvents()        
        
        # clipe the grids according to field bounds ################

        keepLayerName = str(self.dlg.listWidget.currentItem().text())
        
        input_layer = QgsProject.instance().mapLayersByName(keepLayerName + '_grided')[0]
        
        
        clipBy = str(keepLayerName) #+'_original-copy' #'output'
        keepLayer = QgsProject.instance().mapLayersByName(clipBy)[0]
        print ('keepLayer', keepLayer)

        alg_params1 = {
            'INPUT' : input_layer,
            'OVERLAY' : keepLayer,
            'OUTPUT' : 'memory:{}'.format(keepLayerName+'_grided_cliped')
            }
        
        outMe = processing.run("native:clip", alg_params1)['OUTPUT']
        QgsProject().instance().addMapLayer(outMe)
        QgsProject.instance().reloadAllLayers()
        QCoreApplication.processEvents()
    
    def draw_tractor_grids(self):
        print ('draw tractor tracks')
        
        selectedLayer = str(self.dlg.listWidget_2.currentItem().text())# + '-fieldEdge'
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer)

        for feature in layer.getFeatures():
            countM = 0
            for v in feature.geometry().vertices():
                countM += 1
                if countM == 1:
                    x1 = float(v.x())
                    y1 = float(v.y())
                if countM == 2:
                    x2 = float(v.x())
                    y2 = float(v.y())      
 
        print ('x1', x1, 'y1', y1)
        print ('x2', x2, 'y2', y2) 

        start_point = QgsPoint(x1, y1) 
        end_point = QgsPoint(x2, y2)

        lyrCRS = str(self.dlg.lineEdit_3.text())
        print('lyrCRS', lyrCRS)

        v_layer = QgsVectorLayer("LineString?crs=" + str(lyrCRS), 'myPointLineCheck', "memory")
        v_layer.startEditing()

        pr = v_layer.dataProvider()
        seg = QgsFeature()

        #add first line
        seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
        pr.addFeatures([ seg ])
        # add the rest
        angle =  float(self.angleMoveIntersectTest) #float(self.dlg.lineEdit_4.text())

        heightMe = float(self.dlg.y_max)-float(self.dlg.y_min)
        widthMe = float(self.dlg.x_max)-float(self.dlg.x_min)
        
        # heightMe = float(y_max)-float(y_min)
        # widthMe = float(x_max)-float(x_min)        
        
        print('heightMe', str(heightMe))
        print('widthMe', str(widthMe))

        horizontalSpacing = float(self.dlg.lineEdit.text()) #10
        verticalSpacing = float(self.dlg.lineEdit_2.text()) #10

        #self.countFahrGme = heightMe/verticalSpacing
        self.countFahrGme = (self.findLongestLineFoundUseLater+heightMe)/verticalSpacing
        print('countFahrGme', str(self.countFahrGme))
        
        #for i in range(0,abs(int((self.countFahrGme)*2.5))):
        for i in range(0,abs(int((self.countFahrGme)))):    
            print (' loop ', i)
            #float(self.dlg.lineEdit_3.text())
            
            # 0.5 draw truck tracks through plot

            #y1n = y1 + float(self.dlg.lineEdit_3.text())#*0.5
            #y2n = y2 + float(self.dlg.lineEdit_3.text())#*0.5
            y1n = y1 + float(self.dlg.lineEdit_4.text())*0.5
            y2n = y2 + float(self.dlg.lineEdit_4.text())*0.5

            # x1 = math.sin(math.radians((angle))) * (y1n - y1) + x1
            # y1 = math.cos(math.radians((angle))) * (y1n - y1) + y1

            # x2 = math.sin(math.radians((angle))) * (y2n - y2) + x2
            # y2 = math.cos(math.radians((angle))) * (y2n - y2) + y2
            
            x1 = math.sin(math.radians((angle))) * (y1n - y1) + x1
            y1 = math.cos(math.radians((angle))) * (y1n - y1) + y1

            x2 = math.sin(math.radians((angle))) * (y2n - y2) + x2
            y2 = math.cos(math.radians((angle))) * (y2n - y2) + y2            
            
            
            #x1 =  x1 * math.cos(math.radians((angle))) - y1 * math.sin(math.radians((angle)))
            #y1 =  x1 * math.sin(math.radians((angle))) + y1 * math.cos(math.radians((angle)))

            # x2 =  x2 * math.cos(math.radians((angle))) - y2 * math.sin(math.radians((angle)))
            # y2 =  x2 * math.sin(math.radians((angle))) + y2 * math.cos(math.radians((angle)))

            start_point = QgsPoint(x1, y1)
            end_point = QgsPoint(x2, y2) 
            
            # this here is for tracks - get every second
            #if i % 2 == 0:            
            #seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
            if i % 2 == 0:
                seg.setGeometry(QgsGeometry.fromPolyline([start_point, end_point]))
                pr.addFeatures([ seg ])
                
        v_layer.commitChanges()       
        
        v_layer.triggerRepaint()
        QgsProject.instance().addMapLayers([v_layer])
       
        print ('crop outbound parts')
        #keepLayerName = str(self.dlg.listWidget_2.currentItem().text())
        keepLayerName = str(self.dlg.listWidget.currentItem().text())
        
        keepLayer  = QgsProject.instance().mapLayersByName(keepLayerName)[0]
        
        selectedLayerClipTrackMe = 'myPointLineCheck'
        input_layer = QgsProject.instance().mapLayersByName(selectedLayerClipTrackMe)[0]
        print ('keepLayer', keepLayer)

        alg_params1 = {
            'INPUT' : input_layer,
            'OVERLAY' : keepLayer,
            'OUTPUT' : 'memory:{}'.format(keepLayerName+'_clipedTracks')
            }
        
        outMe = processing.run("native:clip", alg_params1)['OUTPUT']
        QgsProject().instance().addMapLayer(outMe)  

        #change style of the tracks    
        v_layer = QgsProject.instance().mapLayersByName(keepLayerName+'_clipedTracks')[0]
        v_layer.renderer().symbol().setWidth(1.0)
        v_layer.renderer().symbol().setColor(QColor.fromRgb(0, 0, 0))
        v_layer.triggerRepaint() 

        selectedLayer = keepLayerName + '_clipedTracks' #str(self.dlg.listWidget_2.currentItem().text())
        print ('selectedLayer check', selectedLayer)
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer)

        f = layer.getFeature(1)
        print('before', f.geometry().length())

        lengthShorten = 2

        def shorten_line(feat, length):
            '''Returns a linestring geometry shortened by the given length.
            Takes two arguments- a QgsFeature object and a double value'''
            g = feat.geometry()
            v = [v for v in g.vertices()]
            print ('v', v)

            # layer = QgsVectorLayer("Point?crs=" + str(lyrCRS), 'x_min,y_min', "memory")
            # pr = layer.dataProvider()
            # pt = QgsFeature()
            # point1 = QgsPointXY(v[-2])  #1 correction
            # pt.setGeometry(QgsGeometry.fromPointXY(point1)) #2 correction
            # pr.addFeatures([pt])
            # layer.updateExtents()
            # QgsProject.instance().addMapLayers([layer])

            v.remove(v[-1])
            v.append(QgsPoint(g.interpolate(g.length()-length).asPoint()))
            n = QgsLineString(v)
            return QgsGeometry(n)
            

        # example usage ! This will permanently modify the selected features in
        # your active layer!
        countfET = 1
        for feat in layer.getFeatures():
            #geom = feat.geometry()
            countfET = countfET +1
            print ('countfET', countfET)
        
        for i in range(1,countfET):
            layer.selectByIds([i])        
            with edit(layer):
                for f in layer.selectedFeatures():
                    try:
                        layer.changeGeometry(f.id(), shorten_line(f, lengthShorten))
                    except:
                        print ('failed to shorten track - left')
        f = layer.getFeature(1)
        print('after', f.geometry().length())
        layer.commitChanges()
        layer.triggerRepaint()
        QgsProject.instance().reloadAllLayers()   

        # other side
        selectedLayer = keepLayerName + '_clipedTracks' #str(self.dlg.listWidget_2.currentItem().text())
        print ('selectedLayer check', selectedLayer)
        layer=QgsProject.instance().mapLayersByName(selectedLayer)[0]
        iface.setActiveLayer(layer)

        f = layer.getFeature(1)
        print('before', f.geometry().length())

        #lengthShortenN = 5
        #newLineS = float(f.geometry().length()) - lengthShorten

        def shorten_lineS(feat, length):
            '''Returns a linestring geometry shortened by the given length.
            Takes two arguments- a QgsFeature object and a double value'''
            g = feat.geometry()
            v = [v for v in g.vertices()]
            v.remove(v[-2])
            v.append(QgsPoint(g.interpolate(g.length()-length).asPoint()))
            n = QgsLineString(v)
            return QgsGeometry(n)
            
        # example usage ! This will permanently modify the selected features in
        # your active layer!
        countfET = 1
        for feat in layer.getFeatures():
            #geom = feat.geometry()
            countfET = countfET +1
            print ('countfET', countfET)
        
        for i in range(1,countfET):
            layer.selectByIds([i])        
            with edit(layer):
                for f in layer.selectedFeatures():
                    newLineS = float(f.geometry().length()) - lengthShorten
                    try:
                        layer.changeGeometry(f.id(), shorten_lineS(f, newLineS))
                    except:
                        print ('failed to shorten track - right')
        # example usage ! This will permanently modify the selected features in
        # your active layer!
        # layer.selectByIds([1])
        # with edit(layer):
            # for f in layer.selectedFeatures():
                # layer.changeGeometry(f.id(), shorten_lineS(f, newLineS))                
                         
        #retrieve feature geometry and check its new length
        f = layer.getFeature(1)
        print('after', f.geometry().length())
        layer.commitChanges()
        layer.triggerRepaint()
        QgsProject.instance().reloadAllLayers()        

        # remove layer used for track creation
        lineEdgeTest = 'myPointLineCheck'
        input_layer0 = QgsProject.instance().mapLayersByName(lineEdgeTest)[0]            
        #QgsProject.instance().layerTreeRoot().findLayer(input_layer0).setItemVisibilityChecked(False)
        QgsProject.instance().removeMapLayer(input_layer0)
        QCoreApplication.processEvents()
        
        QgsProject.instance().reloadAllLayers()
       # add available layers into interface
        layers = self.iface.mapCanvas().layers()
        self.dlg.comboBox.clear()
        listOfLayers = []
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                listOfLayers.append(str(layer.name()))
            QCoreApplication.processEvents()
        
        self.dlg.comboBox.addItems(listOfLayers)
        QCoreApplication.processEvents()

        # selectedLayerN = keepLayerName + '_clipedTracks'    
        # layer = QgsProject.instance().mapLayersByName(selectedLayerN)[0]
        # iface.setActiveLayer(layer)
        # print ('layer', layer)

        # layer = iface.activeLayer()

        # parameters = { 'DISTANCE' : -5, #offset of 5 meters
                       # 'INPUT' : layer, 
                       # 'JOIN_STYLE' : 1, 
                       # 'MITER_LIMIT' : 1, 
                       # 'OUTPUT' : 'TEMPORARY_OUTPUT', 
                       # 'SEGMENTS' : 8 }

        # processing.runAndLoadResults('qgis:offsetline', parameters)
        # QgsProject.instance().reloadAllLayers()
        # #outMe = processing.run("native:clip", alg_params1)['OUTPUT']
        # #QgsProject().instance().addMapLayer(outMe) 


    def select_output_directory_manually(self):
        ###### find directroy
        selectWorkingDir = QFileDialog.getExistingDirectory()
        selectWorkingDir = os.path.normpath(selectWorkingDir)
        print ('selected dir', selectWorkingDir)
            
        selectWorkingDir = selectWorkingDir 
        selectWorkingDir = os.path.normpath(selectWorkingDir)
        self.dlg.lineEdit_5.setText(selectWorkingDir)
        self.dlg.pushButton_11.setEnabled(True)
        self.dlg.lineEdit_5.setEnabled(True)

    def export_shape_file(self):
        print ('save  shape file')

        myfilepathPd = str(self.dlg.lineEdit_5.text()) 
        print ('myfilepathPd', myfilepathPd)        
        myfilepathPd = os.path.normpath(myfilepathPd)
        print ('myfilepathPd norm', myfilepathPd)

        selectedLayer = str(self.dlg.comboBox.currentText())    
        layer = QgsProject.instance().mapLayersByName(selectedLayer)[0] 

        iface.setActiveLayer(layer)
        layer.selectAll()
        clone_layer = processing.run("native:saveselectedfeatures", {'INPUT': layer, 'OUTPUT': 'memory:{}'.format(str(selectedLayer)+'_exported')})['OUTPUT']        
        layer.removeSelection()
        QgsProject.instance().addMapLayer(clone_layer)
                       
        activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        #selectedLayer = 'nameTest'
        nameFile = selectedLayer + '.shp'
        print ('nameFile', nameFile)

        iface.setActiveLayer(activeLayer)        
        keepOnly = ['id', str(self.dlg.comboBox.currentText())]
        fields = []
        fieldnames = set(keepOnly)
        for field in activeLayer.fields():
            if field.name() not in fieldnames:
                idx = activeLayer.dataProvider().fieldNameIndex(field.name())
                fields.append(idx)
        print ('fields to remove', fields)   
        
        activeLayer.dataProvider().deleteAttributes(fields)
        activeLayer.updateFields()

        write = QgsVectorFileWriter.writeAsVectorFormat(activeLayer,str(myfilepathPd) + '//' + str(nameFile), "utf-8",driverName="ESRI Shapefile")
