# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CreateCustomProjection
                                 A QGIS plugin
 This plugin adds the Coordinate Reference System of a layer to Custom Projection List.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-05-26
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Murat Çalışkan
        email                : caliskan.murat.20@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox

from qgis.core import QgsProject, QgsCoordinateReferenceSystem

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .create_custom_projection_dialog import CreateCustomProjectionDialog
import os.path


class CreateCustomProjection:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CreateCustomProjection_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Custom Projection Creator')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CreateCustomProjection', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/create_custom_projection/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Custom Projection Creator'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Custom Projection Creator'),
                action)
            self.iface.removeToolBarIcon(action)

    def getFile(self):
        self.dlg.le_crsFile.setText("")
        self.path, self._filter = QFileDialog.getOpenFileName(self.dlg, "Select file", "", 'All Files(*.*) ;; prj (*.prj) ;; txt(*.txt)')        
        try:
            self.dlg.le_crsFile.setText(self.path)
            with open(self.path, "r") as f:
                self.text = f.read()
            
            self.dlg.te_crs.setText(self.text)
        except:
            pass

    def getCrs(self):
        self.name = self.dlg.cb_layers.currentText()
        try:
            self.layer = QgsProject.instance().mapLayersByName(self.name)[0]
            self.crs = self.layer.crs()
            self.wkt = self.crs.toWkt()
            self.dlg.te_crs.setText(self.wkt)
        except:
            pass
        
    def addCrs(self):
        self.wkt = self.dlg.te_crs.toPlainText()
        self.name = self.dlg.le_name.text()
        self.new_crs = QgsCoordinateReferenceSystem()
        self.new_crs.createFromWkt(self.wkt)
        if self.name.strip():
            if self.new_crs.isValid():
                self.new_crs.saveAsUserCrs(self.name)                
                self.msgBox = QMessageBox()
                self.msgBox.setIcon(QMessageBox.Information)
                self.msgBox.setText("New CRS added!")
                self.msgBox.setStandardButtons(QMessageBox.Ok)
                self.returnValue = self.msgBox.exec()
            else:
                self.msgBox = QMessageBox()
                self.msgBox.setIcon(QMessageBox.Information)
                self.msgBox.setText("Invalid CRS!")
                self.msgBox.setStandardButtons(QMessageBox.Ok)
                self.returnValue = self.msgBox.exec()
        else:
            self.msgBox = QMessageBox()
            self.msgBox.setIcon(QMessageBox.Information)
            self.msgBox.setText("Invalid name!")
            self.msgBox.setStandardButtons(QMessageBox.Ok)
            self.returnValue = self.msgBox.exec()
            
    def clear(self):
        self.dlg.te_crs.setText('')
        self.dlg.le_name.setText('')
        self.dlg.le_crsFile.setText('')
    
    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            # self.first_start = False
            self.dlg = CreateCustomProjectionDialog()
            self.layers = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
            
            
            self.dlg.cb_layers.addItems(self.layers)
            self.getCrs()
            
            self.dlg.cb_layers.currentTextChanged.connect(self.getCrs)
            
            self.dlg.btn_close.clicked.connect(lambda x:self.dlg.close())
            self.dlg.btn_add.clicked.connect(self.addCrs)
            
            self.dlg.tb_browse.clicked.connect(self.getFile)
            
            self.dlg.tabWidget.currentChanged.connect(self.clear)
            

        # show the dialog
        self.dlg.show()
        
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
