# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BathCreatorDialog
                                 A QGIS plugin
 Helps to create CE-QUAL-W2 Bathymetric file 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-02-04
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Yoav Bornstein
        email                : yoavborenst@gmail.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets
#from PyQt5.QtWidgets import QFileDialog

from .create_bathymetry_dialog import Ui_BathCreatorDialogBase

class BathCreatorDialog(QtWidgets.QDialog):
    def __init__(self, parent=None):
        """Constructor."""
        super(BathCreatorDialog, self).__init__(parent)
        self.ui = Ui_BathCreatorDialogBase()
        self.ui.setupUi(self)
        self.delta_valid = True
        self.delta_value = ""
        self.csv_value = ""
        self.dem_value = self.ui.dem.currentLayer().name()
        self.line_value = self.ui.line.currentLayer().name()
        self.polygone_value = self.ui.polygone.currentLayer().name()
        self.updateOkButton()
        self.ui.delta.textChanged.connect(self.updateDelta)
        self.ui.csv.textChanged.connect(self.updateCsv)
        self.ui.dem.layerChanged.connect(self.updateDem)
        self.ui.line.layerChanged.connect(self.updateLine)
        self.ui.polygone.layerChanged.connect(self.updatePolygone)
        self.ui.browsebttn.clicked.connect(self.getFile)
        
    def updateOkButton(self):
        if self.delta_valid and self.delta_value and self.csv_value:
            self.ui.button_box.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(True)
        else:
            self.ui.button_box.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(False)

    def updateDelta(self, newText):
        self.delta_value = newText
        try:
            if self.delta_value:
                delta = float(self.delta_value)
                self.delta_valid = 0 < delta
            else:
                self.delta_valid = True
        except:
            self.delta_valid = False
        if not self.delta_valid:
            self.ui.delta.setStyleSheet("background-color: rgb(238, 169, 169);")
        else:
            self.ui.delta.setStyleSheet("")
        self.updateOkButton()

    def updateCsv(self, newText):
        self.csv_value = newText
        self.updateOkButton()

    def updateDem(self, layer):
        self.dem_value = layer.name()

    def updateLine(self, layer):
        self.line_value = layer.name()

    def updatePolygone(self, layer):
        self.polygone_value = layer.name()
        
    def getFile(self):
        self.ui.csv.setText(QtWidgets.QFileDialog.getSaveFileName(self, 'Save File', '', 'CSV(*.csv)')[0])