# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Covid19Tracker
                                 A QGIS plugin
 This plugin tracks COVID19 live
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-03-11
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Pawel Dzierzynski/The Map Workdhop
        email                : themapworkshop@gmail.com  
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QColor
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Covid19_Tracker_dialog import Covid19TrackerDialog
import os.path
from qgis import *
from qgis.core import *


class Covid19Tracker:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Covid19Tracker_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Covid19 Tracker')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Covid19Tracker', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Covid19_Tracker/coronacon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Track COVID19'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Covid19 Tracker'),
                action)
            self.iface.removeToolBarIcon(action)

    def openworld(self):
        from qgis.core import QgsApplication
        from qgis.core import QgsProject
        #import qgis.core.QgsSymbol.QgsFillSymbol
        #from QgsSymbol import QgsFillSymbol
        pathtoworld = QgsApplication.qgisSettingsDirPath() + '/python/plugins/covid19_tracker'
        self.iface.addVectorLayer(pathtoworld + '/TM_WORLD_BORDERS-0.3.shp', 'World', 'ogr')
        a = self.iface.activeLayer()
        #ren = a.renderer()
        #sym0 = ren.symbol()[0].properties()
        sym = QgsFillSymbol.createSimple(
            {'style':'solid', 'color': '#343231', 'style_border':'no'})
        a.renderer().setSymbol(sym)
        a.triggerRepaint()  # Refresh Layer
        self.iface.layerTreeView().refreshLayerSymbology(a.id())
        a.setName(a.name().replace(a.name(), 'World Background Map'))

    def cases(self):
        import requests
        from qgis.core import QgsProject
        self.openworld()
        cases = 'https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_19-covid-Confirmed.csv'
        #death= 'https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_19-covid-Deaths.csv'
        r = requests.get(cases)
        csvtekst = r.text
        # write artificial file
        pathtocases = QgsApplication.qgisSettingsDirPath() + '/python/plugins/covid19_tracker'
        f = open(pathtocases + '/temp1.txt', "w+")
        f.write(r.text)
        f.close()
        import pandas as pd
        import os
        df = pd.read_csv(pathtocases + '/temp1.txt', delimiter=',')
        df.to_csv(pathtocases +'/cases.csv')

        os.remove(pathtocases + '/temp1.txt')

        f = pd.read_csv(pathtocases + '/cases.csv', delimiter=',')
        vl = qgis.core.QgsVectorLayer("Point", 'Cases', "memory")
        QgsProject.instance().addMapLayer(vl)
        from qgis.PyQt.QtCore import QVariant
        pr = vl.dataProvider()
        pr.addAttributes(
            [QgsField("Lat", QVariant.String), QgsField("Lon", QVariant.String), QgsField("Cases", QVariant.Double)])
        vl.updateFields()
        for i in range(len(f['Lat'])):
            import numpy as np
            F = QgsFeature()
            F.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(f['Long'][i], f['Lat'][i])))
            k = f[str(list(f)[-1:])[2:-2]]
            F.setAttributes([str(f['Lat'][i]), str(f['Long'][i]), int(k[i]) * 1])  # f[f[str(list(f)[-1:])[2:-2]]][i]
            # pr = vl.dataProvider()
            pr.addFeature(F)
            vl.updateExtents()
            # QgsProject.instance().addMapLayer(vl)
            # END OF CSV str(list(df)[-1:])[2:-2]

        shp = self.iface.activeLayer()
        target_field = 'Cases'  # Define the target field inf the attribute table of the EU map
        myRangeList = []  # Define the intervals and their respective colors
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fcfcfc"))
        myRange = QgsRendererRange(0, 10, symbol, '0 - 10')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f8c8c8"))
        myRange = QgsRendererRange(10, 100, symbol, '10 - 100')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fc7e81"))
        myRange = QgsRendererRange(100, 1000, symbol, '100 - 1000')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fe4044"))
        myRange = QgsRendererRange(1000, 10000, symbol, '1000 - 10,000')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f90005"))
        myRange = QgsRendererRange(10000, 100000, symbol, '1000 - 100,000')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f807b8"))
        myRange = QgsRendererRange(100000, 1000000, symbol, '100,000 - 1000,000')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        self.dlg.lineEdit.setText(str(list(f)[-1:])[2:-2])

    def death(self):
        self.openworld()
        import requests
        from qgis.core import QgsProject
        deaths = 'https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_19-covid-Deaths.csv'
        r = requests.get(deaths)
        csvtekst = r.text
        # write artificial file
        pathtodeaths = QgsApplication.qgisSettingsDirPath() + '/python/plugins/covid19_tracker'
        f = open(pathtodeaths + "/temp.txt", "w+")
        f.write(r.text)
        f.close()
        import pandas as pd
        import os
        df = pd.read_csv(pathtodeaths + "/temp.txt", delimiter=',')
        df.to_csv(pathtodeaths + '/deaths.csv')

        os.remove(pathtodeaths + "/temp.txt")

        f = pd.read_csv(pathtodeaths + '/deaths.csv', delimiter=',')
        vl = qgis.core.QgsVectorLayer("Point", 'Deaths', "memory")
        QgsProject.instance().addMapLayer(vl)
        from qgis.PyQt.QtCore import QVariant
        pr = vl.dataProvider()
        pr.addAttributes([QgsField("Lat",  QVariant.String), QgsField("Lon", QVariant.String), QgsField("Deaths",  QVariant.Double)])
        vl.updateFields()
        for i in range(len(f['Lat'])):
            import numpy as np
            F = QgsFeature()
            F.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(f['Long'][i], f['Lat'][i])))
            k = f[str(list(f)[-1:])[2:-2]]
            F.setAttributes([str(f['Lat'][i]),str(f['Long'][i]), int(k[i]) * 1])  #f[f[str(list(f)[-1:])[2:-2]]][i]
            #pr = vl.dataProvider()
            pr.addFeature(F)
            vl.updateExtents()
            #QgsProject.instance().addMapLayer(vl)
            # END OF CSV str(list(df)[-1:])[2:-2]

        shp = self.iface.activeLayer()
        target_field = 'Deaths'  # Define the target field inf the attribute table of the EU map
        myRangeList = []  # Define the intervals and their respective colors
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fcfcfc"))
        myRange = QgsRendererRange(0, 1, symbol, '0 - 1')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f8c8c8"))
        myRange = QgsRendererRange(1, 10, symbol, '1 - 10')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fc7e81"))
        myRange = QgsRendererRange(10, 100, symbol, '10 - 100')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fe4044"))
        myRange = QgsRendererRange(100, 1000, symbol, '100 - 1000')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f90005"))
        myRange = QgsRendererRange(1000, 10000, symbol, '100 - 10000')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)

        self.dlg.lineEdit.setText(str(list(f)[-1:])[2:-2])


    def stat(self):
        self.openworld() #Load basemap
        import requests
        from qgis.core import QgsProject
        #Read data on deaths and save to csv file
        deaths = 'https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_19-covid-Deaths.csv'
        r = requests.get(deaths)
        # write artificial file
        pathtodeaths = QgsApplication.qgisSettingsDirPath() + '/python/plugins/covid19_tracker'
        f = open(pathtodeaths + "/temp.txt", "w+")
        f.write(r.text)
        f.close()
        import pandas as pd
        import os
        df = pd.read_csv(pathtodeaths + "/temp.txt", delimiter=',')
        df.to_csv(pathtodeaths + '/deaths.csv')

        os.remove(pathtodeaths + "/temp.txt")

        f = pd.read_csv(pathtodeaths + '/deaths.csv', delimiter=',')

        #Read data on cases and save to csv file
        cases = 'https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_19-covid-Confirmed.csv'
        # death= 'https://raw.githubusercontent.com/CSSEGISandData/COVID-19/master/csse_covid_19_data/csse_covid_19_time_series/time_series_19-covid-Deaths.csv'
        r1 = requests.get(cases)
        # write artificial file
        pathtocases = QgsApplication.qgisSettingsDirPath() + '/python/plugins/covid19_tracker'
        f1 = open(pathtocases + '/temp1.txt', "w+")
        f1.write(r1.text)
        f1.close()
        df1 = pd.read_csv(pathtocases + '/temp1.txt', delimiter=',')
        df1.to_csv(pathtocases + '/cases.csv')

        os.remove(pathtocases + '/temp1.txt')

        f1 = pd.read_csv(pathtocases + '/cases.csv', delimiter=',')

        #Create QGIS point layer and set fields
        vl = qgis.core.QgsVectorLayer("Point", 'Death Probability', "memory")
        QgsProject.instance().addMapLayer(vl)
        from qgis.PyQt.QtCore import QVariant
        pr = vl.dataProvider()
        pr.addAttributes(
            [QgsField("Lat", QVariant.String), QgsField("Lon", QVariant.String), QgsField("DeathP", QVariant.Double)])
        vl.updateFields()

        #Now update fields
        for i in range(len(f['Lat'])):
            import numpy as np
            F = QgsFeature()
            F.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(f['Long'][i], f['Lat'][i])))
            k = f[str(list(f)[-1:])[2:-2]]
            k1 = f1[str(list(f1)[-1:])[2:-2]]
            if k1[i] != 0:
                F.setAttributes([str(f['Lat'][i]), str(f['Long'][i]), (int(k[i]) * 100) / int(k1[i])])
                pr.addFeature(F)
                vl.updateExtents()

             # f[f[str(list(f)[-1:])[2:-2]]][i]
            # pr = vl.dataProvider()

            # QgsProject.instance().addMapLayer(vl)
            # END OF CSV str(list(df)[-1:])[2:-2]

        shp = self.iface.activeLayer()
        target_field = 'DeathP'  # Define the target field inf the attribute table of the EU map
        myRangeList = []  # Define the intervals and their respective colors
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fcfcfc"))
        myRange = QgsRendererRange(0, 1, symbol, '0 - 1%')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f8c8c8"))
        myRange = QgsRendererRange(1, 2, symbol, '1 - 2%')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fc7e81"))
        myRange = QgsRendererRange(2, 3, symbol, '2 - 3%')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#fe4044"))
        myRange = QgsRendererRange(3, 4, symbol, '3 - 4%')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f90005"))
        myRange = QgsRendererRange(4, 5, symbol, '4 - 5%')
        myRangeList.append(myRange)
        symbol = QgsSymbol.defaultSymbol(shp.geometryType())
        symbol.setColor(QColor("#f807b8"))
        myRange = QgsRendererRange(5, 10, symbol, '5 - 10%')
        myRangeList.append(myRange)
        myRenderer = QgsGraduatedSymbolRenderer(target_field, myRangeList)
        myRenderer.setMode(QgsGraduatedSymbolRenderer.Custom)
        shp.setRenderer(myRenderer)
        self.dlg.lineEdit.setText(str(list(f)[-1:])[2:-2])




    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Covid19TrackerDialog()
            self.dlg.lineEdit.setText('Will Be Shown When Pressing a Button')
            self.dlg.pushButton.clicked.connect(self.cases)
            self.dlg.pushButton_2.clicked.connect(self.death)
            self.dlg.pushButton_3.clicked.connect(self.stat)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            self.dlg.lineEdit.setText('Will Be Shown When Pressing a Button')
            pass
