# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Cost_surface_generalization
                                 A QGIS plugin
 Cost surface creation and area delimitation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-28
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Julien Lacroix
        email                : julien.lacroix@student.uliege.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Cost_surface_generalization_dialog import Cost_surface_generalizationDialog
import os.path

from PyQt5.QtWidgets import QAction, QFileDialog, QMessageBox, QProgressBar, QProgressDialog
from qgis.core import Qgis, QgsProject, QgsGeometry, QgsVectorLayer,QgsField, QgsFeature, QgsMapLayer, QgsMessageLog, \
    QgsRasterLayer, QgsField, QgsVectorDataProvider, QgsRasterPipe, QgsRasterFileWriter,QgsProcessingUtils,\
    QgsProcessingContext, QgsPointXY

import processing
from osgeo import ogr, osr, gdal
import sys
import numpy as np
from gdalconst import *
import random
import string
import skimage.graph as graph
from shapely.geometry import LineString, Point
from shapely.ops import nearest_points
import tempfile
import csv
import copy # for deep copy of numpy arrays
import atexit
import time

class Cost_surface_generalization:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Cost_surface_generalization_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Cost_surface_generalization')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Cost_surface_generalization', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToRasterMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Cost_surface_generalization/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Cost surfaces'),
            callback=self.run,
            parent=self.iface.mainWindow())


        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginRasterMenu(
                self.tr(u'&Cost_surface_generalization'),
                action)
            self.iface.removeToolBarIcon(action)

    def dist_eucl(self,x1, y1, x2, y2):
        """Permet de calculer la distance euclidienne entre deux coordonnées bidimensionnelles. """
        return pow((pow(x2 - x1, 2) + pow(y2 - y1, 2)), 0.5)



    def pixel_to_coord(self,px, py, upper_left_x, upper_left_y, x_size, y_size):
        """Permet le passage de coordonnées-image en coordonnées cartographiques."""
        mx = px * x_size + upper_left_x
        my = py * y_size + upper_left_y
        return mx, my

    def proj_to_segment(self, x1, y1, x2, y2, x_point, y_point):
        """Permet d'effectue une projection orthogonale à partir des coordonnées d'un segment et ceux d'un point"""
        # Calcul du produit scalaire entre les vecteurs formés respectivement par le premier point du segment et le
        # point à projeter et par les deux points du segment
        scalar_product = (x_point - x1) * (x2 - x1) + (y_point - y1) * (y2 - y1)
        # Calcul de la norme du segment (distance euclidienne)
        norm = self.dist_eucl(x1, y1, x2, y2)
        # Calcul de la projection orthogonale. En fonction de sa valeur, 3 cas sont possibles.
        ratio = scalar_product / pow(norm, 2)

        # Si la projection est sur le segment
        if 0 <= ratio <= 1:
            x_intersect = x1 + ratio * (x2 - x1)
            y_intersect = y1 + ratio * (y2 - y1)
        # Si la projection est dans le prolongement du premier point du segment
        elif ratio < 0:
            x_intersect = x1
            y_intersect = y1
        # Si la projection est dans le prolongement du second point du segment
        elif ratio > 1:
            x_intersect = x2
            y_intersect = y2

        return x_intersect, y_intersect

    def closest_point(self,lon, lat,vector_layer,raster_layer):
        """Permet, au départ d'un point défini en coordonnées cartographiques, de déterminer les coordonnées du point
        du segment routier le plus proche spatialement de ce point."""
        # création du point au format QGIS (objet QGIS)
        point = QgsGeometry.fromPointXY(QgsPointXY(lon, lat))
        # initialisation du rayon du buffer à 0
        buffer_radius = 0
        # intitialisation d'un booléen pour sortir de la boucle while une fois qu'une intersection est trouvée
        intersection = False
        # tant qu'un tronçon routier n'a pas été intersecté, on continue le processus
        while intersection == False:
            # augmentation de la taille du buffer à chaque itération (rayon)
            buffer_radius += 100
            # création du buffer autour du point. 999 est le nombre de segments utilisés pour approximer ses courbes
            buffer = point.buffer(buffer_radius,999)
            # initialisation d'une distance de référence supérieure au buffer
            distance = buffer_radius + 1
            # récupération des entités de la couche vecteur (tronçons routiers)
            features = vector_layer.getFeatures()
            # parcours des tronçons routier du réseau routier
            for feature in features:
                # récupération de la géométrie du tronçon routier
                geometry = feature.geometry()
                # test d'intersection entre le tronçon routier (feature) et le buffer
                if (geometry.intersects(buffer) == True):
                    # s'il y a intersection d'au moins une feature, on pourra sortir de la boucle while
                    intersection = True
                    # si la distance minimale entre le point et ce tronçon routier est inférieure à la distance
                    # minimale de référence, on modifie la distance avec sa nouvelle valeur et on récupère la géométrie
                    if (geometry.distance(point) < distance):
                        distance = geometry.distance(point)
                        linestring_geom = geometry

        # définition d'une distance de référence relativement haute qu'il faudra minimiser pour trouver le point du
        # tronçon routier le plus proche
        nearest_point_distance = 1000
        vertices = linestring_geom.asMultiPolyline()
        # parcours de tous les noeuds de la polyligne, pour considérer les segments successifs de celle-ci
        for v in vertices:
            for i in range(0, len(v)-1, 1):
                X1 = v[i].x()
                Y1 = v[i].y()
                X2 = v[i+1].x()
                Y2 = v[i+1].y()

                # calcul de la projection orthogonale entre le point (évènementà et le segment
                x_intersect, y_intersect = self.proj_to_segment(X1, Y1, X2, Y2, lon, lat)
                # si ce point minimise la distance de référence, on le sauvegarde
                if self.dist_eucl(x_intersect, y_intersect, lon, lat) < nearest_point_distance:
                    nearest_point_distance = self.dist_eucl(x_intersect, y_intersect, lon, lat)
                    closest_pt_x = x_intersect
                    closest_pt_y = y_intersect

        return self.coord_to_pixel(closest_pt_x, closest_pt_y, raster_layer)

    def coord_to_pixel(self, mx, my, rlayer):
        """Permet de passer des coordonnées cartographiques aux coordonnées-image, afin de déterminer le pixel associé
        au point intersecté. Teste également si le pixel fait bien partie du réseau routier, sinon choisit le pixel
        voisin qui minimise la distance euclidienne avec les coordonnées cartographiques du point donnée en argument"""
        # récupération des informations propres au raster
        prov = rlayer.dataProvider()
        extent = prov.extent()
        rows = rlayer.height()
        cols = rlayer.width()
        upper_left_x = extent.xMinimum()
        upper_left_y = extent.yMaximum()
        x_size = rlayer.rasterUnitsPerPixelX()
        y_size = rlayer.rasterUnitsPerPixelY()

        # transformation des coordonnées vctorielles de l'évènement, en
        # coordonnées - image (lignes - rangées)
        px = int((mx - upper_left_x) / x_size)
        py = int((upper_left_y - my) / y_size)

        # test si le pixel obtenu ci-dessus fait bien partie du réseau routier. Si ce n'est pas le cas (valeur no_data),
        # on tente de trouver le pixel voisin appartenant au réseau routier ET qui minimise la distance euclidienne
        # au point d'intersection
        block = prov.block(1, prov.extent(), cols, rows)
        no_data = block.noDataValue()
        np_array = np.zeros((rows, cols))
        # récupération des données raster dans un array numpy
        for i in range(rows):
            for j in range(cols):
                np_array[i, j] = block.value(i, j)
        # si le pixel ne fait pas partie du réseau routier
        if np_array[py, px] == no_data:
            classement = []
            # double boucles pour parcourier les pixels voisins en Y et en X
            for i in range(py - 1, py + 2, 1):
                for j in range(px - 1, px + 2, 1):
                    # si le pixel voisin est un pixel du réseau routier
                    if (np_array[i, j] != no_data):
                        # on fait la transformation inverse pour obtenir ses
                        # coordonnées Lambert afin de calculer la distance
                        # qui le sépare du point intersecté
                        mx2, my2 = self.pixel_to_coord(j, i, upper_left_x,
                                                  upper_left_y, x_size,
                                                  x_size)
                        # Calcul de la distance euclidienne
                        dist = pow((pow(mx2 - mx, 2) +
                                    pow(my2 - my, 2)), 0.5)
                        classement.append([dist, i, j])
            # tri ordonné de la liste en fonction de la distance
            classement.sort()
            # récupération des coordonnées - image correspondant à la
            # distance minimale (classement[0][0] - haut de la liste)
            y = classement[0][1]
            x = classement[0][2]
        # si le pixel obtenu fait bien partie du réseau routier, on retourne
        # les coordonnées - image directement
        else:
            y = py
            x = px
        # on retourne les coordonnées - image
        return y, x

    def layer_changed_ID(self):
        """Permet de modifier la liste déroulante associée au choix d'attribut correspondant à l'identifiant, en
        fonction du changement de choix de la liste déroulante associée à la couche vectorielle"""
        self.dlg.comboBox_attribute_ID.clear()
        layers = QgsProject.instance().mapLayers().values()
        name_layer = self.dlg.comboBox_vector.currentText()
        for l in layers:
            if l.name() == name_layer:
                pr = l.dataProvider()
                fields = pr.fields()
                self.dlg.comboBox_attribute_ID.addItems(field.name() for field in fields)

    def layer_changed_speed(self):
        """Permet de modifier la liste déroulante associée au choix d'attribut correspondant à la vitesse, en
        fonction du changement de choix de la liste déroulante associée à la couche vectorielle"""
        self.dlg.comboBox_speed.clear()
        layers = QgsProject.instance().mapLayers().values()
        name_layer = self.dlg.comboBox_vector.currentText()
        for l in layers:
            if l.name() == name_layer:
                pr = l.dataProvider()
                fields = pr.fields()
                self.dlg.comboBox_speed.addItems(field.name() for field in fields)

    def layer_changed_length(self):
        """Permet de modifier la liste déroulante associée au choix d'attribut correspondant à la longueur, en
        fonction du changement de choix de la liste déroulante associée à la couche vectorielle"""
        self.dlg.comboBox_length.clear()
        layers = QgsProject.instance().mapLayers().values()
        name_layer = self.dlg.comboBox_vector.currentText()
        for l in layers:
            if l.name() == name_layer:
                pr = l.dataProvider()
                fields = pr.fields()
                self.dlg.comboBox_length.addItems(field.name() for field in fields)

    def in_visible_etendue(self):
        """Permet d'afficher ou de cacher les composants d'export de fichier en fonction de l'état de la case à cocher
        associée (checkbox)"""
        if self.dlg.checkBox_etendue.isChecked():
            self.dlg.label_output_etendue.show()
            self.dlg.lineEdit_output_etendue.show()
            self.dlg.pushButton_output_etendue.show()
        if not self.dlg.checkBox_etendue.isChecked():
            self.dlg.label_output_etendue.hide()
            self.dlg.lineEdit_output_etendue.hide()
            self.dlg.pushButton_output_etendue.hide()

    def in_visible_moyenne(self):
        """Permet d'afficher ou de cacher les composants d'export de fichier en fonction de l'état de la case à cocher
        associée (checkbox)"""
        if self.dlg.checkBox_moyenne.isChecked():
            self.dlg.label_output_moyenne.show()
            self.dlg.lineEdit_output_moyenne.show()
            self.dlg.pushButton_output_moyenne.show()
        if not self.dlg.checkBox_moyenne.isChecked():
            self.dlg.label_output_moyenne.hide()
            self.dlg.lineEdit_output_moyenne.hide()
            self.dlg.pushButton_output_moyenne.hide()

    def in_visible_variance(self):
        """Permet d'afficher ou de cacher les composants d'export de fichier en fonction de l'état de la case à cocher
        associée (checkbox)"""
        if self.dlg.checkBox_variance.isChecked():
            self.dlg.label_output_variance.show()
            self.dlg.lineEdit_output_variance.show()
            self.dlg.pushButton_output_variance.show()
        if not self.dlg.checkBox_variance.isChecked():
            self.dlg.label_output_variance.hide()
            self.dlg.lineEdit_output_variance.hide()
            self.dlg.pushButton_output_variance.hide()

    def select_output_file_etendue(self):
        """Crée une nouvelle fenêtre de dialogue permettant de définir l'output correspondant au résultat de la
        méthode de l'étendue des heures de passage"""
        output_file_etendue, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file ", "", '*.tif')
        self.dlg.lineEdit_output_etendue.setText(output_file_etendue)

    def select_output_file_moyenne(self):
        """Crée une nouvelle fenêtre de dialogue permettant de définir l'output correspondant au résultat de la
        méthode de la moyenne des distances-temps"""
        output_file_moyenne, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file ", "", '*.tif')
        self.dlg.lineEdit_output_moyenne.setText(output_file_moyenne)

    def select_output_file_variance(self):
        """Crée une nouvelle fenêtre de dialogue permettant de définir l'output correspondant au résultat de la
        méthode de la variance des distances-temps"""
        output_file_variance, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file ", "", '*.tif')
        self.dlg.lineEdit_output_variance.setText(output_file_variance)


    def run(self):
        """Run method that performs all the real work"""
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Cost_surface_generalizationDialog()
        # On regarde l'état des cases à cocher au lancement de l'extension pour afficher les composants que s'il le faut
        if not self.dlg.checkBox_etendue.isChecked():
            self.dlg.label_output_etendue.hide()
            self.dlg.lineEdit_output_etendue.hide()
            self.dlg.pushButton_output_etendue.hide()

        if not self.dlg.checkBox_moyenne.isChecked():
            self.dlg.label_output_moyenne.hide()
            self.dlg.lineEdit_output_moyenne.hide()
            self.dlg.pushButton_output_moyenne.hide()

        if not self.dlg.checkBox_variance.isChecked():
            self.dlg.label_output_variance.hide()
            self.dlg.lineEdit_output_variance.hide()
            self.dlg.pushButton_output_variance.hide()

        # création de plusieurs listes qui contiendront les couches chargées dans le projet QGIS en fonction de
        # certaines caractéritiques (vecteur, raster, csv [spatiale ou non])
        networks_list = []
        raster_list = []
        points_list = []
        # récupération de toutes les couches du projet courant
        layers = QgsProject.instance().mapLayers().values()
        # Parcours des couches
        for l in layers:
            # si la couche est vectorielle
            if l.type() == QgsMapLayer.VectorLayer:
                # si elle est spatiale
                if l.isSpatial():
                    # si entités ponctuelles (== 0)
                    if l.geometryType() == 0:
                        points_list.append(l.name())
                    # si entités linéaires (== 1)
                    if l.geometryType() == 1:
                        networks_list.append(l.name())
                # si elle n'est pas spatiale (fichier csv non spatialisé)
                else:
                    points_list.append(l.name())
            # si la couche est raster
            if l.type() == QgsMapLayer.RasterLayer:
                raster_list.append(l.name())

        # on commence par supprimer ce que contiennent les listes déroulantes pour ne pas que ça s'ajoute chaque fois
        # à celle existante lorsqu'on appelle l'extension
        self.dlg.comboBox_vector.clear()
        self.dlg.comboBox_vector.addItems(networks_list)

        self.dlg.comboBox_raster.clear()
        self.dlg.comboBox_raster.addItems(raster_list)

        self.dlg.comboBox_csv.clear()
        self.dlg.comboBox_csv.addItems(points_list)

        # affichage de l'interface du plugin
        self.dlg.show()

        # Si aucune couche n'est chargée dans le projet --> erreur
        if len(layers) == 0:
            QMessageBox.critical(self.dlg, "Erreur", "Il n'y a pas de couche.")
            return
        # Si aucune couche RASTER n'est chargée dans le projet --> erreur
        if len(raster_list) == 0:
            QMessageBox.critical(self.dlg, "Erreur", "Il n'y a pas de couche raster.")
            return
        # Si aucune couche VECTORIELLE n'est chargée dans le projet --> erreur
        if len(networks_list) == 0:
            QMessageBox.critical(self.dlg, "Erreur", "Il n'y a pas de couche vectorielle de réseau routier.")
            return
        # Si aucune couche provenant d'un fichier CSV n'est chargée dans le projet --> erreur
        if len(points_list) == 0:
            QMessageBox.critical(self.dlg, "Erreur", "Il n'y a pas de fichier CSV importé.")
            return

        # suppression de ce que contiennent les listes déroulantes (cf. infra)
        self.dlg.comboBox_attribute_ID.clear()
        self.dlg.comboBox_length.clear()
        self.dlg.comboBox_speed.clear()
        # récupération de la couche courante de la liste déroulante de la couche vectorielle du réseau routier
        name_layer = self.dlg.comboBox_vector.currentText()
        # parcours des couches du projet courant
        for l in layers:
            # lorsqu'on trouve la couche dans la liste, on remplit les 3 listes déroulantes des champs d'attribut
            if l.name() == name_layer:
                pr = l.dataProvider()
                fields = pr.fields()
                self.dlg.comboBox_attribute_ID.addItems(field.name() for field in fields)
                self.dlg.comboBox_speed.addItems(field.name() for field in fields)
                self.dlg.comboBox_length.addItems(field.name() for field in fields)
        # lorsque la couche courante de la liste déroulante de la couche vectorielle change, on appelle les méthodes
        # qui permettent la modification des listes déroulantes qui en dépendent
        self.dlg.comboBox_vector.currentIndexChanged.connect(self.layer_changed_ID)
        self.dlg.comboBox_vector.currentIndexChanged.connect(self.layer_changed_speed)
        self.dlg.comboBox_vector.currentIndexChanged.connect(self.layer_changed_length)

        # lorsque l'état des cases à cocher est modifié (via un clic), on appelle les méthodes qui permettent
        # l'affichage ou la suppression des composants d'export de fichier
        self.dlg.checkBox_etendue.stateChanged.connect(self.in_visible_etendue)
        self.dlg.checkBox_moyenne.stateChanged.connect(self.in_visible_moyenne)
        self.dlg.checkBox_variance.stateChanged.connect(self.in_visible_variance)

        # pour éviter que les connections avec le clicked s'ajoutent à chaque lancement de l'extension
        try:
            self.dlg.pushButton_output_etendue.clicked.disconnect()
            self.dlg.pushButton_output_moyenne.clicked.disconnect()
            self.dlg.pushButton_output_variance.clicked.disconnect()
        except:
            pass
        # lorsque le bouton pour la définition des fichiers en output est  déclenché, on appelle les méthodes associées
        self.dlg.pushButton_output_etendue.clicked.connect(self.select_output_file_etendue)
        self.dlg.pushButton_output_moyenne.clicked.connect(self.select_output_file_moyenne)
        self.dlg.pushButton_output_variance.clicked.connect(self.select_output_file_variance)

        # Run the dialog event loop
        result = self.dlg.exec_()
        # Lorsque "OK" est cliqué, on entre ici
        if result:
            # récupération des états des cases à cocher afin de définir les processus à lancer
            ischecked_etendue = self.dlg.checkBox_etendue.isChecked()
            ischecked_moyenne = self.dlg.checkBox_moyenne.isChecked()
            ischecked_variance = self.dlg.checkBox_variance.isChecked()

            # si aucune méthode sélectionnée : erreur
            if not ischecked_etendue and not ischecked_moyenne and not ischecked_variance:
                QMessageBox.critical(self.dlg, "Erreur", "Aucune méthode sélectionnée.")
                return

            # récupération des chemin d'accès complet (i.e. avec nom de fichier) des output si les cases à cocher
            # sont remplies
            if ischecked_etendue:
                output_etendue = self.dlg.lineEdit_output_etendue.text()
            if ischecked_moyenne:
                output_moyenne = self.dlg.lineEdit_output_moyenne.text()
            if ischecked_variance:
                output_variance = self.dlg.lineEdit_output_variance.text()

            # si aucun chemin n'est défini alors que la méthode est choisie : erreur
            if ischecked_etendue and not output_etendue:
                QMessageBox.critical(self.dlg, "Erreur", "Aucun chemin d'accès spécifié pour la première méthode.")
                return

            if ischecked_moyenne and not output_moyenne:
                QMessageBox.critical(self.dlg, "Erreur", "Aucun chemin d'accès spécifié pour la deuxième méthode.")
                return

            if ischecked_variance and not output_variance:
                QMessageBox.critical(self.dlg, "Erreur", "Aucun chemin d'accès spécifié pour la troisième méthode.")
                return

            # récupération des différents éléments courants dans toutes les listes déroulantes
            shp_name = self.dlg.comboBox_vector.currentText()
            attribute_ID = self.dlg.comboBox_attribute_ID.currentText()
            length = self.dlg.comboBox_length.currentText()
            speed = self.dlg.comboBox_speed.currentText()
            raster_name = self.dlg.comboBox_raster.currentText()
            csv_name = self.dlg.comboBox_csv.currentText()

            # on récupère les couches vecteur, raster et CSV
            for l in layers:
                if l.name() == shp_name:
                    vlayer = l
                if l.name() == raster_name:
                    rlayer = l
                if l.name() == csv_name:
                    csvreader = l

            # Création d'une fenêtre de dialogue qui informe que le prcessus est toujours en cours
            dialog = QProgressDialog()
            dialog.setWindowTitle("Progress")
            bar = QProgressBar(dialog)
            bar.setTextVisible(True)
            bar.setRange(0,0)
            dialog.setBar(bar)
            dialog.setMinimumWidth(300)
            dialog.show()

            # création de listes pour la récupération des données spatiales et temporelles
            x_sources = []
            y_sources = []
            event_time = []
            event_time_seconds = []
            features = csvreader.getFeatures()
            for feature in features:
                attrs = feature.attributes()
                x_sources.append(attrs[0])
                y_sources.append(attrs[1])
                # récupération des données temporelles uniquement dans le cas de la méthode de l'étendue, car elle n'est
                # pas utilisée dans les autres méthodes. On essaie de les récupérer ("try") et si on n'y arrive pas,
                # on catch l'exception (cas de données temporelles manquantes)
                if ischecked_etendue:
                    try:
                        event_time.append(attrs[2])
                    except:
                        QMessageBox.critical(self.dlg, "Erreur","Données temporelles manquantes.")
                        return

            if ischecked_etendue:
                # si la première méthode a été sélectionnée, on met l'heure en secondes en séparant les heures des
                # minutes puis en convertissant le tout en secondes
                for d in event_time:
                    # récupération de l'heure,
                    event_time_split = d.split(':')
                    # on remet l'heure du crime en secondes de la journée (1 heure = 3600 secondes, 1 minute = 60
                    # secondes), si on n'y arrive pas c'est que le format est invalide
                    try:
                        event_time_seconds.append(int(event_time_split[0]) * 3600 + int(event_time_split[1]) * 60)
                    except:
                        QMessageBox.critical(self.dlg, "Erreur","Format des données temporelles invalide.")
                        return

            # Déclaration de deux listes qui vont contenir les coordonnées résultantes de la méthode "closest_point"
            y_road = []
            x_road = []
            # Récupération de tous les points du réseau routier correspondant aux faits
            for p in range(0, len(x_sources), 1):
                y, x = self.closest_point(float(x_sources[p]), float(y_sources[p]), vlayer,rlayer)
                y_road.append(y)
                x_road.append(x)

            # Définition d'une liste contenant des tuples "ID tronçon - coût" pour la création de la surface de friction
            # améliorée
            tuple_ID_cost = []
            features = vlayer.getFeatures()
            # parcours des tronçons routier du réseau routier
            for feature in features:
                # ID du tronçon pour le comptage des pixels par tronçon et cost est le coût en SECONDES du passage du
                # tronçon total(combien de secondes pour parcourir tout le tronçon)
                cost = feature[length] / (feature[speed] / 3.6)
                tuple_ID_cost.append([int(feature[attribute_ID]), cost])

            # Récupération des métadonnées du raster
            prov = rlayer.dataProvider()
            rows = rlayer.height()
            cols = rlayer.width()
            extent = prov.extent()
            xmin = extent.xMinimum()
            ymax = extent.yMaximum()
            xsize = rlayer.rasterUnitsPerPixelX()
            ysize = rlayer.rasterUnitsPerPixelY()

            # Récupération du "block", i.e. un objet QGIS contenant les données du raster sous forme d'array
            block = prov.block(1, prov.extent(), cols, rows)
            no_data = block.noDataValue()

            # on affecte le block à une matrice numpy pour effectuer les traitements
            data = np.zeros((rows,cols))
            for i in range(rows):
                for j in range(cols):
                    data[i,j] = block.value(i,j)

            # On récupère chaque identifiant unique de tronçon dans "unique_elements" et le nombre de pixels associé
            # dans "count_elements"
            unique_elements, count_elements = np.unique(data, return_counts=True)

            # Parcours de tous les ID uniques sauf le premier qui est NODATA. Une deuxième boucle va quant à
            # elle parcourir les tuples "ID - cost" de manière à matcher les ID et ainsi obtenir pour un ID donné, le
            # nombre de pixels associé ainsi que le coût total pour parcourir ce tronçon.
            for i in range(1, len(unique_elements), 1):
                for d in tuple_ID_cost:
                    # si les ID matchent
                    if int(unique_elements[i]) == d[0]:
                        # normalisation du coût (d[1]) par pixel
                        cost_by_pixel = d[1] / count_elements[i]
                        # Modification de chaque pixel de data si la valeur est égale à cet ID (d[0])
                        data[data == d[0]] = cost_by_pixel

            if ischecked_etendue:
                """Si la méthode de l'étendue a été choisie, création d'une deep copy d'un array numpy (i.e. une copie
                sans référence à numpy_array de manière à ce que si on modifie la copie, on ne modifie pas l'original).
                On fait ça pour plusieurs array :
                - rster : utilisé dans la fonction "closest_point" pour voir si un pixel donné appartient au réseau 
                routier rasterisé;
                - sooner : contient les temps au plus tôt;
                - later : contient les temps au plus tard;
                - time_difference : contient les différences finales entre temps au plus tard et temps au plus tôt
                Dans sooner, on change tous les pixels du réseau routier à une valeur très grande pour y être inférieur,
                on fait le contraire pour later (temps au plus tard)"""
                sooner = copy.deepcopy(data)
                later = copy.deepcopy(data)
                time_difference = copy.deepcopy(data)
                sooner[sooner != no_data] = 99999
                later[later != no_data] = -1

            if ischecked_moyenne or ischecked_variance:
                # Si au moins l'une des méthodes de la moyenne ou de la variance est choisie, on définit les listes qui
                # serviront à stocker les surfaces de coût, les valeurs des rasters de la méthode de la moyenne et celle
                # de la variance
                cost_surfaceS = []
                moyennes = []
                variances = []

            # Création des surfaces de coût
            for z in range(0, len(x_sources), 1):
                # tranformation de la matrice numpy en un graphe SKIMAGE en passant en argument la surface de friction
                # améliorée
                mcp = graph.MCP_Geometric(data)
                # On applique la fonction de surface de coût partant depuis le pixel du réseau routier obtenu grâce à
                # la fonction "on the road".
                cost_surface, traceback = mcp.find_costs([[y_road[z], x_road[z]]], ends=None, find_all_ends=True,
                                                         max_coverage=1.0, max_cumulative_cost=None, max_cost=None)

                # Si au moins une des deux méthodes de moyenne / variance est sélectionnée, on a juste à stocker toutes
                # les surfaces de coût après leur création
                if ischecked_moyenne or ischecked_variance:
                    cost_surfaceS.append(cost_surface)

                if ischecked_etendue:
                    """Si la méthode de l'étendue est choisie, les traitements doivent en revanche être appliqués à chaque 
                    itération de la boucle. On commence par soustraire les valeurs de la surface de coût au temps de 
                    l'évènement enregistré afin d'avoir un temps régressif. Ensuite, on s'assure de garder toutes les
                    valeurs de la surface de coût dans un intervalle entre minuit (0 seconde) et 86399 (23:59:59). Par
                    après, les comparaisons entre la surface de coût et les rasters des temps au plus tôt et au plus
                    tard sont réalisées et si une valeur respectivement plus tôt et plus tardive est trouvée on 
                    l'affecte"""
                    # Comme on doit avoir un temps depuis l'heure du fait, on soustrait la surface de coût à celle-ci
                    cost_surface = event_time_seconds[z] - cost_surface
                    cost_surface[cost_surface < 0] += 86400

                    sooner_comparison = np.greater(sooner, cost_surface)
                    index_row = 0
                    for d in sooner_comparison:
                        index_col = 0
                        for p in d:
                            if p:  # (if p == True)
                                sooner[index_row, index_col] = cost_surface[index_row, index_col]
                            index_col += 1
                        index_row += 1

                    later_comparison = np.less(later, cost_surface)
                    index_row = 0
                    for d in later_comparison:
                        index_col = 0
                        for p in d:
                            if p:
                                later[index_row, index_col] = cost_surface[index_row, index_col]
                            index_col += 1
                        index_row += 1

            # une fois que les rasters au plus tôt et au plus tard ont été comparés à toutes les surfaces de coût,
            # on créé le raster finale des différences "max - min"
            if ischecked_etendue:
                for index_row in range(0, rows, 1):
                    for index_col in range(0, cols, 1):
                        if time_difference[index_row, index_col] != -99:
                            time_difference[index_row, index_col] = later[index_row, index_col] \
                                                                    - sooner[index_row, index_col]

            if ischecked_moyenne or ischecked_variance:
                """Concernant les méthodes moyenne / variance, on parcourt tous les rasters de la liste et on calcule
                pour chaque pixel homologue du réseau routier (ici, la liste element contient toutes les valeurs des 
                pixels homologues du réseau routier, la moyenne ou la variance. Pour les pixels hors réseau routier,
                la valeur NoData est affectée."""
                for arr in zip(*cost_surfaceS):
                    for element in zip(*arr):
                        if float("-inf") not in element and float("inf") not in element:
                            if ischecked_moyenne:
                                mean = np.mean(element, dtype=np.float32)
                                moyennes.append(float(mean))
                            if ischecked_variance:
                                var = np.var(element, dtype=np.float32)
                                variances.append(float(var))
                        else:
                            if ischecked_moyenne:
                                moyennes.append(no_data)
                            if ischecked_variance:
                                variances.append(no_data)
                # les array 1D dont transformés en arrays 2D avec la fonction reshape de Numpy
                if ischecked_moyenne:
                    moyennes = np.array(moyennes)
                    moyennes = np.reshape(moyennes, (rows,cols))

                if ischecked_variance:
                    variances = np.array(variances)
                    variances = np.reshape(variances, (rows, cols))

            geotransform = [xmin, xsize, 0, ymax, 0, -ysize]
            driver = gdal.GetDriverByName("GTiff")
            # récupération du SRS de la couche vectorielle du réseau routier
            srs = vlayer.sourceCrs()

            """Pour chaque choix de méthode, on procède à l'export de fichiers si elles sont choisies. On créé d'abord
             un fichier vide qu'on remplit avec les arrays 2D créés auparavant. On définit la valeur NoData, l'extension
             , la résolution et la projection."""
            if ischecked_etendue:
                ds_etendue = driver.Create(output_etendue, cols, rows, 1, gdal.GDT_Float32)

                band_etendue = ds_etendue.GetRasterBand(1)
                band_etendue.WriteArray(time_difference)
                band_etendue.SetNoDataValue(no_data)

                ds_etendue.SetGeoTransform(geotransform)
                ds_etendue.SetProjection(srs.toWkt())
                ds_etendue = None

                lyr_etendue = QgsRasterLayer(output_etendue, "Etendue")
                if not lyr_etendue.isValid():
                    QgsMessageLog.logMessage("Layer failed to load!")
                    return
                QgsProject.instance().addMapLayer(lyr_etendue)

            if ischecked_moyenne:
                ds_moyenne = driver.Create(output_moyenne, cols, rows, 1, gdal.GDT_Float32)

                band_moyenne = ds_moyenne.GetRasterBand(1)
                band_moyenne.WriteArray(moyennes)
                band_moyenne.SetNoDataValue(no_data)

                ds_moyenne.SetGeoTransform(geotransform)
                ds_moyenne.SetProjection(srs.toWkt())
                ds_moyenne = None

                lyr_mean = QgsRasterLayer(output_moyenne, "Moyenne")
                if not lyr_mean.isValid():
                    QgsMessageLog.logMessage("Layer failed to load!")
                    return
                QgsProject.instance().addMapLayer(lyr_mean)

            if ischecked_variance:
                ds_variance = driver.Create(output_variance, cols, rows, 1, gdal.GDT_Float32)

                band_variance = ds_variance.GetRasterBand(1)
                band_variance.WriteArray(variances)
                band_variance.SetNoDataValue(no_data)

                ds_variance.SetGeoTransform(geotransform)
                ds_variance.SetProjection(srs.toWkt())
                ds_variance = None

                lyr_var = QgsRasterLayer(output_variance, "Variance")
                if not lyr_var.isValid():
                    QgsMessageLog.logMessage("Layer failed to load!")
                    return
                QgsProject.instance().addMapLayer(lyr_var)

            """Enfin, on affiche à l'utilisateur que le(s) fichier(s) ont bien été créés et le chemin d'accès vers ceux-
            ci"""
            if ischecked_etendue:
                self.iface.messageBar().pushMessage("Success", "File created in %s" % output_etendue,level=Qgis.Success, duration=3)

            if ischecked_moyenne:
                self.iface.messageBar().pushMessage("Success", "File created in %s" % output_moyenne,level=Qgis.Success, duration=3)

            if ischecked_variance:
                self.iface.messageBar().pushMessage("Success", "File created in %s" % output_variance,level=Qgis.Success, duration=3)
            return
