# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CoordsConverter
                                 A QGIS plugin
 This Plugin convert coordinates from dms and dm to utm
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-05-21
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Ahmed Abdelkarim
        email                : a.abdelkarim9696@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .coords_converter_dialog import CoordsConverterDialog
import os.path

from .models.conversion import from_latlon, to_latlon, dm_to_dms, dms_to_dm



class CoordsConverter:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CoordsConverter_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Coordinates Converter')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

       

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CoordsConverter', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/coords_converter/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'convert coordinates'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Coordinates Converter'),
                action)
            self.iface.removeToolBarIcon(action)


    # Methods

    #####
    # ui changes
    #####
    def ui_changes(self):
        self.dlg.tabWidget.tabBar().setVisible(False)
        

    ####
    # handel buttons
    ####
    def handel_buttons(self):
        # Actions
        self.dlg.pushButton_5.clicked.connect(self.dm_to_utm)
        self.dlg.pushButton_6.clicked.connect(self.clear_dm_to_utm)

        self.dlg.pushButton_14.clicked.connect(self.dm_to_dms)
        self.dlg.pushButton_13.clicked.connect(self.clear_dm_to_dms)

        self.dlg.pushButton_8.clicked.connect(self.utm_to_dm)
        self.dlg.pushButton_7.clicked.connect(self.clear_utm_to_dm)
        self.dlg.pushButton_15.clicked.connect(self.utm_to_dms)
        self.dlg.pushButton_16.clicked.connect(self.clear_utm_to_dms)
        self.dlg.pushButton_25.clicked.connect(self.dms_to_utm)
        self.dlg.pushButton_26.clicked.connect(self.clear_dms_to_utm)
        self.dlg.pushButton_27.clicked.connect(self.dms_to_dd)
        self.dlg.pushButton_28.clicked.connect(self.clear_dms_to_dd)

        #change tabs
        self.dlg.commandLinkButton.clicked.connect(self.dd_to_utm_tab)
        self.dlg.commandLinkButton_2.clicked.connect(self.dd_to_dms_tab)
        self.dlg.commandLinkButton_3.clicked.connect(self.utm_to_dd_tab)
        self.dlg.commandLinkButton_4.clicked.connect(self.utm_to_dms_tab)
        self.dlg.commandLinkButton_5.clicked.connect(self.dms_to_dd_tab)
        self.dlg.commandLinkButton_6.clicked.connect(self.dms_to_utm_tab)


    ####
    # change tabs
    ####
    def dd_to_utm_tab(self):
        self.dlg.tabWidget.setCurrentIndex(1)

    def dd_to_dms_tab(self):
        self.dlg.tabWidget.setCurrentIndex(2)
    
    def utm_to_dd_tab(self):
        self.dlg.tabWidget.setCurrentIndex(3)

    def utm_to_dms_tab(self):
        self.dlg.tabWidget.setCurrentIndex(4)

    def dms_to_dd_tab(self):
        self.dlg.tabWidget.setCurrentIndex(6)

    def dms_to_utm_tab(self):
        self.dlg.tabWidget.setCurrentIndex(5)




    ###
    # START DM to UTM
    ###
    def dm_to_utm(self):
        try:
            geo_lat = self.dlg.lineEdit.text()
            geo_long = self.dlg.lineEdit_2.text()

            easting, northing, zone_number, zone_letter = from_latlon(float(geo_lat), float(geo_long))
            
            self.dlg.lineEdit_3.setText(str(easting))
            self.dlg.lineEdit_4.setText(str(northing))
            self.dlg.lineEdit_5.setText(str(zone_number))
            self.dlg.lineEdit_6.setText(str(zone_letter))
        except Exception as e:
            print(e)

        

    def clear_dm_to_utm(self):
        self.dlg.lineEdit.clear()
        self.dlg.lineEdit_2.clear()
        self.dlg.lineEdit_3.clear()
        self.dlg.lineEdit_4.clear()
        self.dlg.lineEdit_5.clear()
        self.dlg.lineEdit_6.clear()
        

    ###
    # END DM to UTM
    ###



    ###
    # START DM to DMS
    ###
    def dm_to_dms(self):
        try:
            latitude = self.dlg.lineEdit_25.text()
            longtude = self.dlg.lineEdit_26.text()

            lat, lon = dm_to_dms(float(latitude), float(longtude))
            
            self.dlg.lineEdit_27.setText(str(lat[0]))
            self.dlg.lineEdit_28.setText(str(lat[1]))
            self.dlg.lineEdit_29.setText(str(lat[2]))

            self.dlg.lineEdit_31.setText(str(lon[0]))
            self.dlg.lineEdit_30.setText(str(lon[1]))
            self.dlg.lineEdit_32.setText(str(lon[2]))
        except Exception as e:
            print(e)
            
        
        

    def clear_dm_to_dms(self):
        self.dlg.lineEdit_25.clear()
        self.dlg.lineEdit_26.clear()
        self.dlg.lineEdit_27.clear()
        self.dlg.lineEdit_28.clear()
        self.dlg.lineEdit_29.clear()
        self.dlg.lineEdit_31.clear()
        self.dlg.lineEdit_30.clear()
        self.dlg.lineEdit_32.clear()

    ###
    # END DM to DMS
    ###





    ###
    # START UTM to DM
    ###
    def utm_to_dm(self):
        try:
            easting, northing, zone_number, zone_letter = self.dlg.lineEdit_9.text(), self.dlg.lineEdit_12.text(), int(self.dlg.comboBox.currentText()), str(self.dlg.comboBox_2.currentText())
            
            geo_lat, geo_long = to_latlon(float(easting), float(northing), int(zone_number), zone_letter)
            
            self.dlg.lineEdit_10.setText(str(geo_lat))
            self.dlg.lineEdit_8.setText(str(geo_long))
        except Exception as e:
            print(e)
            
        
        

    def clear_utm_to_dm(self):
        self.dlg.lineEdit_12.clear()
        self.dlg.lineEdit_9.clear()
        self.dlg.lineEdit_10.clear()
        self.dlg.lineEdit_8.clear()

    ###
    # END UTM to DM
    ### 


    ###
    # START UTM to DMS
    ### 
    def utm_to_dms(self):
        try:
            easting, northing, zone_number, zone_letter = self.dlg.lineEdit_33.text(), self.dlg.lineEdit_34.text(), int(self.dlg.comboBox_4.currentText()), str(self.dlg.comboBox_3.currentText())
            
            lat, lon = to_latlon(float(easting), float(northing), int(zone_number), zone_letter)

            dms_lat, dms_lon = dm_to_dms(float(lat), float(lon))
        
                
            self.dlg.lineEdit_38.setText(str(dms_lat[0]))
            self.dlg.lineEdit_37.setText(str(dms_lat[1]))
            self.dlg.lineEdit_40.setText(str(dms_lat[2]))

            self.dlg.lineEdit_41.setText(str(dms_lon[0]))
            self.dlg.lineEdit_39.setText(str(dms_lon[1]))
            self.dlg.lineEdit_42.setText(str(dms_lon[2]))
        except Exception as e:
            print(e)
        

    def clear_utm_to_dms(self):
        self.dlg.lineEdit_33.clear()
        self.dlg.lineEdit_34.clear()
        self.dlg.lineEdit_38.clear()
        self.dlg.lineEdit_37.clear()
        self.dlg.lineEdit_40.clear()
        self.dlg.lineEdit_41.clear()
        self.dlg.lineEdit_39.clear()
        self.dlg.lineEdit_42.clear()

    ###
    # END UTM to DMS
    ### 





    ###
    # START DMS to UTM
    ###
    def dms_to_utm(self):
        try:
            lat = [self.dlg.lineEdit_47.text(), self.dlg.lineEdit_45.text(), self.dlg.lineEdit_48.text()]
            for i in lat:
                float(i)

            lon = [self.dlg.lineEdit_46.text(), self.dlg.lineEdit_43.text(), self.dlg.lineEdit_44.text()]
            for i in lon:
                float(i)
        

            # convert from dms to dd
            lat, lon = dms_to_dm(lat, lon)

            # convert from dd to utm
            easting, northing, zone_number, zone_letter = from_latlon(float(lat), float(lon))
            
            self.dlg.lineEdit_50.setText(str(easting))
            self.dlg.lineEdit_52.setText(str(northing))
            self.dlg.lineEdit_49.setText(str(zone_number))
            self.dlg.lineEdit_51.setText(str(zone_letter))
        except Exception as e:
            print(e)

        

    def clear_dms_to_utm(self):
        self.dlg.lineEdit_47.clear() 
        self.dlg.lineEdit_45.clear() 
        self.dlg.lineEdit_48.clear()
        self.dlg.lineEdit_46.clear() 
        self.dlg.lineEdit_43.clear() 
        self.dlg.lineEdit_44.clear()
        self.dlg.lineEdit_50.clear()
        self.dlg.lineEdit_52.clear()
        self.dlg.lineEdit_49.clear()
        self.dlg.lineEdit_51.clear()
        
    ###    
    # END DMS to UTM
    ###



    ###    
    # START DMS to DD
    ###
    def dms_to_dd(self):
        try:
            lat = [self.dlg.lineEdit_95.text(), self.dlg.lineEdit_99.text(), self.dlg.lineEdit_97.text()]
            for i in lat:
                float(i)

            lon = [self.dlg.lineEdit_98.text(), self.dlg.lineEdit_96.text(), self.dlg.lineEdit_100.text()]
            for i in lon:
                float(i)

            # convert from dms to dd
            lat, lon = dms_to_dm(lat, lon)
            
            self.dlg.lineEdit_93.setText(str(lat))
            self.dlg.lineEdit_94.setText(str(lon))
        except Exception as e:
            print(e)
            
        


    def clear_dms_to_dd(self):
        self.dlg.lineEdit_95.clear()
        self.dlg.lineEdit_99.clear()
        self.dlg.lineEdit_97.clear()
        self.dlg.lineEdit_98.clear()
        self.dlg.lineEdit_96.clear()
        self.dlg.lineEdit_100.clear()
        self.dlg.lineEdit_93.clear()
        self.dlg.lineEdit_94.clear()
    ###    
    # END DMS to DD
    ###

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = CoordsConverterDialog()

            self.ui_changes()
            self.handel_buttons()
            
            

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
