# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CoordList
                                 A QGIS plugin
 CoordList
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-04
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Lebedev
        email                : lebedev77@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .coord_list_dialog import CoordListDialog
import os.path
import math
# My
from PyQt5.QtWidgets import QAction, QMessageBox
from PyQt5.QtCore import QVariant
from qgis.core import *
from qgis import *
from qgis.utils import iface


class CoordList:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'CoordList_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Coord List')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('CoordList', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/coord_list/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'CoordList'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Coord List'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = CoordListDialog()

        # Set CRS widget value.
        self.dlg.mQgsProjectionSelectionWidget.setCrs(self.iface.activeLayer().crs())

        # Define sourse layer features - control
        layer = self.iface.activeLayer()
        if layer is None:
            QMessageBox.warning(None, "Warning!", "No selected layer! Select one feature on active layer.")
            return None
        if (layer.type() != 0):
            QMessageBox.warning(None, "Warning!", "Layer selected is not vector!")
            return None
        if layer.selectedFeatureCount() == 0:
            QMessageBox.warning(None, "Warning!", "No feature selected! Select one feature on active layer.")
            return None
        if layer.selectedFeatureCount() > 1:
            QMessageBox.warning(None, "Warning!", "More than one feature is selected!")
            return None

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            # from qgis.core import *
            from qgis.PyQt.QtCore import QVariant

            # Define sourse layer features - control
            layer = self.iface.activeLayer()
            crs = layer.crs()
            destCrs = self.dlg.mQgsProjectionSelectionWidget.crs()

            # Transform
            transformContext = QgsProject.instance().transformContext()
            xform = QgsCoordinateTransform(crs, destCrs, transformContext)

            # Create layer with destination CRS
            vl = QgsVectorLayer('Point?crs=' + destCrs.toWkt(), 'Coord_' + destCrs.description(), 'memory')
            pr = vl.dataProvider()
            pr.addAttributes([QgsField("pid", QVariant.Int),
                              QgsField("x", QVariant.Double),
                              QgsField("y", QVariant.Double),
                              QgsField("len", QVariant.Double),
                              QgsField("azmt", QVariant.Double)])
            vl.updateFields()

            # Define selected obj
            feat = layer.selectedFeatures()
            geom = feat[0].geometry()
            QgsMessageLog.logMessage(str(geom))

            # Find out type o geometry
            # the geometry type can be of single or multi type
            # We work with Polyline, Polygon,
            geomSingleType = QgsWkbTypes.isSingleType(geom.wkbType())
            if geom.type() == QgsWkbTypes.LineGeometry:
                if geomSingleType:
                    coords = geom.asPolyline()
                    geomType = 'sLine'
                    # print("Polyline")
                else:
                    coords = geom.asMultiPolyline()
                    geomType = 'mLine'
                    # print("MultiPolyline")
            elif geom.type() == QgsWkbTypes.PolygonGeometry:
                if geomSingleType:
                    coords = geom.asPolygon()
                    geomType = 'sPoly'
                    # print("Polygon")
                else:
                    coords = geom.asMultiPolygon()
                    geomType = 'mPoly'
                    # print("MultiPolygon")
            else:
                QMessageBox.warning(None, "Warning!", "Unknown or invalid geometry")
                return None

            # We work only pline or polygon or multy
            # Make a point list
            pointId = 0
            pointList = []
            if geomType == 'sLine':
                nodes = len(coords)
                for n, pnt in enumerate(coords):
                    if n == nodes:
                        break
                    pointId += 1
                    pointList.append([nodes, n, pointId, pnt])
            if geomType == 'sPoly':
                for part in coords:
                    nodes = len(part) - 1
                    for n, pnt in enumerate(part):
                        if n == nodes:
                            break
                        pointId += 1
                        pointList.append([nodes, n, pointId, pnt])
            if geomType == 'mLine':
                for part in coords:
                    nodes = len(part)
                    for n, pnt in enumerate(part):
                        if n == nodes:
                            break
                        pointId += 1
                        pointList.append([nodes, n, pointId, pnt])
            if geomType == 'mPoly':
                for mult in coords:
                    for part in mult:
                        nodes = len(part) - 1
                        for n, pnt in enumerate(part):
                            if n == nodes:
                                break
                            pointId += 1
                            pointList.append([nodes, n, pointId, pnt])
            # Create layer with geodata
            for nodes, n, pntId, point in pointList:
                thisPoint = xform.transform(QgsPointXY(point.x(), point.y()))
                x = thisPoint
                if n == 0:
                    firstPoint = thisPoint
                if n == nodes - 1:
                    nextPoint = firstPoint
                else:
                    nextItem = pointList[pntId]
                    nextPoint = xform.transform(nextItem[3].x(), nextItem[3].y())
                # Create a measure object
                distance = QgsDistanceArea()
                # If long/lat set ellipsoid
                if destCrs.toProj().find('+proj=longlat') >= 0:
                    distance.setEllipsoid(destCrs.ellipsoidAcronym())
                    lenght = distance.measureLine(thisPoint, nextPoint)
                    azim = distance.bearing(thisPoint, nextPoint) * 180 / math.pi
                    if azim < 0:
                        azim = 360 + azim
                else:
                    # distance.setEllipsoidalMode(True)
                    lenght = distance.measureLine(thisPoint, nextPoint)
                    azim = distance.bearing(thisPoint, nextPoint) * 180 / math.pi
                    if azim < 0:
                        azim = 360 + azim

                #QMessageBox.warning(None, "Warning!", str(thisPoint))
                # Insert in layer
                f = QgsFeature()
                f.setGeometry(QgsGeometry.fromPointXY(thisPoint))
                f.setAttributes([pntId, thisPoint.x(), thisPoint.y(), lenght, azim])
                pr.addFeature(f)

            # Commit new layer and add to map
            vl.updateExtents()
            QgsProject.instance().addMapLayer(vl)

            # Labeling
            settings = QgsPalLayerSettings()
            settings.fieldName = 'pid'
            labeling = QgsVectorLayerSimpleLabeling(settings)
            lv = self.iface.activeLayer()
            lv.setLabeling(labeling)
            lv.setLabelsEnabled(True)
            lv.triggerRepaint()
            # Show attribute Table
            if self.dlg.checkBox.isChecked():
                iface.showAttributeTable(iface.activeLayer())
            else:
                pass
