# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CoolParks tool
                                 A QGIS plugin
 Coolparks toolbox
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-06
        copyright            : (C) 2023 by Jérémy Bernard
        email                : jeremy.bernard@zaclys.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Jérémy Bernard'
__date__ = '2023-07-06'
__copyright__ = '(C) 2023 by Jérémy Bernard'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from processing.core.ProcessingConfig import ProcessingConfig

from .preprocessing_algorithm import CoolParksPreparerAlgorithm
from .processing_algorithm import CoolParksProcessorAlgorithm
from .postprocessing_algorithm import CoolParksAnalyzerAlgorithm

import os.path
from qgis.PyQt.QtGui import QIcon
import inspect
# from PyQt5.QtGui import QIcon

class ProcessingCoolParksProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        self.plugin_dir = os.path.dirname(__file__)
        QgsProcessingProvider.__init__(self)
        
        if not (os.path.isdir(self.plugin_dir + '/temp')):
                os.mkdir(self.plugin_dir + '/temp')

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        #Preprocessor
        self.addAlgorithm(CoolParksPreparerAlgorithm())
        
        
        # #Processor
        self.addAlgorithm(CoolParksProcessorAlgorithm())

        # #Postprocessor
        self.addAlgorithm(CoolParksAnalyzerAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'CoolParksTool'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return 'CoolParksTool'
        
    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        icon = QIcon(os.path.dirname(__file__) + "/Icons/CoolParksTool.png")
        return icon

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return 'CoolParksTool, Version 0.1'
