/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.topology;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ST_Graph
extends AbstractFunction
implements ScalarFunction {
    public static final String NODES_SUFFIX = "_NODES";
    public static final String EDGES_SUFFIX = "_EDGES";
    public static String PTS_TABLE;
    public static String COORDS_TABLE;
    public static final String REMARKS = "ST_Graph produces two tables (nodes and edges) from an input table containing\n`LINESTRING`s or `MULTILINESTRING`s in the given column and using the given\ntolerance, and potentially orienting edges by slope. If the input table has\nname `input`, then the output tables are named `input_nodes` and `input_edges`.\nThe nodes table consists of an integer `node_id` and a `POINT` geometry\nrepresenting each node. The edges table is a copy of the input table with three\nextra columns: `edge_id`, `start_node`, and `end_node`. The `start_node` and\n`end_node` correspond to the `node_id`s in the nodes table.\n\nIf the specified geometry column of the input table contains geometries other\nthan `LINESTRING`s, the operation will fail.\n\nA tolerance value may be given to specify the side length of a square envelope\naround each node used to snap together other nodes within the same envelope.\nNote, however, that edge geometries are left untouched. Note also that\ncoordinates within a given tolerance of each other are not necessarily snapped\ntogether. Only the first and last coordinates of a geometry are considered to\nbe potential nodes, and only nodes within a given tolerance of each other are\nsnapped together. The tolerance works only in metric units.\n\nA boolean value may be set to true to specify that edges should be oriented by\nthe z-value of their first and last coordinates (decreasing).\n";
    private static final Logger LOGGER;
    public static final String TYPE_ERROR = "Only LINESTRINGs and LINESTRING Zs are accepted. Type code: ";
    public static final String ALREADY_RUN_ERROR = "ST_Graph has already been called on table ";

    public ST_Graph() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "createGraph";
    }

    public static boolean createGraph(Connection connection, String tableName) throws SQLException {
        return ST_Graph.createGraph(connection, tableName, null);
    }

    public static boolean createGraph(Connection connection, String tableName, String spatialFieldName) throws SQLException {
        return ST_Graph.createGraph(connection, tableName, spatialFieldName, 0.0);
    }

    public static boolean createGraph(Connection connection, String tableName, String spatialFieldName, double tolerance) throws SQLException {
        return ST_Graph.createGraph(connection, tableName, spatialFieldName, tolerance, false);
    }

    public static boolean createGraph(Connection connection, String inputTable, String spatialFieldName, double tolerance, boolean orientBySlope) throws SQLException {
        return ST_Graph.createGraph(connection, inputTable, spatialFieldName, tolerance, orientBySlope, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createGraph(Connection connection, String inputTable, String spatialFieldName, double tolerance, boolean orientBySlope, boolean deleteTables) throws SQLException {
        Map.Entry result;
        if (tolerance < 0.0) {
            throw new IllegalArgumentException("Only positive tolerances are allowed.");
        }
        TableLocation tableName = TableUtilities.parseInputTable((Connection)connection, (String)inputTable);
        TableLocation nodesName = TableUtilities.suffixTableLocation((TableLocation)tableName, (String)NODES_SUFFIX);
        TableLocation edgesName = TableUtilities.suffixTableLocation((TableLocation)tableName, (String)EDGES_SUFFIX);
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        if (deleteTables) {
            try (Statement stmt = connection.createStatement();){
                StringBuilder sb = new StringBuilder("drop table if exists ");
                sb.append(nodesName.toString()).append(",").append(edgesName.toString());
                stmt.execute(sb.toString());
            }
        } else if (JDBCUtilities.tableExists((Connection)connection, (TableLocation)nodesName) || JDBCUtilities.tableExists((Connection)connection, (TableLocation)edgesName)) {
            throw new IllegalArgumentException(ALREADY_RUN_ERROR + tableName.getTable());
        }
        PTS_TABLE = TableLocation.parse((String)(System.currentTimeMillis() + "_PTS"), (DBTypes)dbType).toString();
        COORDS_TABLE = TableLocation.parse((String)(System.currentTimeMillis() + "_COORDS"), (DBTypes)dbType).toString();
        Tuple pkIndex = JDBCUtilities.getIntegerPrimaryKeyNameAndIndex((Connection)connection, (TableLocation)tableName);
        if (pkIndex == null) {
            throw new IllegalStateException("Table " + tableName.getTable() + " must contain a single integer primary key.");
        }
        LinkedHashMap geomMetadatas = GeometryTableUtilities.getMetaData((Connection)connection, (TableLocation)tableName);
        Map.Entry geometryMetada = geomMetadatas.entrySet().iterator().next();
        if (spatialFieldName != null && !spatialFieldName.isEmpty() && (result = (Map.Entry)geomMetadatas.entrySet().stream().filter(columnName -> spatialFieldName.equalsIgnoreCase((String)columnName.getKey())).findAny().orElse(null)) != null) {
            geometryMetada = result;
        }
        ST_Graph.checkGeometryType(((GeometryMetaData)geometryMetada.getValue()).geometryTypeCode);
        Statement st = connection.createStatement();
        try {
            ST_Graph.firstFirstLastLast(st, tableName, (String)pkIndex.first(), (String)geometryMetada.getKey(), tolerance);
            int srid = ((GeometryMetaData)geometryMetada.getValue()).SRID;
            boolean hasZ = ((GeometryMetaData)geometryMetada.getValue()).hasZ;
            ST_Graph.makeEnvelopes(st, tolerance, dbType, srid, hasZ);
            ST_Graph.nodesTable(st, nodesName, tolerance, srid, hasZ);
            ST_Graph.edgesTable(st, nodesName, edgesName, tolerance, dbType);
            ST_Graph.checkForNullEdgeEndpoints(st, edgesName);
            if (orientBySlope) {
                ST_Graph.orientBySlope(st, nodesName, edgesName);
            }
        }
        finally {
            st.execute("DROP TABLE IF EXISTS " + PTS_TABLE + "," + COORDS_TABLE);
            st.close();
        }
        return true;
    }

    private static void checkGeometryType(int geomType) throws SQLException {
        if (geomType != 2 && geomType != 1002) {
            throw new IllegalArgumentException(TYPE_ERROR);
        }
    }

    private static String expand(String geom, double tol) {
        return "ST_Expand(" + geom + ", " + tol + ")";
    }

    private static void firstFirstLastLast(Statement st, TableLocation tableName, String pkCol, String geomCol, double tolerance) throws SQLException {
        LOGGER.info("Selecting the first coordinate of the first geometry and the last coordinate of the last geometry...");
        String numGeoms = "ST_NumGeometries(" + geomCol + ")";
        String firstGeom = "ST_GeometryN(" + geomCol + ", 1)";
        String firstPointFirstGeom = "ST_PointN(" + firstGeom + ", 1)";
        String lastGeom = "ST_GeometryN(" + geomCol + ", " + numGeoms + ")";
        String lastPointLastGeom = "ST_PointN(" + lastGeom + ", ST_NumPoints(" + lastGeom + "))";
        st.execute("drop TABLE if exists " + COORDS_TABLE);
        if (tolerance > 0.0) {
            st.execute("CREATE TABLE " + COORDS_TABLE + " AS SELECT " + pkCol + " EDGE_ID, " + firstPointFirstGeom + " START_POINT, " + ST_Graph.expand(firstPointFirstGeom, tolerance) + " START_POINT_EXP, " + lastPointLastGeom + " END_POINT, " + ST_Graph.expand(lastPointLastGeom, tolerance) + " END_POINT_EXP FROM " + tableName);
        } else {
            st.execute("CREATE  TABLE " + COORDS_TABLE + " AS SELECT " + pkCol + " EDGE_ID, " + firstPointFirstGeom + " START_POINT, " + lastPointLastGeom + " END_POINT FROM " + tableName);
        }
    }

    private static void makeEnvelopes(Statement st, double tolerance, DBTypes dbType, int srid, boolean hasZ) throws SQLException {
        String pointSignature;
        st.execute("DROP TABLE IF EXISTS" + PTS_TABLE + ";");
        String string = pointSignature = hasZ ? "POINTZ" : "POINT";
        if (tolerance > 0.0) {
            LOGGER.info("Calculating envelopes around coordinates...");
            st.execute("CREATE  TABLE " + PTS_TABLE + "( ID SERIAL PRIMARY KEY, THE_GEOM GEOMETRY(" + pointSignature + "," + srid + "),AREA GEOMETRY(POLYGON, " + srid + ")) ");
            st.execute("INSERT INTO " + PTS_TABLE + " (SELECT CAST((row_number() over()) as Integer) , a.THE_GEOM, A.AREA FROM  (SELECT  START_POINT AS THE_GEOM, START_POINT_EXP as AREA FROM " + COORDS_TABLE + " UNION ALL SELECT  END_POINT AS THE_GEOM, END_POINT_EXP as AREA FROM " + COORDS_TABLE + ") as a);");
            if (dbType == DBTypes.H2 || dbType == DBTypes.H2GIS) {
                st.execute("CREATE SPATIAL INDEX ON " + PTS_TABLE + "(AREA);");
            } else {
                st.execute("CREATE INDEX ON " + PTS_TABLE + " USING GIST(AREA);");
            }
        } else {
            LOGGER.info("Preparing temporary nodes table from coordinates...");
            st.execute("CREATE  TABLE " + PTS_TABLE + "( ID SERIAL PRIMARY KEY, THE_GEOM GEOMETRY(" + pointSignature + "," + srid + "))");
            st.execute("INSERT INTO " + PTS_TABLE + " (SELECT (row_number() over())::int , a.the_geom FROM (SELECT  START_POINT as THE_GEOM FROM " + COORDS_TABLE + " UNION ALL SELECT  END_POINT as THE_GEOM FROM " + COORDS_TABLE + ") as a);");
            if (dbType == DBTypes.H2 || dbType == DBTypes.H2GIS) {
                st.execute("CREATE SPATIAL INDEX ON " + PTS_TABLE + "(THE_GEOM);");
            } else {
                st.execute("CREATE INDEX ON " + PTS_TABLE + " USING GIST(THE_GEOM);");
            }
        }
    }

    private static void nodesTable(Statement st, TableLocation nodesName, double tolerance, int srid, boolean hasZ) throws SQLException {
        String pointSignature;
        LOGGER.info("Creating the nodes table...");
        String string = pointSignature = hasZ ? "POINTZ" : "POINT";
        if (tolerance > 0.0) {
            st.execute("CREATE TABLE " + nodesName + "(NODE_ID SERIAL PRIMARY KEY, THE_GEOM GEOMETRY(" + pointSignature + ", " + srid + "), EXP GEOMETRY(POLYGON," + srid + ")) ");
            st.execute("INSERT INTO " + nodesName + " (SELECT CAST((row_number() over()) AS INTEGER) , c.the_geom, c.area FROM (SELECT  A.THE_GEOM, A.AREA FROM " + PTS_TABLE + " as  A, " + PTS_TABLE + " as B WHERE A.AREA && B.AREA GROUP BY A.ID HAVING A.ID=MIN(B.ID)) as c);");
        } else {
            st.execute("CREATE TABLE " + nodesName + "(NODE_ID SERIAL PRIMARY KEY, THE_GEOM GEOMETRY(" + pointSignature + ", " + srid + ")) ");
            st.execute("INSERT INTO " + nodesName + " (SELECT CAST((row_number() over()) as INTEGER) , c.the_geom FROM (SELECT A.THE_GEOM FROM " + PTS_TABLE + " as A," + PTS_TABLE + " as B WHERE A.THE_GEOM && B.THE_GEOM AND A.THE_GEOM=B.THE_GEOM GROUP BY A.ID HAVING A.ID=MIN(B.ID)) as c);");
        }
    }

    private static void edgesTable(Statement st, TableLocation nodesName, TableLocation edgesName, double tolerance, DBTypes dbType) throws SQLException {
        LOGGER.info("Creating the edges table...");
        if (tolerance > 0.0) {
            if (dbType == DBTypes.H2 || dbType == DBTypes.H2GIS) {
                st.execute("CREATE SPATIAL INDEX ON " + nodesName + "(EXP);");
                st.execute("CREATE SPATIAL INDEX ON " + COORDS_TABLE + "(START_POINT_EXP);");
                st.execute("CREATE SPATIAL INDEX ON " + COORDS_TABLE + "(END_POINT_EXP);");
            } else {
                st.execute("CREATE  INDEX ON " + nodesName + " USING GIST(EXP);");
                st.execute("CREATE  INDEX ON " + COORDS_TABLE + " USING GIST(START_POINT_EXP);");
                st.execute("CREATE  INDEX ON " + COORDS_TABLE + " USING GIST(END_POINT_EXP);");
            }
            st.execute("CREATE TABLE " + edgesName + " AS SELECT EDGE_ID, (SELECT NODE_ID FROM " + nodesName + " WHERE " + nodesName + ".EXP && " + COORDS_TABLE + ".START_POINT_EXP LIMIT 1) START_NODE, (SELECT NODE_ID FROM " + nodesName + " WHERE " + nodesName + ".EXP && " + COORDS_TABLE + ".END_POINT_EXP LIMIT 1) END_NODE FROM " + COORDS_TABLE + ";");
            st.execute("ALTER TABLE " + nodesName + " DROP COLUMN EXP;");
        } else {
            if (dbType == DBTypes.H2 || dbType == DBTypes.H2GIS) {
                st.execute("CREATE SPATIAL INDEX ON " + nodesName + "(THE_GEOM);");
                st.execute("CREATE SPATIAL INDEX ON " + COORDS_TABLE + "(START_POINT);");
                st.execute("CREATE SPATIAL INDEX ON " + COORDS_TABLE + "(END_POINT);");
            } else {
                st.execute("CREATE INDEX ON " + nodesName + " USING GIST(THE_GEOM);");
                st.execute("CREATE INDEX ON " + COORDS_TABLE + " USING GIST(START_POINT);");
                st.execute("CREATE INDEX ON " + COORDS_TABLE + " USING GIST(END_POINT);");
            }
            st.execute("CREATE TABLE " + edgesName + " AS SELECT EDGE_ID, (SELECT NODE_ID FROM " + nodesName + " WHERE " + nodesName + ".THE_GEOM && " + COORDS_TABLE + ".START_POINT AND " + nodesName + ".THE_GEOM=" + COORDS_TABLE + ".START_POINT LIMIT 1) START_NODE, (SELECT NODE_ID FROM " + nodesName + " WHERE " + nodesName + ".THE_GEOM && " + COORDS_TABLE + ".END_POINT AND " + nodesName + ".THE_GEOM=" + COORDS_TABLE + ".END_POINT LIMIT 1) END_NODE FROM " + COORDS_TABLE + ";");
        }
    }

    private static void orientBySlope(Statement st, TableLocation nodesName, TableLocation edgesName) throws SQLException {
        LOGGER.info("Orienting edges by slope...");
        st.execute("UPDATE " + edgesName + " c SET START_NODE=END_NODE,     END_NODE=START_NODE WHERE (SELECT ST_Z(A.THE_GEOM) < ST_Z(B.THE_GEOM) FROM " + nodesName + " A, " + nodesName + " B WHERE C.START_NODE=A.NODE_ID AND C.END_NODE=B.NODE_ID);");
    }

    private static void checkForNullEdgeEndpoints(Statement st, TableLocation edgesName) throws SQLException {
        LOGGER.info("Checking for null edge endpoints...");
        try (ResultSet nullEdges = st.executeQuery("SELECT COUNT(*) FROM " + edgesName + " WHERE START_NODE IS NULL OR END_NODE IS NULL;");){
            nullEdges.next();
            int n = nullEdges.getInt(1);
            if (n > 0) {
                String msg = "There " + (n == 1 ? "is one edge " : "are " + n + " edges ");
                throw new IllegalStateException(msg + "with a null start node or end node. Try using a slightly smaller tolerance.");
            }
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)("gui." + ST_Graph.class));
    }
}

