/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.convert.GeometryCoordinateDimension;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class ST_Force3DM
extends DeterministicScalarFunction {
    static final GeometryFactory gf = new GeometryFactory();

    public ST_Force3DM() {
        this.addProperty("remarks", "Forces the geometries into XYM mode.\n If a geometry has no M component, then a 0 M coordinate is tacked on. Z value is removed");
    }

    public String getJavaStaticMethod() {
        return "force3DM";
    }

    public static Geometry force3DM(Geometry geom) {
        if (geom == null) {
            return null;
        }
        return ST_Force3DM.forceXYM(geom);
    }

    public static Geometry forceXYM(Geometry geom) {
        int dimension = 2;
        Geometry g = geom;
        if (geom instanceof Point) {
            CoordinateSequence cs = ((Point)geom).getCoordinateSequence();
            if (cs.getDimension() != dimension || cs.getMeasures() != 1) {
                g = gf.createPoint((CoordinateSequence)ST_Force3DM.convertSequence(cs));
                g.setSRID(geom.getSRID());
            }
        } else if (geom instanceof LineString) {
            CoordinateSequence cs = ((LineString)geom).getCoordinateSequence();
            if (cs.getDimension() != dimension || cs.getMeasures() != 1) {
                g = gf.createLineString((CoordinateSequence)ST_Force3DM.convertSequence(cs));
                g.setSRID(geom.getSRID());
            }
        } else if (geom instanceof Polygon) {
            g = GeometryCoordinateDimension.convert((Polygon)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPoint) {
            g = GeometryCoordinateDimension.convert((MultiPoint)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiLineString) {
            g = GeometryCoordinateDimension.convert((MultiLineString)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof MultiPolygon) {
            g = GeometryCoordinateDimension.convert((MultiPolygon)geom, dimension);
            g.setSRID(geom.getSRID());
        } else if (geom instanceof GeometryCollection) {
            g = GeometryCoordinateDimension.convert((GeometryCollection)geom, dimension);
            g.setSRID(geom.getSRID());
        }
        return g;
    }

    public static GeometryCollection convert(GeometryCollection gc, int dimension) {
        int nb = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[nb];
        for (int i = 0; i < nb; ++i) {
            geometries[i] = ST_Force3DM.forceXYM(gc.getGeometryN(i));
        }
        return gf.createGeometryCollection(geometries);
    }

    public static MultiPolygon convert(MultiPolygon multiPolygon, int dimension) {
        int nb = multiPolygon.getNumGeometries();
        Polygon[] pl = new Polygon[nb];
        for (int i = 0; i < nb; ++i) {
            pl[i] = GeometryCoordinateDimension.convert((Polygon)multiPolygon.getGeometryN(i), dimension);
        }
        return gf.createMultiPolygon(pl);
    }

    public static MultiLineString convert(MultiLineString multiLineString, int dimension) {
        int nb = multiLineString.getNumGeometries();
        LineString[] ls = new LineString[nb];
        for (int i = 0; i < nb; ++i) {
            ls[i] = GeometryCoordinateDimension.convert((LineString)multiLineString.getGeometryN(i), dimension);
        }
        return gf.createMultiLineString(ls);
    }

    public static Polygon convert(Polygon polygon, int dimension) {
        CoordinateSequence cs = polygon.getExteriorRing().getCoordinateSequence();
        if (cs.getDimension() != dimension || cs.getMeasures() == 1) {
            LinearRing shell = gf.createLinearRing((CoordinateSequence)ST_Force3DM.convertSequence(cs));
            int nbOfHoles = polygon.getNumInteriorRing();
            LinearRing[] holes = new LinearRing[nbOfHoles];
            for (int i = 0; i < nbOfHoles; ++i) {
                CoordinateSequence csHole = polygon.getInteriorRingN(i).getCoordinateSequence();
                holes[i] = csHole.getDimension() != dimension || cs.getMeasures() == 1 ? gf.createLinearRing((CoordinateSequence)ST_Force3DM.convertSequence(csHole)) : gf.createLinearRing(polygon.getInteriorRingN(i).getCoordinates());
            }
            Polygon p = gf.createPolygon(shell, holes);
            p.setSRID(polygon.getSRID());
            return p;
        }
        return polygon;
    }

    public static LineString convert(LineString lineString, int dimension) {
        CoordinateSequence cs = lineString.getCoordinateSequence();
        if (cs.getDimension() != dimension || cs.getMeasures() == 1) {
            return gf.createLineString((CoordinateSequence)ST_Force3DM.convertSequence(cs));
        }
        return lineString;
    }

    public static LinearRing convert(LinearRing linearRing, int dimension) {
        return gf.createLinearRing((CoordinateSequence)ST_Force3DM.convertSequence(linearRing.getCoordinateSequence()));
    }

    private static CoordinateArraySequence convertSequence(CoordinateSequence cs) {
        boolean hasM = false;
        if (cs.getMeasures() == 1) {
            hasM = true;
        }
        CoordinateXYM[] coordsXYM = new CoordinateXYM[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate coordTmp = cs.getCoordinate(i);
            CoordinateXYM coord = new CoordinateXYM(coordTmp);
            if (hasM) {
                coord.setM(coordTmp.getM());
            } else {
                double z = coord.z;
                if (Double.isNaN(z)) {
                    coord.z = 0.0;
                }
            }
            coordsXYM[i] = coord;
        }
        return new CoordinateArraySequence((Coordinate[])coordsXYM, 2, 1);
    }

    private static CoordinateArraySequence convertXYZMSequence(CoordinateSequence cs, int dimension) {
        boolean hasM = false;
        if (cs.getMeasures() == 1) {
            hasM = true;
        }
        CoordinateXYZM[] coordsXYZM = new CoordinateXYZM[cs.size()];
        for (int i = 0; i < cs.size(); ++i) {
            Coordinate coordTmp = cs.getCoordinate(i);
            CoordinateXYZM coord = new CoordinateXYZM(coordTmp);
            if (hasM) {
                coord.setM(coordTmp.getM());
                coord.setZ(0.0);
            } else {
                double z = coord.z;
                if (Double.isNaN(z)) {
                    coord.z = 0.0;
                }
            }
            coordsXYZM[i] = coord;
        }
        return new CoordinateArraySequence((Coordinate[])coordsXYZM, dimension);
    }
}

