/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.aggregate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.h2.api.Aggregate;
import org.h2gis.api.AbstractFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class ST_Accum
extends AbstractFunction
implements Aggregate {
    private List<Geometry> toUnite = new LinkedList<Geometry>();
    private int minDim = Integer.MAX_VALUE;
    private int maxDim = Integer.MIN_VALUE;
    private int srid = -1;

    public ST_Accum() {
        this.addProperty("remarks", "This aggregate function returns a GeometryCollection from a column of mixed dimension Geometries.\nIf there is only POINTs in the column of Geometries, a MULTIPOINT is returned. \nSame process with LINESTRINGs and POLYGONs.");
    }

    public void init(Connection connection) throws SQLException {
    }

    public int getInternalType(int[] inputTypes) throws SQLException {
        if (inputTypes.length != 1) {
            throw new SQLException(ST_Accum.class.getSimpleName() + " expects 1 argument.");
        }
        if (inputTypes[0] != 22) {
            throw new SQLException(ST_Accum.class.getSimpleName() + " expects a Geometry argument");
        }
        return 22;
    }

    private void feedDim(Geometry geometry) {
        int geomDim = geometry.getDimension();
        this.maxDim = Math.max(this.maxDim, geomDim);
        this.minDim = Math.min(this.minDim, geomDim);
    }

    private void addGeometry(Geometry geom) {
        if (geom != null) {
            if (geom instanceof GeometryCollection) {
                ArrayList<Geometry> toUnitTmp = new ArrayList<Geometry>(geom.getNumGeometries());
                for (int i = 0; i < geom.getNumGeometries(); ++i) {
                    toUnitTmp.add(geom.getGeometryN(i));
                    this.feedDim(geom.getGeometryN(i));
                }
                this.toUnite.addAll(toUnitTmp);
            } else {
                this.toUnite.add(geom);
                this.feedDim(geom);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(Object o) throws SQLException {
        if (o instanceof Geometry) {
            Geometry geom = (Geometry)o;
            if (this.srid == -1) {
                this.srid = geom.getSRID();
            }
            if (this.srid != geom.getSRID()) throw new SQLException("Operation on mixed SRID geometries not supported");
            this.addGeometry(geom);
            return;
        } else {
            if (o == null) return;
            throw new SQLException("ST_Accum accepts only Geometry values. Input: " + o.getClass().getSimpleName());
        }
    }

    public GeometryCollection getResult() throws SQLException {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), this.srid == -1 ? 0 : this.srid);
        if (this.maxDim != this.minDim) {
            return factory.createGeometryCollection(this.toUnite.toArray(new Geometry[0]));
        }
        switch (this.maxDim) {
            case 0: {
                return factory.createMultiPoint(this.toUnite.toArray(new Point[0]));
            }
            case 1: {
                return factory.createMultiLineString(this.toUnite.toArray(new LineString[0]));
            }
        }
        return factory.createMultiPolygon(this.toUnite.toArray(new Polygon[0]));
    }
}

