/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.utility.WriteBufferManager;

public class ShapefileHeader {
    public static final int MAGIC = 9994;
    public static final int VERSION = 1000;
    private int fileCode = -1;
    private int fileLength = -1;
    private int version = -1;
    private ShapeType shapeType = ShapeType.UNDEFINED;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    private void checkMagic() throws IOException {
        if (this.fileCode != 9994) {
            throw new IOException("Wrong magic number, expected 9994, got " + this.fileCode);
        }
    }

    private void checkVersion() throws IOException {
        if (this.version != 1000) {
            throw new IOException("Wrong version, expected 9994, got " + this.version);
        }
    }

    public void read(ByteBuffer file) throws IOException {
        file.order(ByteOrder.BIG_ENDIAN);
        this.fileCode = file.getInt();
        this.checkMagic();
        file.position(file.position() + 20);
        this.fileLength = file.getInt();
        file.order(ByteOrder.LITTLE_ENDIAN);
        this.version = file.getInt();
        this.checkVersion();
        this.shapeType = ShapeType.forID(file.getInt());
        this.minX = file.getDouble();
        this.minY = file.getDouble();
        this.maxX = file.getDouble();
        this.maxY = file.getDouble();
        file.order(ByteOrder.BIG_ENDIAN);
        file.position(file.position() + 32);
    }

    public void write(WriteBufferManager shapeBuffer, ShapeType type, int numGeoms, int length, double minX, double minY, double maxX, double maxY) throws IOException {
        int i;
        shapeBuffer.order(ByteOrder.BIG_ENDIAN);
        shapeBuffer.putInt(9994);
        for (i = 0; i < 5; ++i) {
            shapeBuffer.putInt(0);
        }
        shapeBuffer.putInt(length);
        shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        shapeBuffer.putInt(1000);
        shapeBuffer.putInt(type.id);
        shapeBuffer.putDouble(minX);
        shapeBuffer.putDouble(minY);
        shapeBuffer.putDouble(maxX);
        shapeBuffer.putDouble(maxY);
        shapeBuffer.order(ByteOrder.BIG_ENDIAN);
        for (i = 0; i < 8; ++i) {
            shapeBuffer.putInt(0);
        }
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getVersion() {
        return this.version;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("ShapeFileHeader[ size ").append(this.fileLength).append(" version ");
        res.append(this.version).append(" shapeType ").append(this.shapeType);
        res.append(" bounds ").append(this.minX).append(",").append(this.minY);
        res.append(",").append(this.maxX).append(",").append(this.maxY).append(" ]");
        return res.toString();
    }
}

