/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.shp.SHPDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class SHPWrite
extends AbstractFunction
implements ScalarFunction {
    public SHPWrite() {
        this.addProperty("remarks", "Transfer the content of a table into a new shape file)\nSHPWrite(...\n Supported arguments :\n path of the file, table name\n path of the file, table name, true to delete the file if exists\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the file if exists");
    }

    public String getJavaStaticMethod() {
        return "exportTable";
    }

    public static void exportTable(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        SHPWrite.exportTable(connection, fileName, tableReference, null, false);
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, Value option) throws IOException, SQLException {
        String encoding = null;
        boolean deleteFiles = false;
        if (option instanceof ValueBoolean) {
            deleteFiles = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        SHPWrite.exportTable(connection, fileName, tableReference, encoding, deleteFiles);
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, String encoding, boolean deleteFiles) throws IOException, SQLException {
        SHPDriverFunction shpDriverFunction = new SHPDriverFunction();
        shpDriverFunction.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), encoding, deleteFiles, (ProgressVisitor)new EmptyProgressVisitor());
    }
}

