/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class DBFWrite
extends AbstractFunction
implements ScalarFunction {
    public DBFWrite() {
        this.addProperty("remarks", "Transfer the content of a table into a DBF\n\n DBFWrite(...\n Supported arguments :\n path of the file, table name\n path of the file, table name, true to delete the file if exists\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the file if exists");
    }

    public String getJavaStaticMethod() {
        return "exportTable";
    }

    public static void exportTable(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        DBFDriverFunction driverFunction = new DBFDriverFunction();
        driverFunction.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, String encoding, boolean deleteFile) throws IOException, SQLException {
        DBFDriverFunction driverFunction = new DBFDriverFunction();
        driverFunction.exportTable(connection, tableReference, new File(fileName), encoding, deleteFile, (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, Value option) throws IOException, SQLException {
        String encoding = null;
        boolean deleteFiles = false;
        if (option instanceof ValueBoolean) {
            deleteFiles = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        DBFWrite.exportTable(connection, fileName, tableReference, encoding, deleteFiles);
    }
}

