/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueNumeric
extends Value {
    public static final ValueNumeric ZERO = new ValueNumeric(BigDecimal.ZERO);
    public static final ValueNumeric ONE = new ValueNumeric(BigDecimal.ONE);
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = 0;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    public static final int MAXIMUM_SCALE = 100000;
    public static final int MINIMUM_SCALE = -100000;
    private final BigDecimal value;
    private TypeInfo type;

    private ValueNumeric(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null");
        }
        if (bigDecimal.getClass() != BigDecimal.class) {
            throw DbException.get(90125, BigDecimal.class.getName(), bigDecimal.getClass().getName());
        }
        this.value = bigDecimal;
    }

    @Override
    public Value add(Value value) {
        ValueNumeric valueNumeric = (ValueNumeric)value;
        return ValueNumeric.get(this.value.add(valueNumeric.value));
    }

    @Override
    public Value subtract(Value value) {
        ValueNumeric valueNumeric = (ValueNumeric)value;
        return ValueNumeric.get(this.value.subtract(valueNumeric.value));
    }

    @Override
    public Value negate() {
        return ValueNumeric.get(this.value.negate());
    }

    @Override
    public Value multiply(Value value) {
        ValueNumeric valueNumeric = (ValueNumeric)value;
        return ValueNumeric.get(this.value.multiply(valueNumeric.value));
    }

    @Override
    public Value divide(Value value, long l) {
        BigDecimal bigDecimal = ((ValueNumeric)value).value;
        if (bigDecimal.signum() == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueNumeric.get(this.value.divide(bigDecimal, ValueNumeric.getQuotientScale(this.value.scale(), l, bigDecimal.scale()), RoundingMode.HALF_DOWN));
    }

    public static int getQuotientScale(int n, long l, int n2) {
        long l2 = (long)(n - n2) + l * 2L;
        return l2 >= 100000L ? 100000 : (int)l2;
    }

    @Override
    public ValueNumeric modulus(Value value) {
        ValueNumeric valueNumeric = (ValueNumeric)value;
        if (valueNumeric.value.signum() == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        BigDecimal bigDecimal = this.value.remainder(valueNumeric.value);
        return ValueNumeric.get(bigDecimal);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        String string = this.getString();
        if ((n & 4) == 0 && this.value.scale() == 0 && this.value.compareTo(MAX_LONG_DECIMAL) <= 0 && this.value.compareTo(MIN_LONG_DECIMAL) >= 0) {
            return stringBuilder.append("CAST(").append(this.value).append(" AS NUMERIC(").append(this.value.precision()).append("))");
        }
        return stringBuilder.append(string);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            long l = this.value.precision();
            this.type = typeInfo = new TypeInfo(6, l, this.value.scale(), MathUtils.convertLongToInt(l + 2L), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return 6;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return this.value.compareTo(((ValueNumeric)value).value);
    }

    @Override
    public int getSignum() {
        return this.value.signum();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    public static ValueNumeric get(BigDecimal bigDecimal) {
        if (BigDecimal.ZERO.equals(bigDecimal)) {
            return ZERO;
        }
        if (BigDecimal.ONE.equals(bigDecimal)) {
            return ONE;
        }
        return (ValueNumeric)Value.cache(new ValueNumeric(bigDecimal));
    }

    public static ValueNumeric get(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return ZERO;
        }
        if (BigInteger.ONE.equals(bigInteger)) {
            return ONE;
        }
        return (ValueNumeric)Value.cache(new ValueNumeric(new BigDecimal(bigInteger)));
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueNumeric && this.value.equals(((ValueNumeric)object).value);
    }

    @Override
    public int getMemory() {
        return this.value.precision() + 120;
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) {
        if (n > 100000 || n < -100000) {
            throw DbException.getInvalidValueException("scale", n);
        }
        return bigDecimal.setScale(n, RoundingMode.HALF_UP);
    }
}

