/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.RowDataType;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.type.DataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.VersionedValue;

public final class MVSecondaryIndex
extends BaseIndex
implements MVIndex<SearchRow, Value> {
    private final MVTable mvTable;
    private final TransactionMap<SearchRow, Value> dataMap;

    public MVSecondaryIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(mVTable, n, string, indexColumnArray, indexType);
        this.mvTable = mVTable;
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(indexColumnArray);
        }
        String string2 = "index." + this.getId();
        assert (database.isStarting() || !database.getStore().getMvStore().getMetaMap().containsKey("name." + string2));
        RowDataType rowDataType = this.getRowFactory().getRowDataType();
        ValueDataType valueDataType = new ValueDataType();
        Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(string2, rowDataType, valueDataType);
        this.dataMap.map.setVolatile(!mVTable.isPersistData() || !indexType.isPersistent());
        transaction.commit();
        if (!rowDataType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type, expected " + rowDataType + " but got " + this.dataMap.getKeyType() + " for index " + string);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        MVMap<SearchRow, Value> mVMap = this.openMap(string);
        for (Row row : list) {
            SearchRow searchRow = this.getRowFactory().createRow();
            searchRow.copyFrom(row);
            mVMap.append(searchRow, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> list) {
        Object object;
        int n = list.size();
        PriorityQueue<Source> priorityQueue = new PriorityQueue<Source>(n, new Source.Comparator(this.getRowFactory().getRowDataType()));
        for (String object2 : list) {
            Iterator<Object> iterator = this.openMap(object2).keyIterator(null);
            if (!iterator.hasNext()) continue;
            priorityQueue.offer(new Source(iterator));
        }
        try {
            while (!priorityQueue.isEmpty()) {
                object = (Source)priorityQueue.poll();
                SearchRow searchRow = ((Source)object).next();
                if (this.indexType.isUnique() && !this.mayHaveNullDuplicates(searchRow)) {
                    this.checkUnique(true, this.dataMap, searchRow, Long.MIN_VALUE);
                }
                this.dataMap.putCommitted(searchRow, ValueNull.INSTANCE);
                if (!((Source)object).hasNext()) continue;
                priorityQueue.offer((Source)object);
            }
        }
        finally {
            object = this.database.getStore().getMvStore();
            for (String string : list) {
                ((MVStore)object).removeMap(string);
            }
        }
    }

    private MVMap<SearchRow, Value> openMap(String string) {
        RowDataType rowDataType = this.getRowFactory().getRowDataType();
        ValueDataType valueDataType = new ValueDataType();
        MVMap.BasicBuilder basicBuilder = ((MVMap.Builder)new MVMap.Builder().singleWriter().keyType((DataType)rowDataType)).valueType((DataType)valueDataType);
        Object m = this.database.getStore().getMvStore().openMap(string, basicBuilder);
        if (!rowDataType.equals(((MVMap)m).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type, expected " + rowDataType + " but got " + ((MVMap)m).getKeyType() + " for map " + string);
        }
        return m;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        boolean bl;
        boolean bl2;
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        SearchRow searchRow = this.convertToKey(row, null);
        if (this.indexType.isUnique() && !this.mayHaveNullDuplicates(row)) {
            bl2 = true;
            bl = session.getTransaction().getIsolationLevel().allowNonRepeatableRead();
        } else {
            bl2 = false;
            bl = false;
        }
        if (bl2) {
            this.checkUnique(bl, transactionMap, row, Long.MIN_VALUE);
        }
        try {
            transactionMap.put(searchRow, ValueNull.INSTANCE);
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        if (bl2) {
            this.checkUnique(bl, transactionMap, row, row.getKey());
        }
    }

    private void checkUnique(boolean bl, TransactionMap<SearchRow, Value> transactionMap, SearchRow searchRow, long l) {
        SearchRow searchRow2;
        Iterator<SearchRow> iterator;
        SearchRow searchRow3 = this.convertToKey(searchRow, Boolean.FALSE);
        SearchRow searchRow4 = this.convertToKey(searchRow, Boolean.TRUE);
        if (!bl) {
            iterator = transactionMap.keyIterator(searchRow3, searchRow4);
            while (iterator.hasNext()) {
                searchRow2 = iterator.next();
                if (l == searchRow2.getKey() || transactionMap.isDeletedByCurrentTransaction(searchRow2)) continue;
                throw this.getDuplicateKeyException(searchRow2.toString());
            }
        }
        iterator = transactionMap.keyIteratorUncommitted(searchRow3, searchRow4);
        while (iterator.hasNext()) {
            searchRow2 = iterator.next();
            if (l == searchRow2.getKey()) continue;
            if (transactionMap.getImmediate(searchRow2) != null) {
                throw this.getDuplicateKeyException(searchRow2.toString());
            }
            throw DbException.get(90131, this.table.getName());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        SearchRow searchRow = this.convertToKey(row, null);
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        try {
            if (transactionMap.remove(searchRow) == null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.getSQL(stringBuilder, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, stringBuilder.toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public void update(Session session, Row row, Row row2) {
        SearchRow searchRow;
        SearchRow searchRow2 = this.convertToKey(row, null);
        if (!this.rowsAreEqual(searchRow2, searchRow = this.convertToKey(row2, null))) {
            super.update(session, row, row2);
        }
    }

    private boolean rowsAreEqual(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return true;
        }
        for (int n : this.columnIds) {
            Value value;
            Value value2 = searchRow.getValue(n);
            if (Objects.equals(value2, value = searchRow2.getValue(n))) continue;
            return false;
        }
        return searchRow.getKey() == searchRow2.getKey();
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) {
        SearchRow searchRow3 = this.convertToKey(searchRow, bl);
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        SearchRow searchRow4 = this.convertToKey(searchRow2, Boolean.TRUE);
        return new MVStoreCursor(session, transactionMap.keyIterator(searchRow3, searchRow4), this.mvTable);
    }

    private SearchRow convertToKey(SearchRow searchRow, Boolean bl) {
        if (searchRow == null) {
            return null;
        }
        SearchRow searchRow2 = this.getRowFactory().createRow();
        searchRow2.copyFrom(searchRow);
        if (bl != null) {
            searchRow2.setKey(bl != false ? Long.MAX_VALUE : Long.MIN_VALUE);
        }
        return searchRow2;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilterArray, n, sortOrder, false, allColumnsForPlan);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            Transaction transaction = session.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        SearchRow searchRow;
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        SearchRow searchRow2 = searchRow = bl ? transactionMap.firstKey() : transactionMap.lastKey();
        while (searchRow != null) {
            if (searchRow.getValue(this.columnIds[0]) != ValueNull.INSTANCE) {
                return new SingleRowCursor(this.mvTable.getRow(session, searchRow.getKey()));
            }
            searchRow = bl ? transactionMap.higherKey(searchRow) : transactionMap.lowerKey(searchRow);
        }
        return new SingleRowCursor(null);
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<SearchRow, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, true, searchRow2);
    }

    private TransactionMap<SearchRow, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction transaction = session.getTransaction();
        return this.dataMap.getInstance(transaction);
    }

    @Override
    public MVMap<SearchRow, VersionedValue<Value>> getMVMap() {
        return this.dataMap.map;
    }

    static final class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<SearchRow> it;
        private final MVTable mvTable;
        private SearchRow current;
        private Row row;

        MVStoreCursor(Session session, Iterator<SearchRow> iterator, MVTable mVTable) {
            this.session = session;
            this.it = iterator;
            this.mvTable = mVTable;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.current;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }

    private static final class Source {
        private final Iterator<SearchRow> iterator;
        SearchRow currentRowData;

        public Source(Iterator<SearchRow> iterator) {
            assert (iterator.hasNext());
            this.iterator = iterator;
            this.currentRowData = iterator.next();
        }

        public boolean hasNext() {
            boolean bl = this.iterator.hasNext();
            if (bl) {
                this.currentRowData = this.iterator.next();
            }
            return bl;
        }

        public SearchRow next() {
            return this.currentRowData;
        }

        static final class Comparator
        implements java.util.Comparator<Source> {
            private final DataType<SearchRow> type;

            public Comparator(DataType<SearchRow> dataType) {
                this.type = dataType;
            }

            @Override
            public int compare(Source source, Source source2) {
                return this.type.compare(source.currentRowData, source2.currentRowData);
            }
        }
    }
}

