/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import org.h2.engine.Session;
import org.h2.expression.aggregate.AggregateDataCollecting;
import org.h2.expression.aggregate.AggregateDataCount;
import org.h2.expression.aggregate.AggregateDataDefault;
import org.h2.expression.aggregate.AggregateDataDistinctWithCounts;
import org.h2.expression.aggregate.AggregateDataEnvelope;
import org.h2.expression.aggregate.AggregateType;
import org.h2.message.DbException;
import org.h2.value.Value;

abstract class AggregateData {
    AggregateData() {
    }

    static AggregateData create(AggregateType aggregateType, boolean bl, int n, boolean bl2) {
        switch (aggregateType) {
            case COUNT_ALL: {
                return new AggregateDataCount(true);
            }
            case COUNT: {
                if (bl) break;
                return new AggregateDataCount(false);
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: 
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: 
            case MEDIAN: 
            case JSON_ARRAYAGG: 
            case JSON_OBJECTAGG: {
                break;
            }
            case MIN: 
            case MAX: 
            case BIT_OR: 
            case BIT_AND: 
            case ANY: 
            case EVERY: {
                return new AggregateDataDefault(aggregateType, n);
            }
            case SUM: 
            case AVG: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (bl) break;
                return new AggregateDataDefault(aggregateType, n);
            }
            case HISTOGRAM: {
                return new AggregateDataDistinctWithCounts(false, 10000);
            }
            case LISTAGG: 
            case ARRAY_AGG: {
                return new AggregateDataCollecting(bl, bl2);
            }
            case MODE: {
                return new AggregateDataDistinctWithCounts(true, Integer.MAX_VALUE);
            }
            case ENVELOPE: {
                return new AggregateDataEnvelope();
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)aggregateType));
            }
        }
        return new AggregateDataCollecting(bl, false);
    }

    abstract void add(Session var1, Value var2);

    abstract Value getValue(Session var1);
}

