/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.dml.Query;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableValueConstructorTable;
import org.h2.value.Value;

public class TableValueConstructor
extends Query {
    private final ArrayList<ArrayList<Expression>> rows;
    final TableValueConstructorTable table;
    private final TableValueColumnResolver columnResolver;
    private boolean isPrepared;
    private boolean checkInit;
    private double cost;

    public TableValueConstructor(Session session, Column[] columnArray, ArrayList<ArrayList<Expression>> arrayList) {
        super(session);
        this.rows = arrayList;
        Database database = session.getDatabase();
        int n = columnArray.length;
        ArrayList<ExpressionColumn> arrayList2 = new ArrayList<ExpressionColumn>(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(new ExpressionColumn(database, null, null, columnArray[i].getName(), false));
        }
        this.expressions = arrayList2;
        this.table = new TableValueConstructorTable(session.getDatabase().getMainSchema(), session, columnArray, arrayList);
        this.columnResolver = new TableValueColumnResolver();
    }

    public static void getVisibleResult(Session session, ResultTarget resultTarget, Column[] columnArray, ArrayList<ArrayList<Expression>> arrayList) {
        int n = columnArray.length;
        for (ArrayList<Expression> arrayList2 : arrayList) {
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                valueArray[i] = arrayList2.get(i).getValue(session).convertTo(columnArray[i].getType(), (CastDataProvider)session);
            }
            resultTarget.addRow(valueArray);
        }
    }

    public static void getValuesSQL(StringBuilder stringBuilder, int n, ArrayList<ArrayList<Expression>> arrayList) {
        stringBuilder.append("VALUES ");
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('(');
            Expression.writeExpressions(stringBuilder, (List<? extends Expression>)arrayList.get(i), n);
            stringBuilder.append(')');
        }
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    @Override
    protected ResultInterface queryWithoutCache(int n, ResultTarget resultTarget) {
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(n);
        long l = offsetFetch.offset;
        int n2 = offsetFetch.fetch;
        boolean bl = offsetFetch.fetchPercent;
        int n3 = this.visibleColumnCount;
        int n4 = this.resultColumnCount;
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, n3, n4);
        if (this.sort != null) {
            localResult.setSortOrder(this.sort);
        }
        if (this.distinct) {
            localResult.setDistinct();
        }
        Column[] columnArray = this.table.getColumns();
        if (n3 == n4) {
            TableValueConstructor.getVisibleResult(this.session, localResult, columnArray, this.rows);
        } else {
            for (ArrayList<Expression> arrayList : this.rows) {
                int n5;
                Value[] valueArray = new Value[n4];
                for (n5 = 0; n5 < n3; ++n5) {
                    valueArray[n5] = arrayList.get(n5).getValue(this.session).convertTo(columnArray[n5].getType(), (CastDataProvider)this.session);
                }
                this.columnResolver.currentRow = valueArray;
                for (n5 = n3; n5 < n4; ++n5) {
                    valueArray[n5] = this.expressionArray[n5].getValue(this.session);
                }
                localResult.addRow(valueArray);
            }
            this.columnResolver.currentRow = null;
        }
        return this.finishResult(localResult, l, n2, bl, resultTarget);
    }

    @Override
    public void init() {
        if (this.checkInit) {
            DbException.throwInternalError();
        }
        this.visibleColumnCount = this.expressions.size();
        this.checkInit = true;
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
    }

    @Override
    public void prepare() {
        int n;
        if (this.isPrepared) {
            return;
        }
        if (!this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        if (this.orderList != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Expression expression : this.expressions) {
                arrayList.add(expression.getSQL(0));
            }
            TableValueConstructor.initOrder(this.session, this.expressions, arrayList, this.orderList, this.getColumnCount(), false, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.resultColumnCount = this.expressions.size();
        for (n = 0; n < this.resultColumnCount; ++n) {
            ((Expression)this.expressions.get(n)).mapColumns(this.columnResolver, 0, 0);
        }
        for (n = this.visibleColumnCount; n < this.resultColumnCount; ++n) {
            this.expressions.set(n, ((Expression)this.expressions.get(n)).optimize(this.session));
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
        double d = 0.0;
        int n2 = this.visibleColumnCount;
        for (ArrayList<Expression> arrayList : this.rows) {
            for (int i = 0; i < n2; ++i) {
                d += (double)arrayList.get(i).getCost();
            }
        }
        this.cost = d + (double)this.rows.size();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = new HashSet<Table>(1, 1.0f);
        hashSet.add(this.table);
        return hashSet;
    }

    @Override
    public void setForUpdate(boolean bl) {
        throw DbException.get(90140);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        int n2 = this.expressions.size();
        for (ArrayList<Expression> arrayList : this.rows) {
            for (int i = 0; i < n2; ++i) {
                arrayList.get(i).mapColumns(columnResolver, n, 0);
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        int n = this.expressionArray.length;
        for (ArrayList<Expression> arrayList : this.rows) {
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).setEvaluatable(tableFilter, bl);
            }
        }
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
    }

    @Override
    public boolean allowGlobalConditions() {
        return false;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        ExpressionVisitor expressionVisitor2 = expressionVisitor.incrementQueryLevel(1);
        for (Expression expression : this.expressionArray) {
            if (expression.isEverything(expressionVisitor2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        int n2 = this.expressionArray.length;
        for (ArrayList<Expression> arrayList : this.rows) {
            for (int i = 0; i < n2; ++i) {
                arrayList.get(i).updateAggregate(session, n);
            }
        }
    }

    @Override
    public void fireBeforeSelectTriggers() {
    }

    @Override
    public String getPlanSQL(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        TableValueConstructor.getValuesSQL(stringBuilder, n, this.rows);
        this.appendEndOfQueryToSQL(stringBuilder, n, this.expressions.toArray(new Expression[0]));
        return stringBuilder.toString();
    }

    @Override
    public Table toTable(String string, ArrayList<Parameter> arrayList, boolean bl, Query query) {
        if (!this.hasOrder() && this.offsetExpr == null && this.limitExpr == null) {
            return this.table;
        }
        return super.toTable(string, arrayList, bl, query);
    }

    private final class TableValueColumnResolver
    implements ColumnResolver {
        Value[] currentRow;

        TableValueColumnResolver() {
        }

        @Override
        public Column[] getColumns() {
            return TableValueConstructor.this.table.getColumns();
        }

        @Override
        public Column findColumn(String string) {
            return TableValueConstructor.this.table.findColumn(string);
        }

        @Override
        public Value getValue(Column column) {
            return this.currentRow[column.getColumnId()];
        }

        @Override
        public Expression optimize(ExpressionColumn expressionColumn, Column column) {
            return (Expression)TableValueConstructor.this.expressions.get(column.getColumnId());
        }
    }
}

