/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.point;

import java.nio.FloatBuffer;
import org.poly2tri.triangulation.TriangulationPoint;

public class FloatBufferPoint
extends TriangulationPoint {
    private final FloatBuffer _fb;
    private final int _ix;
    private final int _iy;
    private final int _iz;

    public FloatBufferPoint(FloatBuffer fb, int index) {
        this._fb = fb;
        this._ix = index;
        this._iy = index + 1;
        this._iz = index + 2;
    }

    @Override
    public final double getX() {
        return this._fb.get(this._ix);
    }

    @Override
    public final double getY() {
        return this._fb.get(this._iy);
    }

    @Override
    public final double getZ() {
        return this._fb.get(this._iz);
    }

    @Override
    public final float getXf() {
        return this._fb.get(this._ix);
    }

    @Override
    public final float getYf() {
        return this._fb.get(this._iy);
    }

    @Override
    public final float getZf() {
        return this._fb.get(this._iz);
    }

    @Override
    public void set(double x, double y, double z) {
        this._fb.put(this._ix, (float)x);
        this._fb.put(this._iy, (float)y);
        this._fb.put(this._iz, (float)z);
    }

    public static TriangulationPoint[] toPoints(FloatBuffer fb) {
        TriangulationPoint[] points = new FloatBufferPoint[fb.limit() / 3];
        int i = 0;
        int j = 0;
        while (i < points.length) {
            points[i] = new FloatBufferPoint(fb, j);
            ++i;
            j += 3;
        }
        return points;
    }
}

