/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.delaunay.sweep;

import org.poly2tri.triangulation.TriangulationConstraint;
import org.poly2tri.triangulation.TriangulationPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSweepConstraint
extends TriangulationConstraint {
    private static final Logger logger = LoggerFactory.getLogger(DTSweepConstraint.class);
    public TriangulationPoint p;
    public TriangulationPoint q;

    public DTSweepConstraint(TriangulationPoint p1, TriangulationPoint p2) {
        this.p = p1;
        this.q = p2;
        if (p1.getY() > p2.getY()) {
            this.q = p1;
            this.p = p2;
        } else if (p1.getY() == p2.getY()) {
            if (p1.getX() > p2.getX()) {
                this.q = p1;
                this.p = p2;
            } else if (p1.getX() == p2.getX()) {
                logger.info("Failed to create constraint {}={}", (Object)p1, (Object)p2);
            }
        }
        this.q.addEdge(this);
    }

    @Override
    public TriangulationPoint getP() {
        return this.p;
    }

    @Override
    public TriangulationPoint getQ() {
        return this.q;
    }
}

