/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintDomain;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Mode;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.pagestore.PageStore;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int FUNCTION_COLUMNS = 20;
    private static final int CONSTANTS = 21;
    private static final int DOMAINS = 22;
    private static final int TRIGGERS = 23;
    private static final int SESSIONS = 24;
    private static final int LOCKS = 25;
    private static final int SESSION_STATE = 26;
    private static final int QUERY_STATISTICS = 27;
    private static final int SYNONYMS = 28;
    private static final int TABLE_CONSTRAINTS = 29;
    private static final int DOMAIN_CONSTRAINTS = 30;
    private static final int KEY_COLUMN_USAGE = 31;
    private static final int REFERENTIAL_CONSTRAINTS = 32;
    private static final int CHECK_CONSTRAINTS = 33;
    private static final int CONSTRAINT_COLUMN_USAGE = 34;
    private static final int META_TABLE_TYPE_COUNT = 35;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setMetaTableName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "DATETIME_PRECISION INT", "INTERVAL_TYPE", "INTERVAL_PRECISION INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "IS_GENERATED", "GENERATION_EXPRESSION", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT", "COLUMN_TYPE", "COLUMN_ON_UPDATE", "IS_VISIBLE");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "DATA_TYPE", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "START_VALUE BIGINT", "MINIMUM_VALUE BIGINT", "MAXIMUM_VALUE BIGINT", "INCREMENT BIGINT", "CYCLE_OPTION", "CURRENT_VALUE BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT");
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 20: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 21: {
                this.setMetaTableName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 22: {
                this.setMetaTableName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "DOMAIN_DEFAULT", "DOMAIN_ON_UPDATE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "PARENT_DOMAIN_CATALOG", "PARENT_DOMAIN_SCHEMA", "PARENT_DOMAIN_NAME", "SELECTIVITY INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setMetaTableName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setMetaTableName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SERVER", "CLIENT_ADDR", "CLIENT_INFO", "SESSION_START TIMESTAMP WITH TIME ZONE", "ISOLATION_LEVEL", "STATEMENT", "STATEMENT_START TIMESTAMP WITH TIME ZONE", "CONTAINS_UNCOMMITTED BIT", "STATE", "BLOCKER_ID INT");
                break;
            }
            case 25: {
                this.setMetaTableName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 26: {
                this.setMetaTableName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            case 27: {
                this.setMetaTableName("QUERY_STATISTICS");
                columnArray = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME DOUBLE", "MAX_EXECUTION_TIME DOUBLE", "CUMULATIVE_EXECUTION_TIME DOUBLE", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            case 28: {
                this.setMetaTableName("SYNONYMS");
                columnArray = this.createColumns("SYNONYM_CATALOG", "SYNONYM_SCHEMA", "SYNONYM_NAME", "SYNONYM_FOR", "SYNONYM_FOR_SCHEMA", "TYPE_NAME", "STATUS", "REMARKS", "ID INT");
                string = "SYNONYM_NAME";
                break;
            }
            case 29: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("DOMAIN_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 31: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "POSITION_IN_UNIQUE_CONSTRAINT INT", "INDEX_CATALOG", "INDEX_SCHEMA", "INDEX_NAME");
                string = "TABLE_NAME";
                break;
            }
            case 32: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "UNIQUE_CONSTRAINT_CATALOG", "UNIQUE_CONSTRAINT_SCHEMA", "UNIQUE_CONSTRAINT_NAME", "MATCH_OPTION", "UPDATE_RULE", "DELETE_RULE");
                break;
            }
            case 33: {
                this.setMetaTableName("CHECK_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CHECK_CLAUSE");
                break;
            }
            case 34: {
                this.setMetaTableName("CONSTRAINT_COLUMN_USAGE");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME");
                string = "TABLE_NAME";
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(string)).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private void setMetaTableName(String string) {
        this.setObjectName(this.database.sysIdentifier(string));
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        int n = this.database.getSettings().caseInsensitiveIdentifiers ? 14 : 13;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n2;
            String string2 = stringArray[i];
            int n3 = string2.indexOf(32);
            if (n3 < 0) {
                n2 = n;
                string = string2;
            } else {
                n2 = DataType.getTypeByName((String)string2.substring((int)(n3 + 1)), (Mode)this.database.getMode()).type;
                string = string2.substring(0, n3);
            }
            columnArray[i] = new Column(this.database.sysIdentifier(string), n2);
        }
        return columnArray;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getSettings().databaseToLower) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private ArrayList<Table> getTablesByName(Session session, String string) {
        ArrayList<Table> arrayList = this.database.getTableOrViewByName(string);
        for (Table table : session.getLocalTempTables()) {
            if (!table.getName().equals(string)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Value value3 = this.database.getSettings().caseInsensitiveIdentifiers ? ValueVarcharIgnoreCase.get(string) : ValueVarchar.get(string);
        if (value != null && session.compare(value3, value) < 0) {
            return false;
        }
        return value2 == null || session.compare(value3, value2) <= 0;
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Row> generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> arrayList = Utils.newSmallArrayList();
        String string = this.database.getShortName();
        boolean bl = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    void var13_147;
                    String sequence = table.getName();
                    if (!this.checkIndex(session, sequence, value, value2) || this.hideTable(table, session)) continue;
                    String javaMethodArray = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    String dbException = table.getCreateSQL();
                    if (!bl && dbException != null && dbException.contains("--hide--")) {
                        String string20 = "-";
                    }
                    this.add(session, arrayList, string, table.getSchema().getName(), sequence, table.getTableType().toString(), javaMethodArray, var13_147, MetaTable.replaceNullWithEmpty(table.getComment()), ValueBigint.get(table.getMaxDataModificationId()), ValueInteger.get(table.getId()), null, table.getClass().getName(), ValueBigint.get(table.getRowCountApproximation()));
                }
                break;
            }
            case 1: {
                ArrayList<Table> arrayList2;
                if (value != null && value.equals(value2)) {
                    String string5 = value.getString();
                    if (string5 == null) break;
                    arrayList2 = this.getTablesByName(session, string5);
                } else {
                    arrayList2 = this.getAllTables(session);
                }
                for (Table role : arrayList2) {
                    String table = role.getName();
                    if (!this.checkIndex(session, table, value, value2) || this.hideTable(role, session)) continue;
                    Column[] string21 = role.getColumns();
                    String string2 = this.database.getCompareMode().getName();
                    for (int i = 0; i < string21.length; ++i) {
                        boolean bl2;
                        Column column = string21[i];
                        Domain domain = column.getDomain();
                        DataType dataType = column.getDataType();
                        ValueInteger valueInteger = ValueInteger.get(column.getPrecisionAsInt());
                        ValueInteger valueInteger2 = ValueInteger.get(column.getType().getScale());
                        Sequence sequence = column.getSequence();
                        int n = dataType.type;
                        switch (n) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 24: 
                            case 31: 
                            case 35: 
                            case 37: 
                            case 38: 
                            case 41: {
                                bl2 = true;
                                break;
                            }
                            default: {
                                bl2 = false;
                            }
                        }
                        boolean bl3 = column.getGenerated();
                        boolean bl4 = DataType.isIntervalType(n);
                        String string3 = column.getCreateSQLWithoutName();
                        this.add(session, arrayList, string, role.getSchema().getName(), table, column.getName(), ValueInteger.get(i + 1), bl3 ? null : column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", ValueInteger.get(dataType.sqlType), valueInteger, valueInteger, valueInteger, ValueInteger.get(10), valueInteger2, bl2 ? valueInteger2 : null, bl4 ? string3.substring(9) : null, bl4 ? valueInteger : null, CHARACTER_SET_NAME, string2, domain != null ? string : null, domain != null ? domain.getSchema().getName() : null, domain != null ? domain.getName() : null, bl3 ? "ALWAYS" : "NEVER", bl3 ? column.getDefaultSQL() : null, this.identifier(bl4 ? "INTERVAL" : dataType.name), ValueInteger.get(column.isNullable() ? 1 : 0), ValueBoolean.get(bl3), ValueInteger.get(column.getSelectivity()), sequence == null ? null : sequence.getName(), MetaTable.replaceNullWithEmpty(column.getComment()), null, string3, column.getOnUpdateSQL(), ValueBoolean.get(column.getVisible()));
                    }
                }
                break;
            }
            case 2: {
                ArrayList<Table> arrayList3;
                if (value != null && value.equals(value2)) {
                    String dataType = value.getString();
                    if (dataType == null) break;
                    arrayList3 = this.getTablesByName(session, dataType);
                } else {
                    arrayList3 = this.getAllTables(session);
                }
                for (Table functionAlias : arrayList3) {
                    String table = functionAlias.getName();
                    if (!this.checkIndex(session, table, value, value2) || this.hideTable(functionAlias, session)) continue;
                    ArrayList<Index> indexColumnArray = functionAlias.getIndexes();
                    ArrayList<Constraint> arrayList2 = functionAlias.getConstraints();
                    for (int i = 0; indexColumnArray != null && i < indexColumnArray.size(); ++i) {
                        Object object;
                        Index index = indexColumnArray.get(i);
                        if (index.getCreateSQL() == null) continue;
                        String string4 = null;
                        for (int j = 0; arrayList2 != null && j < arrayList2.size(); ++j) {
                            object = arrayList2.get(j);
                            if (!((Constraint)object).usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (((Constraint)object).getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                string4 = ((DbObjectBase)object).getName();
                                continue;
                            }
                            string4 = ((DbObjectBase)object).getName();
                        }
                        IndexColumn[] indexColumnArray2 = index.getIndexColumns();
                        object = index.getClass().getName();
                        for (int j = 0; j < indexColumnArray2.length; ++j) {
                            IndexColumn indexColumn = indexColumnArray2[j];
                            Column column = indexColumn.column;
                            this.add(session, arrayList, string, functionAlias.getSchema().getName(), table, ValueBoolean.get(!index.getIndexType().isUnique()), index.getName(), ValueSmallint.get((short)(j + 1)), column.getName(), ValueInteger.get(0), ValueBoolean.get(index.getIndexType().isPrimaryKey()), index.getIndexType().getSQL(), ValueBoolean.get(index.getIndexType().getBelongsToConstraint()), ValueSmallint.get((short)3), (indexColumn.sortType & 1) != 0 ? "D" : "A", ValueInteger.get(0), "", MetaTable.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), ValueInteger.get(index.getId()), ValueInteger.get(indexColumn.sortType), string4, object);
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(session, arrayList, TableType.TABLE.toString());
                this.add(session, arrayList, TableType.TABLE_LINK.toString());
                this.add(session, arrayList, TableType.SYSTEM_TABLE.toString());
                this.add(session, arrayList, TableType.VIEW.toString());
                this.add(session, arrayList, TableType.EXTERNAL_TABLE_ENGINE.toString());
                break;
            }
            case 4: {
                for (DataType byArray : DataType.getTypes()) {
                    if (byArray.hidden || byArray.sqlType == 0) continue;
                    this.add(session, arrayList, byArray.name, ValueInteger.get(byArray.sqlType), ValueInteger.get(MathUtils.convertLongToInt(byArray.maxPrecision)), byArray.prefix, byArray.suffix, byArray.params, ValueBoolean.get(byArray.autoIncrement), ValueSmallint.get(MathUtils.convertIntToShort(byArray.minScale)), ValueSmallint.get(MathUtils.convertIntToShort(byArray.maxScale)), byArray.decimal ? ValueInteger.get(10) : null, ValueInteger.get(byArray.sqlTypePos), ValueBoolean.get(byArray.caseSensitive), ValueSmallint.get((short)1), ValueSmallint.get((short)3));
                }
                break;
            }
            case 5: {
                this.add(session, arrayList, string);
                break;
            }
            case 6: {
                MVStore tableView;
                FileStore value3;
                MVTableEngine.Store dbObject;
                Object object2 = this.database.getAllSettings().iterator();
                while (object2.hasNext()) {
                    Setting exception = object2.next();
                    String functionAlias = exception.getStringValue();
                    if (functionAlias == null) {
                        functionAlias = Integer.toString(exception.getIntValue());
                    }
                    this.add(session, arrayList, this.identifier(exception.getName()), functionAlias);
                }
                this.add(session, arrayList, "info.BUILD_ID", "200");
                this.add(session, arrayList, "info.VERSION_MAJOR", "1");
                this.add(session, arrayList, "info.VERSION_MINOR", "4");
                this.add(session, arrayList, "info.VERSION", Constants.FULL_VERSION);
                if (bl) {
                    String[] schemaObject = object2 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    int schema = schemaObject.length;
                    for (int locale = 0; locale < schema; ++locale) {
                        String domain2 = schemaObject[locale];
                        this.add(session, arrayList, "property." + domain2, Utils.getProperty(domain2, ""));
                    }
                }
                this.add(session, arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(session, arrayList, "MODE", this.database.getMode().getName());
                this.add(session, arrayList, "QUERY_TIMEOUT", Integer.toString(session.getQueryTimeout()));
                this.add(session, arrayList, "TIME ZONE", session.currentTimeZone().getId());
                this.add(session, arrayList, "VARIABLE_BINARY", session.isVariableBinary() ? "TRUE" : "FALSE");
                object2 = session.getNonKeywords();
                if (object2 != null) {
                    this.add(session, arrayList, "NON_KEYWORDS", Parser.formatNonKeywords((BitSet)object2));
                }
                this.add(session, arrayList, "RETENTION_TIME", Integer.toString(this.database.getRetentionTime()));
                this.add(session, arrayList, "LOG", Integer.toString(this.database.getLogMode()));
                for (Map.Entry<String, String> entry : this.database.getSettings().getSortedSettings()) {
                    this.add(session, arrayList, entry.getKey(), entry.getValue());
                }
                if (!this.database.isPersistent()) break;
                PageStore right = this.database.getPageStore();
                if (right != null) {
                    this.add(session, arrayList, "info.FILE_WRITE_TOTAL", Long.toString(right.getWriteCountTotal()));
                    this.add(session, arrayList, "info.FILE_WRITE", Long.toString(right.getWriteCount()));
                    this.add(session, arrayList, "info.FILE_READ", Long.toString(right.getReadCount()));
                    this.add(session, arrayList, "info.PAGE_COUNT", Integer.toString(right.getPageCount()));
                    this.add(session, arrayList, "info.PAGE_SIZE", Integer.toString(right.getPageSize()));
                    this.add(session, arrayList, "info.CACHE_MAX_SIZE", Integer.toString(right.getCache().getMaxMemory()));
                    this.add(session, arrayList, "info.CACHE_SIZE", Integer.toString(right.getCache().getMemory()));
                }
                if ((dbObject = this.database.getStore()) == null || (value3 = (tableView = dbObject.getMvStore()).getFileStore()) == null) break;
                this.add(session, arrayList, "info.FILE_WRITE", Long.toString(value3.getWriteCount()));
                this.add(session, arrayList, "info.FILE_WRITE_BYTES", Long.toString(value3.getWriteBytes()));
                this.add(session, arrayList, "info.FILE_READ", Long.toString(value3.getReadCount()));
                this.add(session, arrayList, "info.FILE_READ_BYTES", Long.toString(value3.getReadBytes()));
                this.add(session, arrayList, "info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", 100.0 * tableView.getUpdateFailureRatio()));
                this.add(session, arrayList, "info.FILL_RATE", Integer.toString(tableView.getFillRate()));
                this.add(session, arrayList, "info.CHUNKS_FILL_RATE", Integer.toString(tableView.getChunksFillRate()));
                this.add(session, arrayList, "info.CHUNKS_FILL_RATE_RW", Integer.toString(tableView.getRewritableChunksFillRate()));
                try {
                    this.add(session, arrayList, "info.FILE_SIZE", Long.toString(value3.getFile().size()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.add(session, arrayList, "info.CHUNK_COUNT", Long.toString(tableView.getChunkCount()));
                this.add(session, arrayList, "info.PAGE_COUNT", Long.toString(tableView.getPageCount()));
                this.add(session, arrayList, "info.PAGE_COUNT_LIVE", Long.toString(tableView.getLivePageCount()));
                this.add(session, arrayList, "info.PAGE_SIZE", Integer.toString(tableView.getPageSplitSize()));
                this.add(session, arrayList, "info.CACHE_MAX_SIZE", Integer.toString(tableView.getCacheSize()));
                this.add(session, arrayList, "info.CACHE_SIZE", Integer.toString(tableView.getCacheSizeUsed()));
                this.add(session, arrayList, "info.CACHE_HIT_RATIO", Integer.toString(tableView.getCacheHitRatio()));
                this.add(session, arrayList, "info.TOC_CACHE_HIT_RATIO", Integer.toString(tableView.getTocCacheHitRatio()));
                this.add(session, arrayList, "info.LEAF_RATIO", Integer.toString(tableView.getLeafRatio()));
                break;
            }
            case 7: {
                String string13 = "/org/h2/res/help.csv";
                try {
                    byte[] dbObject = Utils.getResource(string13);
                    InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(dbObject));
                    Csv constraintReferential = new Csv();
                    constraintReferential.setLineCommentCharacter('#');
                    ResultSet table = constraintReferential.read(inputStreamReader, null);
                    int n = 0;
                    while (table.next()) {
                        this.add(session, arrayList, ValueInteger.get(n), table.getString(1).trim(), table.getString(2).trim(), table.getString(3).trim(), table.getString(4).trim());
                        ++n;
                    }
                    break;
                }
                catch (Exception schemaObject) {
                    throw DbException.convert(schemaObject);
                }
            }
            case 8: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(3)) {
                    Sequence string22 = (Sequence)schemaObject;
                    this.add(session, arrayList, string, string22.getSchema().getName(), string22.getName(), "BIGINT", ValueInteger.get(19), ValueInteger.get(10), ValueInteger.get(0), ValueBigint.get(string22.getStartValue()), ValueBigint.get(string22.getMinValue()), ValueBigint.get(string22.getMaxValue()), ValueBigint.get(string22.getIncrement()), string22.getCycle() ? "YES" : "NO", ValueBigint.get(string22.getCurrentValue()), ValueBoolean.get(string22.getBelongsToTable()), MetaTable.replaceNullWithEmpty(string22.getComment()), ValueBigint.get(string22.getCacheSize()), ValueInteger.get(string22.getId()));
                }
                break;
            }
            case 9: {
                for (User right : this.database.getAllUsers()) {
                    if (!bl && session.getUser() != right) continue;
                    this.add(session, arrayList, this.identifier(right.getName()), String.valueOf(right.isAdmin()), MetaTable.replaceNullWithEmpty(right.getComment()), ValueInteger.get(right.getId()));
                }
                break;
            }
            case 10: {
                for (Role right : this.database.getAllRoles()) {
                    if (!bl && !session.getUser().isRoleGranted(right)) continue;
                    this.add(session, arrayList, this.identifier(right.getName()), MetaTable.replaceNullWithEmpty(right.getComment()), ValueInteger.get(right.getId()));
                }
                break;
            }
            case 11: {
                if (!bl) break;
                for (Right right : this.database.getAllRights()) {
                    String indexColumnArray;
                    Role inDoubtTransaction = right.getGrantedRole();
                    DbObject valueExpression = right.getGrantee();
                    String string5 = indexColumnArray = valueExpression.getType() == 2 ? "USER" : "ROLE";
                    if (inDoubtTransaction == null) {
                        String string6;
                        DbObject dbObject = right.getGrantedObject();
                        Schema schema = null;
                        DbObjectBase dbObjectBase = null;
                        if (dbObject != null) {
                            if (dbObject instanceof Schema) {
                                schema = (Schema)dbObject;
                            } else if (dbObject instanceof Table) {
                                dbObjectBase = (Table)dbObject;
                                schema = ((SchemaObjectBase)dbObjectBase).getSchema();
                            }
                        }
                        String string7 = dbObjectBase != null ? dbObjectBase.getName() : "";
                        String string8 = string6 = schema != null ? schema.getName() : "";
                        if (!this.checkIndex(session, string7, value, value2)) continue;
                        this.add(session, arrayList, this.identifier(valueExpression.getName()), indexColumnArray, "", right.getRights(), string6, string7, ValueInteger.get(right.getId()));
                        continue;
                    }
                    this.add(session, arrayList, this.identifier(valueExpression.getName()), indexColumnArray, this.identifier(inDoubtTransaction.getName()), "", "", "", ValueInteger.get(right.getId()));
                }
                break;
            }
            case 12: {
                for (SchemaObject table : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias.JavaMethod[] column;
                    FunctionAlias constraint = (FunctionAlias)table;
                    try {
                        column = constraint.getJavaMethods();
                    }
                    catch (DbException constraintCheck) {
                        column = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod javaMethod : column) {
                        this.add(session, arrayList, string, constraint.getSchema().getName(), constraint.getName(), constraint.getJavaClassName(), constraint.getJavaMethodName(), ValueInteger.get(DataType.convertTypeToSQLType(javaMethod.getDataType())), DataType.getDataType((int)javaMethod.getDataType()).name, ValueInteger.get(javaMethod.getParameterCount()), ValueSmallint.get(javaMethod.getDataType() == 0 ? (short)1 : 2), MetaTable.replaceNullWithEmpty(constraint.getComment()), ValueInteger.get(constraint.getId()), constraint.getSource());
                    }
                }
                for (UserAggregate schemaObject : this.database.getAllAggregates()) {
                    this.add(session, arrayList, string, this.database.getMainSchema().getName(), schemaObject.getName(), schemaObject.getJavaClassName(), "", ValueInteger.get(0), DataType.getDataType((int)0).name, ValueInteger.get(1), ValueSmallint.get((short)2), MetaTable.replaceNullWithEmpty(schemaObject.getComment()), ValueInteger.get(schemaObject.getId()), "");
                }
                break;
            }
            case 20: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias.JavaMethod[] table;
                    FunctionAlias constant = (FunctionAlias)schemaObject;
                    try {
                        table = constant.getJavaMethods();
                    }
                    catch (DbException dbException) {
                        table = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod javaMethod : table) {
                        Object object;
                        if (javaMethod.getDataType() != 0) {
                            object = DataType.getDataType(javaMethod.getDataType());
                            this.add(session, arrayList, string, constant.getSchema().getName(), constant.getName(), constant.getJavaClassName(), constant.getJavaMethodName(), ValueInteger.get(javaMethod.getParameterCount()), ValueInteger.get(0), "P0", ValueInteger.get(DataType.convertTypeToSQLType(javaMethod.getDataType())), object.name, ValueInteger.get(MathUtils.convertLongToInt(object.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(object.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get((short)2), ValueSmallint.get((short)5), "", null);
                        }
                        object = javaMethod.getColumnClasses();
                        for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                            if (javaMethod.hasConnectionParam() && i == 0) continue;
                            Class<?> clazz = object[i];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            this.add(session, arrayList, string, constant.getSchema().getName(), constant.getName(), constant.getJavaClassName(), constant.getJavaMethodName(), ValueInteger.get(javaMethod.getParameterCount()), ValueInteger.get(i + (javaMethod.hasConnectionParam() ? 0 : 1)), "P" + (i + 1), ValueInteger.get(DataType.convertTypeToSQLType(dataType.type)), dataType.name, ValueInteger.get(MathUtils.convertLongToInt(dataType.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(dataType.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get(clazz.isPrimitive() ? (short)0 : 1), ValueSmallint.get((short)1), "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string19 = this.database.getCompareMode().getName();
                for (Schema domain : this.database.getAllSchemas()) {
                    this.add(session, arrayList, string, domain.getName(), this.identifier(domain.getOwner().getName()), CHARACTER_SET_NAME, string19, ValueBoolean.get(domain.getId() == 0), MetaTable.replaceNullWithEmpty(domain.getComment()), ValueInteger.get(domain.getId()));
                }
                break;
            }
            case 14: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String string9;
                    Table session2;
                    DbObject triggerObject = schemaObject.getGrantedObject();
                    if (!(triggerObject instanceof Table) || this.hideTable(session2 = (Table)triggerObject, session) || !this.checkIndex(session, string9 = session2.getName(), value, value2)) continue;
                    this.addPrivileges(session, arrayList, schemaObject.getGrantee(), string, session2, null, schemaObject.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right right : this.database.getAllRights()) {
                    String string10;
                    Table session3;
                    DbObject dbObject = right.getGrantedObject();
                    if (!(dbObject instanceof Table) || this.hideTable(session3 = (Table)dbObject, session) || !this.checkIndex(session, string10 = session3.getName(), value, value2)) continue;
                    DbObject dbObject2 = right.getGrantee();
                    int n = right.getRightMask();
                    for (Column column : session3.getColumns()) {
                        this.addPrivileges(session, arrayList, dbObject2, string, session3, column.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale string25 : Collator.getAvailableLocales()) {
                    this.add(session, arrayList, CompareMode.getName(string25), string25.toString());
                }
                break;
            }
            case 17: {
                for (Table table : this.getAllTables(session)) {
                    String i;
                    if (table.getTableType() != TableType.VIEW || !this.checkIndex(session, i = table.getName(), value, value2)) continue;
                    TableView n = (TableView)table;
                    this.add(session, arrayList, string, table.getSchema().getName(), i, table.getCreateSQL(), "NONE", "NO", n.isInvalid() ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(n.getComment()), ValueInteger.get(n.getId()));
                }
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList6 = this.database.getInDoubtTransactions();
                if (arrayList6 == null || !bl) break;
                for (InDoubtTransaction timeZoneProvider : arrayList6) {
                    this.add(session, arrayList, timeZoneProvider.getTransactionName(), timeZoneProvider.getStateDescription());
                }
                break;
            }
            case 19: {
                for (SchemaObject stringBuilder : this.database.getAllSchemaObjects(5)) {
                    Constraint queryEntry = (Constraint)stringBuilder;
                    if (queryEntry.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    ConstraintReferential type = (ConstraintReferential)queryEntry;
                    IndexColumn[] indexColumnArray = type.getColumns();
                    IndexColumn[] indexColumnArray3 = type.getRefColumns();
                    Table table = type.getTable();
                    Table table2 = type.getRefTable();
                    String string11 = table2.getName();
                    if (!this.checkIndex(session, string11, value, value2)) continue;
                    ValueSmallint valueSmallint = ValueSmallint.get(MetaTable.getRefAction(type.getUpdateAction()));
                    ValueSmallint valueSmallint2 = ValueSmallint.get(MetaTable.getRefAction(type.getDeleteAction()));
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(session, arrayList, string, table2.getSchema().getName(), table2.getName(), indexColumnArray3[i].column.getName(), string, table.getSchema().getName(), table.getName(), indexColumnArray[i].column.getName(), ValueSmallint.get((short)(i + 1)), valueSmallint, valueSmallint2, type.getName(), type.getReferencedConstraint().getName(), ValueSmallint.get((short)7));
                    }
                }
                break;
            }
            case 21: {
                for (SchemaObject string24 : this.database.getAllSchemaObjects(11)) {
                    Constant constraint = (Constant)string24;
                    ValueExpression domain = constraint.getValue();
                    this.add(session, arrayList, string, constraint.getSchema().getName(), constraint.getName(), ValueInteger.get(DataType.convertTypeToSQLType(domain.getType().getValueType())), MetaTable.replaceNullWithEmpty(constraint.getComment()), domain.getSQL(0), ValueInteger.get(constraint.getId()));
                }
                break;
            }
            case 22: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(12)) {
                    Domain constraintDomain = (Domain)schemaObject;
                    Column type = constraintDomain.getColumn();
                    Domain domain = type.getDomain();
                    this.add(session, arrayList, string, constraintDomain.getSchema().getName(), constraintDomain.getName(), type.getDefaultSQL(), type.getOnUpdateSQL(), ValueInteger.get(type.getDataType().sqlType), ValueInteger.get(type.getPrecisionAsInt()), ValueInteger.get(type.getType().getScale()), type.getDataType().name, domain != null ? string : null, domain != null ? domain.getSchema().getName() : null, domain != null ? domain.getName() : null, ValueInteger.get(type.getSelectivity()), MetaTable.replaceNullWithEmpty(constraintDomain.getComment()), constraintDomain.getCreateSQL(), ValueInteger.get(constraintDomain.getId()));
                }
                break;
            }
            case 23: {
                for (SchemaObject tableSynonym : this.database.getAllSchemaObjects(4)) {
                    TriggerObject constraint = (TriggerObject)tableSynonym;
                    Table table = constraint.getTable();
                    this.add(session, arrayList, string, constraint.getSchema().getName(), constraint.getName(), constraint.getTypeNameList(new StringBuilder()).toString(), string, table.getSchema().getName(), table.getName(), ValueBoolean.get(constraint.isBefore()), constraint.getTriggerClassName(), ValueInteger.get(constraint.getQueueSize()), ValueBoolean.get(constraint.isNoWait()), MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                }
                break;
            }
            case 24: {
                for (Session type : this.database.getSessions(false)) {
                    if (!bl && type != session) continue;
                    NetworkConnectionInfo networkConnectionInfo = type.getNetworkConnectionInfo();
                    Command command = type.getCurrentCommand();
                    int n = type.getBlockingSessionId();
                    this.add(session, arrayList, ValueInteger.get(type.getId()), type.getUser().getName(), networkConnectionInfo == null ? null : networkConnectionInfo.getServer(), networkConnectionInfo == null ? null : networkConnectionInfo.getClient(), networkConnectionInfo == null ? null : networkConnectionInfo.getClientInfo(), type.getSessionStart(), session.getIsolationLevel().getSQL(), command == null ? null : command.toString(), command == null ? null : type.getCurrentCommandStart(), ValueBoolean.get(type.containsUncommitted()), String.valueOf((Object)type.getState()), n == 0 ? null : ValueInteger.get(n));
                }
                break;
            }
            case 25: {
                for (Session object : this.database.getSessions(false)) {
                    if (!bl && object != session) continue;
                    for (Table table : object.getLocks()) {
                        this.add(session, arrayList, table.getSchema().getName(), table.getName(), ValueInteger.get(object.getId()), table.isLockedExclusivelyBy(object) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 26: {
                TimeZoneProvider timeZoneProvider;
                String schemaObject;
                for (String string12 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string12);
                    StringBuilder stringBuilder = new StringBuilder().append("SET @").append(string12).append(' ');
                    value3.getSQL(stringBuilder, 0);
                    this.add(session, arrayList, "@" + string12, stringBuilder.toString());
                }
                for (Table schemaObject2 : session.getLocalTempTables()) {
                    this.add(session, arrayList, "TABLE " + schemaObject2.getName(), schemaObject2.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StringBuilder schemaObject3 = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    int n = stringArray.length;
                    for (int constraint = 0; constraint < n; ++constraint) {
                        if (constraint > 0) {
                            schemaObject3.append(", ");
                        }
                        StringUtils.quoteIdentifier(schemaObject3, (String)stringArray[constraint]);
                    }
                    this.add(session, arrayList, "SCHEMA_SEARCH_PATH", schemaObject3.toString());
                }
                if ((schemaObject = session.getCurrentSchemaName()) != null) {
                    this.add(session, arrayList, "SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), schemaObject).toString());
                }
                if ((timeZoneProvider = session.currentTimeZone()).equals(DateTimeUtils.getTimeZone())) break;
                this.add(session, arrayList, "TIME ZONE", StringUtils.quoteStringSQL(new StringBuilder("SET TIME ZONE "), timeZoneProvider.getId()).toString());
                break;
            }
            case 27: {
                QueryStatisticsData queryStatisticsData = this.database.getQueryStatisticsData();
                if (queryStatisticsData == null) break;
                for (QueryStatisticsData.QueryEntry queryEntry : queryStatisticsData.getQueries()) {
                    this.add(session, arrayList, queryEntry.sqlStatement, ValueInteger.get(queryEntry.count), ValueDouble.get((double)queryEntry.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)queryEntry.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)queryEntry.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(queryEntry.executionTimeMeanNanos / 1000000.0), ValueDouble.get(queryEntry.getExecutionTimeStandardDeviation() / 1000000.0), ValueInteger.get(queryEntry.rowCountMin), ValueInteger.get(queryEntry.rowCountMax), ValueBigint.get(queryEntry.rowCountCumulative), ValueDouble.get(queryEntry.rowCountMean), ValueDouble.get(queryEntry.getRowCountStandardDeviation()));
                }
                break;
            }
            case 28: {
                for (TableSynonym tableSynonym : this.database.getAllSynonyms()) {
                    this.add(session, arrayList, string, tableSynonym.getSchema().getName(), tableSynonym.getName(), tableSynonym.getSynonymForName(), tableSynonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", MetaTable.replaceNullWithEmpty(tableSynonym.getComment()), ValueInteger.get(tableSynonym.getId()));
                }
                break;
            }
            case 29: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    String string13;
                    Table table;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type type = constraint.getConstraintType();
                    if (type == Constraint.Type.DOMAIN || this.hideTable(table = constraint.getTable(), session) || !this.checkIndex(session, string13 = table.getName(), value, value2)) continue;
                    this.add(session, arrayList, string, constraint.getSchema().getName(), constraint.getName(), type.getSqlName(), string, table.getSchema().getName(), string13, "NO", "NO", MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                }
                break;
            }
            case 30: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    if (((Constraint)schemaObject).getConstraintType() != Constraint.Type.DOMAIN) continue;
                    ConstraintDomain constraintDomain = (ConstraintDomain)schemaObject;
                    Domain domain = constraintDomain.getDomain();
                    this.add(session, arrayList, string, constraintDomain.getSchema().getName(), constraintDomain.getName(), string, domain.getSchema().getName(), domain.getName(), "NO", "NO", MetaTable.replaceNullWithEmpty(constraintDomain.getComment()), constraintDomain.getCreateSQL(), ValueInteger.get(constraintDomain.getId()));
                }
                break;
            }
            case 31: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    String string14;
                    Table table;
                    void var13_172;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type type = constraint.getConstraintType();
                    Object var13_173 = null;
                    if (type == Constraint.Type.UNIQUE || type == Constraint.Type.PRIMARY_KEY) {
                        IndexColumn[] indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (type == Constraint.Type.REFERENTIAL) {
                        IndexColumn[] indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    if (var13_172 == null || this.hideTable(table = constraint.getTable(), session) || !this.checkIndex(session, string14 = table.getName(), value, value2)) continue;
                    ConstraintUnique constraintUnique = type == Constraint.Type.REFERENTIAL ? ((ConstraintReferential)constraint).getReferencedConstraint() : null;
                    Index index = constraint.getIndex();
                    for (int i = 0; i < ((void)var13_172).length; ++i) {
                        void var19_236 = var13_172[i];
                        ValueInteger valueInteger = ValueInteger.get(i + 1);
                        ValueInteger valueInteger3 = null;
                        if (constraintUnique != null) {
                            Column column = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                            IndexColumn[] indexColumnArray = constraintUnique.getColumns();
                            for (int j = 0; j < indexColumnArray.length; ++j) {
                                if (!indexColumnArray[j].column.equals(column)) continue;
                                valueInteger3 = ValueInteger.get(j + 1);
                                break;
                            }
                        }
                        this.add(session, arrayList, string, constraint.getSchema().getName(), constraint.getName(), string, table.getSchema().getName(), string14, var19_236.columnName, valueInteger, valueInteger3, index != null ? string : null, index != null ? index.getSchema().getName() : null, index != null ? index.getName() : null);
                    }
                }
                break;
            }
            case 32: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    ConstraintReferential constraintReferential;
                    Table table;
                    if (((Constraint)schemaObject).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(table = (constraintReferential = (ConstraintReferential)schemaObject).getTable(), session)) continue;
                    ConstraintUnique constraintUnique = constraintReferential.getReferencedConstraint();
                    this.add(session, arrayList, string, constraintReferential.getSchema().getName(), constraintReferential.getName(), string, constraintUnique.getSchema().getName(), constraintUnique.getName(), "NONE", constraintReferential.getUpdateAction().getSqlName(), constraintReferential.getDeleteAction().getSqlName());
                }
                break;
            }
            case 33: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    ConstraintCheck constraintCheck;
                    Table table;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type type = constraint.getConstraintType();
                    if (type == Constraint.Type.CHECK ? this.hideTable(table = (constraintCheck = (ConstraintCheck)schemaObject).getTable(), session) : type != Constraint.Type.DOMAIN) continue;
                    this.add(session, arrayList, string, schemaObject.getSchema().getName(), schemaObject.getName(), constraint.getExpression().getUnenclosedSQL(new StringBuilder(), 0).toString());
                }
                break;
            }
            case 34: {
                block102: for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    switch (constraint.getConstraintType()) {
                        case CHECK: 
                        case DOMAIN: {
                            Object object = new HashSet();
                            constraint.getExpression().isEverything(ExpressionVisitor.getColumnsVisitor((HashSet<Column>)object, null));
                            Iterator iterator = ((HashSet)object).iterator();
                            while (iterator.hasNext()) {
                                Column column = (Column)iterator.next();
                                Table table = column.getTable();
                                if (!this.checkIndex(session, table.getName(), value, value2) || this.hideTable(table, session)) continue;
                                this.addConstraintColumnUsage(session, arrayList, string, constraint, column);
                            }
                            continue block102;
                        }
                        case REFERENTIAL: {
                            Object object = constraint.getRefTable();
                            if (this.checkIndex(session, ((DbObjectBase)object).getName(), value, value2) && !this.hideTable((Table)object, session)) {
                                for (Column column : constraint.getReferencedColumns((Table)object)) {
                                    this.addConstraintColumnUsage(session, arrayList, string, constraint, column);
                                }
                            }
                        }
                        case PRIMARY_KEY: 
                        case UNIQUE: {
                            Object object = constraint.getTable();
                            if (!this.checkIndex(session, ((DbObjectBase)object).getName(), value, value2) || this.hideTable((Table)object, session)) break;
                            for (Column column : constraint.getReferencedColumns((Table)object)) {
                                this.addConstraintColumnUsage(session, arrayList, string, constraint, column);
                            }
                            break;
                        }
                    }
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private static short getRefAction(ConstraintActionType constraintActionType) {
        switch (constraintActionType) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + (Object)((Object)constraintActionType));
    }

    private void addConstraintColumnUsage(Session session, ArrayList<Row> arrayList, String string, Constraint constraint, Column column) {
        Table table = column.getTable();
        this.add(session, arrayList, string, table.getSchema().getName(), table.getName(), column.getName(), string, constraint.getSchema().getName(), constraint.getName());
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(Session session, ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(session, arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(session, arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(session, arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(session, arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(Session session, ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(session, arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string3, string4);
        } else {
            this.add(session, arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string2, string3, string4);
        }
    }

    private void add(Session session, ArrayList<Row> arrayList, Object ... objectArray) {
        Value[] valueArray = new Value[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ValueNull valueNull = object == null ? ValueNull.INSTANCE : (object instanceof String ? ValueVarchar.get((String)object) : (Value)object);
            valueArray[i] = this.columns[i].convert(session, valueNull);
        }
        arrayList.add(Row.get(valueArray, 1, arrayList.size()));
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = new ArrayList<Index>(2);
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 8: 
            case 18: 
            case 24: 
            case 25: 
            case 26: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 35;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

