/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.DateTimeFunctions;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestampTimeZone;

public class IntervalOperation
extends Expression {
    private static final int INTERVAL_YEAR_DIGITS = 20;
    private static final int INTERVAL_DAY_DIGITS = 32;
    private static final TypeInfo INTERVAL_DIVIDE_INTERVAL_YEAR_TYPE = TypeInfo.getTypeInfo(6, 60L, 40, null);
    private static final TypeInfo INTERVAL_DIVIDE_INTERVAL_DAY_TYPE = TypeInfo.getTypeInfo(6, 96L, 64, null);
    private final IntervalOpType opType;
    private Expression left;
    private Expression right;
    private TypeInfo forcedType;
    private TypeInfo type;

    private static BigInteger nanosFromValue(Session session, Value value) {
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value, session);
        return BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(lArray[0])).multiply(IntervalUtils.NANOS_PER_DAY_BI).add(BigInteger.valueOf(lArray[1]));
    }

    public IntervalOperation(IntervalOpType intervalOpType, Expression expression, Expression expression2, TypeInfo typeInfo) {
        this(intervalOpType, expression, expression2);
        this.forcedType = typeInfo;
    }

    public IntervalOperation(IntervalOpType intervalOpType, Expression expression, Expression expression2) {
        this.opType = intervalOpType;
        this.left = expression;
        this.right = expression2;
        int n = expression.getType().getValueType();
        int n2 = expression2.getType().getValueType();
        switch (intervalOpType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                this.type = TypeInfo.getTypeInfo(Value.getHigherOrder(n, n2));
                break;
            }
            case INTERVAL_DIVIDE_INTERVAL: {
                this.type = DataType.isYearMonthIntervalType(n) ? INTERVAL_DIVIDE_INTERVAL_YEAR_TYPE : INTERVAL_DIVIDE_INTERVAL_DAY_TYPE;
                break;
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                this.type = expression.getType();
                break;
            }
            case DATETIME_MINUS_DATETIME: {
                this.type = this.forcedType != null ? this.forcedType : (!(n != 9 && n != 41 || n2 != 9 && n2 != 41) ? TypeInfo.TYPE_INTERVAL_HOUR_TO_SECOND : (n == 10 && n2 == 10 ? TypeInfo.TYPE_INTERVAL_DAY : TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND));
            }
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, n).append(' ').append(this.getOperationToken()).append(' ');
        this.right.getSQL(stringBuilder, n).append(')');
        if (this.forcedType != null) {
            IntervalOperation.getForcedTypeSQL(stringBuilder.append(' '), this.forcedType);
        }
        return stringBuilder;
    }

    static StringBuilder getForcedTypeSQL(StringBuilder stringBuilder, TypeInfo typeInfo) {
        int n = (int)typeInfo.getPrecision();
        int n2 = typeInfo.getScale();
        return IntervalQualifier.valueOf(typeInfo.getValueType() - 26).getTypeName(stringBuilder, n == 2 ? -1 : n, n2 == 6 ? -1 : n2, true);
    }

    private char getOperationToken() {
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case DATETIME_PLUS_INTERVAL: {
                return '+';
            }
            case INTERVAL_MINUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case DATETIME_MINUS_DATETIME: {
                return '-';
            }
            case INTERVAL_MULTIPLY_NUMERIC: {
                return '*';
            }
            case INTERVAL_DIVIDE_INTERVAL: 
            case INTERVAL_DIVIDE_NUMERIC: {
                return '/';
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        Value value2 = this.right.getValue(session);
        if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int n = value.getValueType();
        int n2 = value2.getValueType();
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                BigInteger bigInteger = IntervalUtils.intervalToAbsolute((ValueInterval)value);
                BigInteger bigInteger2 = IntervalUtils.intervalToAbsolute((ValueInterval)value2);
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(Value.getHigherOrder(n, n2) - 26), this.opType == IntervalOpType.INTERVAL_PLUS_INTERVAL ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2));
            }
            case INTERVAL_DIVIDE_INTERVAL: {
                return ValueNumeric.get(IntervalUtils.intervalToAbsolute((ValueInterval)value)).divide(ValueNumeric.get(IntervalUtils.intervalToAbsolute((ValueInterval)value2)), DataType.isYearMonthIntervalType(value.getValueType()) ? 20L : 32L);
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: {
                return this.getDateTimeWithInterval(session, value, value2, n, n2);
            }
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                BigDecimal bigDecimal = new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)value));
                BigDecimal bigDecimal2 = value2.getBigDecimal();
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), (this.opType == IntervalOpType.INTERVAL_MULTIPLY_NUMERIC ? bigDecimal.multiply(bigDecimal2) : bigDecimal.divide(bigDecimal2)).toBigInteger());
            }
            case DATETIME_MINUS_DATETIME: {
                Value value3;
                if (!(n != 9 && n != 41 || n2 != 9 && n2 != 41)) {
                    boolean bl;
                    long l;
                    if (n == 9 && n2 == 9) {
                        l = ((ValueTime)value).getNanos() - ((ValueTime)value2).getNanos();
                    } else {
                        ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value.convertTo(TypeInfo.TYPE_TIME_TZ, (CastDataProvider)session);
                        ValueTimeTimeZone valueTimeTimeZone2 = (ValueTimeTimeZone)value2.convertTo(TypeInfo.TYPE_TIME_TZ, (CastDataProvider)session);
                        l = valueTimeTimeZone.getNanos() - valueTimeTimeZone2.getNanos() + (long)(valueTimeTimeZone2.getTimeZoneOffsetSeconds() - valueTimeTimeZone.getTimeZoneOffsetSeconds()) * 1000000000L;
                    }
                    boolean bl2 = bl = l < 0L;
                    if (bl) {
                        l = -l;
                    }
                    value3 = ValueInterval.from(IntervalQualifier.HOUR_TO_SECOND, bl, l / 3600000000000L, l % 3600000000000L);
                } else if (n == 10 && n2 == 10) {
                    boolean bl;
                    long l = DateTimeUtils.absoluteDayFromDateValue(((ValueDate)value).getDateValue()) - DateTimeUtils.absoluteDayFromDateValue(((ValueDate)value2).getDateValue());
                    boolean bl3 = bl = l < 0L;
                    if (bl) {
                        l = -l;
                    }
                    value3 = ValueInterval.from(IntervalQualifier.DAY, bl, l, 0L);
                } else {
                    BigInteger bigInteger = IntervalOperation.nanosFromValue(session, value).subtract(IntervalOperation.nanosFromValue(session, value2));
                    if (n == 24 || n2 == 24) {
                        value = value.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, (CastDataProvider)session);
                        value2 = value2.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, (CastDataProvider)session);
                        bigInteger = bigInteger.add(BigInteger.valueOf((long)(((ValueTimestampTimeZone)value2).getTimeZoneOffsetSeconds() - ((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds()) * 1000000000L));
                    }
                    value3 = IntervalUtils.intervalFromAbsolute(IntervalQualifier.DAY_TO_SECOND, bigInteger);
                }
                if (this.forcedType != null) {
                    value3 = value3.castTo(this.forcedType, session);
                }
                return value3;
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    private Value getDateTimeWithInterval(Session session, Value value, Value value2, int n, int n2) {
        switch (n) {
            case 9: {
                if (DataType.isYearMonthIntervalType(n2)) {
                    throw DbException.throwInternalError("type=" + n2);
                }
                return ValueTime.fromNanos(this.getTimeWithInterval(value2, ((ValueTime)value).getNanos()));
            }
            case 41: {
                if (DataType.isYearMonthIntervalType(n2)) {
                    throw DbException.throwInternalError("type=" + n2);
                }
                ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
                return ValueTimeTimeZone.fromNanos(this.getTimeWithInterval(value2, valueTimeTimeZone.getNanos()), valueTimeTimeZone.getTimeZoneOffsetSeconds());
            }
            case 10: 
            case 11: 
            case 24: {
                if (DataType.isYearMonthIntervalType(n2)) {
                    long l = IntervalUtils.intervalToAbsolute((ValueInterval)value2).longValue();
                    if (this.opType == IntervalOpType.DATETIME_MINUS_INTERVAL) {
                        l = -l;
                    }
                    return DateTimeFunctions.dateadd(session, "MONTH", l, value);
                }
                BigInteger bigInteger = IntervalUtils.intervalToAbsolute((ValueInterval)value2);
                if (n == 10) {
                    BigInteger bigInteger2 = BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(((ValueDate)value).getDateValue()));
                    bigInteger = bigInteger.divide(IntervalUtils.NANOS_PER_DAY_BI);
                    BigInteger bigInteger3 = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? bigInteger2.add(bigInteger) : bigInteger2.subtract(bigInteger);
                    return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay(bigInteger3.longValue()));
                }
                long[] lArray = DateTimeUtils.dateAndTimeFromValue(value, session);
                long l = DateTimeUtils.absoluteDayFromDateValue(lArray[0]);
                long l2 = lArray[1];
                BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                if (this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL) {
                    l += bigIntegerArray[0].longValue();
                    l2 += bigIntegerArray[1].longValue();
                } else {
                    l -= bigIntegerArray[0].longValue();
                    l2 -= bigIntegerArray[1].longValue();
                }
                if (l2 >= 86400000000000L) {
                    l2 -= 86400000000000L;
                    ++l;
                } else if (l2 < 0L) {
                    l2 += 86400000000000L;
                    --l;
                }
                return DateTimeUtils.dateTimeToValue(value, DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    private long getTimeWithInterval(Value value, long l) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(l);
        BigInteger bigInteger3 = IntervalUtils.intervalToAbsolute((ValueInterval)value);
        BigInteger bigInteger4 = bigInteger = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? bigInteger2.add(bigInteger3) : bigInteger2.subtract(bigInteger3);
        if (bigInteger.signum() < 0 || bigInteger.compareTo(IntervalUtils.NANOS_PER_DAY_BI) >= 0) {
            throw DbException.get(22003, bigInteger.toString());
        }
        l = bigInteger.longValue();
        return l;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1 + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static enum IntervalOpType {
        INTERVAL_PLUS_INTERVAL,
        INTERVAL_MINUS_INTERVAL,
        INTERVAL_DIVIDE_INTERVAL,
        DATETIME_PLUS_INTERVAL,
        DATETIME_MINUS_INTERVAL,
        INTERVAL_MULTIPLY_NUMERIC,
        INTERVAL_DIVIDE_NUMERIC,
        DATETIME_MINUS_DATETIME;

    }
}

