/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueRow;

public class ExpressionList
extends Expression {
    private final Expression[] list;
    private final boolean isArray;

    public ExpressionList(Expression[] expressionArray, boolean bl) {
        this.list = expressionArray;
        this.isArray = bl;
    }

    @Override
    public Value getValue(Session session) {
        Value[] valueArray = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            valueArray[i] = this.list[i].getValue(session);
        }
        return this.isArray ? ValueArray.get(valueArray) : ValueRow.get(valueArray);
    }

    @Override
    public TypeInfo getType() {
        return this.isArray ? TypeInfo.TYPE_ARRAY : TypeInfo.TYPE_ROW;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.list) {
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean bl = true;
        for (int i = 0; i < this.list.length; ++i) {
            Expression expression = this.list[i].optimize(session);
            if (!expression.isConstant()) {
                bl = false;
            }
            this.list[i] = expression;
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.list) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this.isArray ? "ARRAY [" : "ROW (");
        ExpressionList.writeExpressions(stringBuilder, this.list, n);
        return stringBuilder.append(this.isArray ? (char)']' : ')');
    }

    @Override
    public void updateAggregate(Session session, int n) {
        for (Expression expression : this.list) {
            expression.updateAggregate(session, n);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.list) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = 1;
        for (Expression expression : this.list) {
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        Expression[] expressionArray = new ExpressionColumn[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Expression expression = this.list[i];
            Column column = new Column("C" + (i + 1), expression.getType());
            expressionArray[i] = new ExpressionColumn(session.getDatabase(), column);
        }
        return expressionArray;
    }

    @Override
    public boolean isConstant() {
        for (Expression expression : this.list) {
            if (expression.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSubexpressionCount() {
        return this.list.length;
    }

    @Override
    public Expression getSubexpression(int n) {
        return this.list[n];
    }
}

