/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.DateTimeUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class CompatibilityDatePlusTimeOperation
extends Expression {
    private Expression left;
    private Expression right;
    private TypeInfo type;

    public CompatibilityDatePlusTimeOperation(Expression expression, Expression expression2) {
        int n;
        this.left = expression;
        this.right = expression2;
        TypeInfo typeInfo = expression.getType();
        TypeInfo typeInfo2 = expression2.getType();
        switch (typeInfo.getValueType()) {
            case 24: {
                if (typeInfo2.getValueType() == 41) {
                    throw DbException.getUnsupportedException("TIMESTAMP WITH TIME ZONE + TIME WITH TIME ZONE");
                }
            }
            case 9: {
                n = typeInfo.getValueType();
                break;
            }
            case 41: {
                if (typeInfo2.getValueType() == 41) {
                    throw DbException.getUnsupportedException("TIME WITH TIME ZONE + TIME WITH TIME ZONE");
                }
                n = typeInfo.getValueType();
                break;
            }
            case 10: 
            case 11: {
                n = typeInfo2.getValueType() == 41 ? 24 : 11;
                break;
            }
            default: {
                throw DbException.getUnsupportedException(DataType.getDataType((int)typeInfo.getValueType()).name + " + " + DataType.getDataType((int)typeInfo2.getValueType()).name);
            }
        }
        this.type = TypeInfo.getTypeInfo(n, 0L, Math.max(typeInfo.getScale(), typeInfo2.getScale()), null);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        this.left.getSQL(stringBuilder.append('('), n).append(" + ");
        return this.right.getSQL(stringBuilder, n).append(')');
    }

    @Override
    public Value getValue(Session session) {
        Object object;
        Value value = this.left.getValue(session);
        Value value2 = this.right.getValue(session);
        if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        boolean bl = value2.getValueType() == 41;
        switch (value.getValueType()) {
            case 10: {
                long l = ((ValueDate)value).getDateValue();
                if (bl) {
                    ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value2;
                    return ValueTimestampTimeZone.fromDateValueAndNanos(l, valueTimeTimeZone.getNanos(), valueTimeTimeZone.getTimeZoneOffsetSeconds());
                }
                return ValueTimestamp.fromDateValueAndNanos(l, ((ValueTime)value2).getNanos());
            }
            case 11: {
                if (!bl) break;
                object = (ValueTimestamp)value;
                value = ValueTimestampTimeZone.fromDateValueAndNanos(((ValueTimestamp)object).getDateValue(), ((ValueTimestamp)object).getTimeNanos(), ((ValueTimeTimeZone)value2).getTimeZoneOffsetSeconds());
            }
        }
        object = DateTimeUtils.dateAndTimeFromValue(value, session);
        Object object2 = object[0];
        reference var8_9 = object[1] + (value2 instanceof ValueTime ? ((ValueTime)value2).getNanos() : ((ValueTimeTimeZone)value2).getNanos());
        if (var8_9 >= 86400000000000L) {
            var8_9 -= 86400000000000L;
            object2 = DateTimeUtils.incrementDateValue((long)object2);
        }
        return DateTimeUtils.dateTimeToValue(value, (long)object2, (long)var8_9);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1 + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

