/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterDomainAddConstraint;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.Utils;
import org.h2.value.DataType;

public class CreateDomain
extends SchemaCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;
    private ArrayList<AlterDomainAddConstraint> constraintCommands;

    public CreateDomain(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Schema schema = this.getSchema();
        if (schema.findDomain(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90119, this.typeName);
        }
        DataType dataType = DataType.getTypeByName(this.typeName, this.session.getDatabase().getMode());
        if (dataType != null) {
            if (!dataType.hidden) {
                throw DbException.get(90119, this.typeName);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                StringBuilder stringBuilder = new StringBuilder(this.typeName).append(" (");
                table.getSQL(stringBuilder, 3).append(')');
                throw DbException.get(90119, stringBuilder.toString());
            }
        }
        int n = this.getObjectId();
        Domain domain = new Domain(schema, n, this.typeName);
        domain.setColumn(this.column);
        schema.getDatabase().addSchemaObject(this.session, domain);
        if (this.constraintCommands != null) {
            for (AlterDomainAddConstraint alterDomainAddConstraint : this.constraintCommands) {
                alterDomainAddConstraint.update();
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return 33;
    }

    public void addConstraintCommand(AlterDomainAddConstraint alterDomainAddConstraint) {
        if (this.constraintCommands == null) {
            this.constraintCommands = Utils.newSmallArrayList();
        }
        this.constraintCommands.add(alterDomainAddConstraint);
    }
}

