/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.progress;

import java.util.concurrent.TimeUnit;
import org.javanetworkanalyzer.progress.ProgressMonitor;

public class ConsoleProgressBar {
    private final ProgressMonitor pm;
    private final int width;
    private final int frequency;

    public ConsoleProgressBar(ProgressMonitor pm, int width, int frequency) {
        this.pm = pm;
        this.width = width;
        this.frequency = frequency;
    }

    public String progressBar(long count, long startTime) {
        StringBuilder progressBar = new StringBuilder();
        int percentageComplete = this.pm.getPercentageComplete();
        if (count == 0L) {
            progressBar.append(this.bar(0L, this.width)).append(this.percentage(0L));
            progressBar.append("\r");
        } else {
            long elapsed = System.currentTimeMillis() - startTime;
            long mod = elapsed > 0L ? 1000L * count * (long)this.frequency / elapsed : 1L;
            long l = mod = mod == 0L ? 1L : mod;
            if (count != this.pm.getEnd()) {
                if (count % mod == 0L) {
                    progressBar.append(this.bar(percentageComplete, this.width));
                    progressBar.append(this.percentage(percentageComplete));
                    progressBar.append(this.time(count, elapsed));
                    progressBar.append("\r");
                }
            } else {
                progressBar.append(this.bar(100L, this.width)).append(this.percentage(100L));
                progressBar.append(this.time(count, elapsed));
                progressBar.append("\n");
            }
        }
        return progressBar.toString();
    }

    private String bar(long percentageComplete, int width) {
        int i;
        StringBuilder bar = new StringBuilder();
        int numberOfEqualSigns = (int)(percentageComplete * (long)width / 100L);
        int numberOfBlankSpaces = width - numberOfEqualSigns;
        bar.append("  [");
        for (i = 0; i < numberOfEqualSigns; ++i) {
            bar.append("=");
        }
        if (percentageComplete == 0L) {
            bar.append(" ");
        } else if (percentageComplete < 100L) {
            bar.append(">");
        } else {
            bar.append("=");
        }
        for (i = 0; i < numberOfBlankSpaces; ++i) {
            bar.append(" ");
        }
        bar.append("] ");
        return bar.toString();
    }

    private String percentage(long percentageComplete) {
        StringBuilder percentage = new StringBuilder();
        if (percentageComplete < 10L) {
            percentage.append("  ");
        } else if (percentageComplete >= 10L && percentageComplete < 100L) {
            percentage.append(" ");
        }
        percentage.append(percentageComplete).append("% ");
        return percentage.toString();
    }

    private String time(long count, long elapsed) {
        StringBuilder time = new StringBuilder();
        long[] elapsedHMS = this.millisecondsToHoursMinutesSeconds(elapsed);
        time.append(this.formatHMSString(elapsedHMS[0], elapsedHMS[1], elapsedHMS[2]));
        long remaining = elapsed / count * (this.pm.getEnd() - count);
        long[] remainingHMS = this.millisecondsToHoursMinutesSeconds(remaining);
        time.append(" (").append(this.formatHMSString(remainingHMS[0], remainingHMS[1], remainingHMS[2])).append(")");
        return time.toString();
    }

    private long[] millisecondsToHoursMinutesSeconds(long time) {
        long hours = TimeUnit.MILLISECONDS.toHours(time);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(time) - TimeUnit.HOURS.toMinutes(hours);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.MINUTES.toSeconds(minutes);
        return new long[]{hours, minutes, seconds};
    }

    private String formatHMSString(long hours, long minutes, long seconds) {
        return this.addZeroIfLessThanTen(hours) + ":" + this.addZeroIfLessThanTen(minutes) + ":" + this.addZeroIfLessThanTen(seconds);
    }

    private String addZeroIfLessThanTen(long number) {
        if (number < 10L) {
            return "0" + number;
        }
        return String.valueOf(number);
    }
}

