/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.RegistryException;

public class Nad83Registry
extends AbstractProjRegistry {
    static final Pattern NAD83_REGEX = Pattern.compile("\\s+");

    @Override
    public String getRegistryName() {
        return "nad83";
    }

    @Override
    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            return this.projParser.readParameters(code, NAD83_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the NAD83 registry", ex);
        }
    }

    @Override
    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            return this.projParser.getSupportedCodes(NAD83_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the NAD83 registry", ex);
        }
    }
}

