/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.system;

import org.h2gis.api.DeterministicScalarFunction;

public class IntegerRange
extends DeterministicScalarFunction {
    public IntegerRange() {
        this.addProperty("remarks", "Return an array of integers within the range [start-end). \nThe default step increment is 1 but the user can set another one.");
    }

    public String getJavaStaticMethod() {
        return "createArray";
    }

    public static Integer[] createArray(int begin, int end) {
        return IntegerRange.createArray(begin, end, 1);
    }

    public static Integer[] createArray(int begin, int end, int step) {
        if (end < begin) {
            throw new IllegalArgumentException("End must be greater or equal to begin");
        }
        int nbClasses = (end - begin) / step;
        Integer[] getArray = new Integer[nbClasses];
        for (int i = 0; i < nbClasses; ++i) {
            getArray[i] = i * step + begin;
        }
        return getArray;
    }
}

