/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ST_AsGeoJSON
extends DeterministicScalarFunction {
    static int maxdecimaldigits = 9;

    public ST_AsGeoJSON() {
        this.addProperty("remarks", "Return the geometry as a Geometry Javascript Object Notation (GeoJSON 1.0) element.\n2D and 3D Geometries are both supported.\nGeoJSON only supports SFS 1.1 geometry types (POINT, LINESTRING, POLYGON and COLLECTION)maxdecimaldigits argument may be used to reduce the maximum number of decimal places used in output (defaults to 9).");
    }

    public String getJavaStaticMethod() {
        return "toGeojson";
    }

    public static String toGeojson(Geometry geom) {
        StringBuilder sb = new StringBuilder();
        ST_AsGeoJSON.toGeojsonGeometry(geom, maxdecimaldigits, sb);
        return sb.toString();
    }

    public static String toGeojson(Geometry geom, int maxdecimaldigits) {
        StringBuilder sb = new StringBuilder();
        ST_AsGeoJSON.toGeojsonGeometry(geom, maxdecimaldigits, sb);
        return sb.toString();
    }

    public static void toGeojsonGeometry(Geometry geom, int maxdecimaldigits, StringBuilder sb) {
        if (geom instanceof Point) {
            ST_AsGeoJSON.toGeojsonPoint((Point)geom, maxdecimaldigits, sb);
        } else if (geom instanceof LineString) {
            ST_AsGeoJSON.toGeojsonLineString((LineString)geom, maxdecimaldigits, sb);
        } else if (geom instanceof Polygon) {
            ST_AsGeoJSON.toGeojsonPolygon((Polygon)geom, maxdecimaldigits, sb);
        } else if (geom instanceof MultiPoint) {
            ST_AsGeoJSON.toGeojsonMultiPoint((MultiPoint)geom, maxdecimaldigits, sb);
        } else if (geom instanceof MultiLineString) {
            ST_AsGeoJSON.toGeojsonMultiLineString((MultiLineString)geom, maxdecimaldigits, sb);
        } else if (geom instanceof MultiPolygon) {
            ST_AsGeoJSON.toGeojsonMultiPolygon((MultiPolygon)geom, maxdecimaldigits, sb);
        } else {
            ST_AsGeoJSON.toGeojsonGeometryCollection((GeometryCollection)geom, maxdecimaldigits, sb);
        }
    }

    public static void toGeojsonPoint(Point point, int maxdecimaldigits, StringBuilder sb) {
        Coordinate coord = point.getCoordinate();
        sb.append("{\"type\":\"Point\",\"coordinates\":[");
        sb.append(CoordinateUtils.round((double)coord.x, (int)maxdecimaldigits)).append(",").append(CoordinateUtils.round((double)coord.y, (int)maxdecimaldigits));
        if (!Double.isNaN(coord.z)) {
            sb.append(",").append(CoordinateUtils.round((double)coord.z, (int)maxdecimaldigits));
        }
        sb.append("]}");
    }

    public static void toGeojsonMultiPoint(MultiPoint multiPoint, int maxdecimaldigits, StringBuilder sb) {
        sb.append("{\"type\":\"MultiPoint\",\"coordinates\":");
        ST_AsGeoJSON.toGeojsonCoordinates(multiPoint.getCoordinates(), maxdecimaldigits, sb);
        sb.append("}");
    }

    public static void toGeojsonLineString(LineString lineString, int maxdecimaldigits, StringBuilder sb) {
        sb.append("{\"type\":\"LineString\",\"coordinates\":");
        ST_AsGeoJSON.toGeojsonCoordinates(lineString.getCoordinates(), maxdecimaldigits, sb);
        sb.append("}");
    }

    public static void toGeojsonMultiLineString(MultiLineString multiLineString, int maxdecimaldigits, StringBuilder sb) {
        sb.append("{\"type\":\"MultiLineString\",\"coordinates\":[");
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            ST_AsGeoJSON.toGeojsonCoordinates(multiLineString.getGeometryN(i).getCoordinates(), maxdecimaldigits, sb);
            if (i >= multiLineString.getNumGeometries() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
    }

    public static void toGeojsonPolygon(Polygon polygon, int maxdecimaldigits, StringBuilder sb) {
        sb.append("{\"type\":\"Polygon\",\"coordinates\":[");
        ST_AsGeoJSON.toGeojsonCoordinates(polygon.getExteriorRing().getCoordinates(), maxdecimaldigits, sb);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            sb.append(",");
            ST_AsGeoJSON.toGeojsonCoordinates(polygon.getInteriorRingN(i).getCoordinates(), maxdecimaldigits, sb);
        }
        sb.append("]}");
    }

    public static void toGeojsonMultiPolygon(MultiPolygon multiPolygon, int maxdecimaldigits, StringBuilder sb) {
        sb.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon p = (Polygon)multiPolygon.getGeometryN(i);
            sb.append("[");
            ST_AsGeoJSON.toGeojsonCoordinates(p.getExteriorRing().getCoordinates(), maxdecimaldigits, sb);
            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                sb.append(",");
                ST_AsGeoJSON.toGeojsonCoordinates(p.getInteriorRingN(j).getCoordinates(), maxdecimaldigits, sb);
            }
            sb.append("]");
            if (i >= multiPolygon.getNumGeometries() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
    }

    public static void toGeojsonGeometryCollection(GeometryCollection geometryCollection, int maxdecimaldigits, StringBuilder sb) {
        sb.append("{\"type\":\"GeometryCollection\",\"geometries\":[");
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geom = geometryCollection.getGeometryN(i);
            if (geom instanceof Point) {
                ST_AsGeoJSON.toGeojsonPoint((Point)geom, maxdecimaldigits, sb);
            } else if (geom instanceof LineString) {
                ST_AsGeoJSON.toGeojsonLineString((LineString)geom, maxdecimaldigits, sb);
            } else if (geom instanceof Polygon) {
                ST_AsGeoJSON.toGeojsonPolygon((Polygon)geom, maxdecimaldigits, sb);
            }
            if (i >= geometryCollection.getNumGeometries() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
    }

    public static void toGeojsonCoordinates(Coordinate[] coords, int maxdecimaldigits, StringBuilder sb) {
        sb.append("[");
        for (int i = 0; i < coords.length; ++i) {
            ST_AsGeoJSON.toGeojsonCoordinate(coords[i], maxdecimaldigits, sb);
            if (i >= coords.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
    }

    public static void toGeojsonCoordinate(Coordinate coord, int maxdecimaldigits, StringBuilder sb) {
        sb.append("[");
        sb.append(CoordinateUtils.round((double)coord.x, (int)maxdecimaldigits)).append(",").append(CoordinateUtils.round((double)coord.y, (int)maxdecimaldigits));
        if (!Double.isNaN(coord.z)) {
            sb.append(",").append(CoordinateUtils.round((double)coord.z, (int)maxdecimaldigits));
        }
        sb.append("]");
    }

    public String toGeoJsonEnvelope(Envelope e, int maxdecimaldigits) {
        return new StringBuffer().append("[").append(CoordinateUtils.round((double)e.getMinX(), (int)maxdecimaldigits)).append(",").append(CoordinateUtils.round((double)e.getMinY(), (int)maxdecimaldigits)).append(",").append(CoordinateUtils.round((double)e.getMaxX(), (int)maxdecimaldigits)).append(",").append(CoordinateUtils.round((double)e.getMaxY(), (int)maxdecimaldigits)).append("]").toString();
    }
}

