/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.store.DataHandler;
import org.h2.util.Bits;
import org.h2.util.DateTimeUtils;
import org.h2.util.HasSQL;
import org.h2.util.IntervalUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.geometry.GeoJsonUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfo;
import org.h2.value.ExtTypeInfoArray;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.TypeInfo;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueEnum;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;
import org.h2.value.VersionedValue;

public abstract class Value
extends VersionedValue<Value>
implements HasSQL {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int TINYINT = 2;
    public static final int SMALLINT = 3;
    public static final int INTEGER = 4;
    public static final int BIGINT = 5;
    public static final int NUMERIC = 6;
    public static final int DOUBLE = 7;
    public static final int REAL = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int VARBINARY = 12;
    public static final int VARCHAR = 13;
    public static final int VARCHAR_IGNORECASE = 14;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int ARRAY = 17;
    public static final int RESULT_SET = 18;
    public static final int JAVA_OBJECT = 19;
    public static final int UUID = 20;
    public static final int CHAR = 21;
    public static final int GEOMETRY = 22;
    public static final int TIMESTAMP_TZ = 24;
    public static final int ENUM = 25;
    public static final int INTERVAL_YEAR = 26;
    public static final int INTERVAL_MONTH = 27;
    public static final int INTERVAL_DAY = 28;
    public static final int INTERVAL_HOUR = 29;
    public static final int INTERVAL_MINUTE = 30;
    public static final int INTERVAL_SECOND = 31;
    public static final int INTERVAL_YEAR_TO_MONTH = 32;
    public static final int INTERVAL_DAY_TO_HOUR = 33;
    public static final int INTERVAL_DAY_TO_MINUTE = 34;
    public static final int INTERVAL_DAY_TO_SECOND = 35;
    public static final int INTERVAL_HOUR_TO_MINUTE = 36;
    public static final int INTERVAL_HOUR_TO_SECOND = 37;
    public static final int INTERVAL_MINUTE_TO_SECOND = 38;
    public static final int ROW = 39;
    public static final int JSON = 40;
    public static final int TIME_TZ = 41;
    public static final int BINARY = 42;
    public static final int TYPE_COUNT = 43;
    public static final Value[] EMPTY_VALUES = new Value[0];
    private static SoftReference<Value[]> softCache;
    static final BigDecimal MAX_LONG_DECIMAL;
    public static final BigDecimal MIN_LONG_DECIMAL;
    static final int CONVERT_TO = 0;
    static final int CAST_TO = 1;
    static final int ASSIGN_TO = 2;

    static void rangeCheck(long l, long l2, long l3) {
        if ((l | l2) < 0L || l2 > l3 - l) {
            if (l < 0L || l > l3) {
                throw DbException.getInvalidValueException("offset", l + 1L);
            }
            throw DbException.getInvalidValueException("length", l2);
        }
    }

    public abstract TypeInfo getType();

    public abstract int getValueType();

    public int getMemory() {
        return 24;
    }

    public abstract String getString();

    public abstract Object getObject();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static int getOrder(int n) {
        switch (n) {
            case -1: {
                return 1000;
            }
            case 0: {
                return 2000;
            }
            case 13: {
                return 10000;
            }
            case 16: {
                return 11000;
            }
            case 21: {
                return 12000;
            }
            case 14: {
                return 13000;
            }
            case 1: {
                return 20000;
            }
            case 2: {
                return 21000;
            }
            case 3: {
                return 22000;
            }
            case 4: {
                return 23000;
            }
            case 5: {
                return 24000;
            }
            case 6: {
                return 25000;
            }
            case 8: {
                return 26000;
            }
            case 7: {
                return 27000;
            }
            case 26: {
                return 28000;
            }
            case 27: {
                return 28100;
            }
            case 32: {
                return 28200;
            }
            case 28: {
                return 29000;
            }
            case 29: {
                return 29100;
            }
            case 33: {
                return 29200;
            }
            case 30: {
                return 29300;
            }
            case 36: {
                return 29400;
            }
            case 34: {
                return 29500;
            }
            case 31: {
                return 29600;
            }
            case 38: {
                return 29700;
            }
            case 37: {
                return 29800;
            }
            case 35: {
                return 29900;
            }
            case 9: {
                return 30000;
            }
            case 41: {
                return 30500;
            }
            case 10: {
                return 31000;
            }
            case 11: {
                return 32000;
            }
            case 24: {
                return 34000;
            }
            case 42: {
                return 39000;
            }
            case 12: {
                return 40000;
            }
            case 15: {
                return 41000;
            }
            case 19: {
                return 42000;
            }
            case 20: {
                return 43000;
            }
            case 22: {
                return 44000;
            }
            case 25: {
                return 45000;
            }
            case 40: {
                return 46000;
            }
            case 17: {
                return 50000;
            }
            case 39: {
                return 51000;
            }
            case 18: {
                return 52000;
            }
        }
        throw DbException.throwInternalError("type:" + n);
    }

    public static int getHigherOrder(int n, int n2) {
        int n3;
        if (n == -1 || n2 == -1) {
            if (n == n2) {
                throw DbException.get(50004, "?, ?");
            }
            if (n == 0) {
                throw DbException.get(50004, "NULL, ?");
            }
            if (n2 == 0) {
                throw DbException.get(50004, "?, NULL");
            }
        }
        if (n == n2) {
            return n;
        }
        int n4 = Value.getOrder(n);
        return n4 > (n3 = Value.getOrder(n2)) ? n : n2;
    }

    public static TypeInfo getHigherType(TypeInfo typeInfo, TypeInfo typeInfo2) {
        int n = typeInfo.getValueType();
        int n2 = typeInfo2.getValueType();
        int n3 = Value.getHigherOrder(n, n2);
        long l = Math.max(typeInfo.getPrecision(), typeInfo2.getPrecision());
        int n4 = Math.max(typeInfo.getScale(), typeInfo2.getScale());
        ExtTypeInfo extTypeInfo = typeInfo.getExtTypeInfo();
        ExtTypeInfo extTypeInfo2 = n3 == n && extTypeInfo != null ? extTypeInfo : (n3 == n2 ? typeInfo2.getExtTypeInfo() : null);
        return TypeInfo.getTypeInfo(n3, l, n4, extTypeInfo2);
    }

    static Value cache(Value value) {
        if (SysProperties.OBJECT_CACHE) {
            int n;
            Value value2;
            Value[] valueArray;
            int n2 = value.hashCode();
            if (softCache == null || (valueArray = softCache.get()) == null) {
                valueArray = new Value[SysProperties.OBJECT_CACHE_SIZE];
                softCache = new SoftReference<Value[]>(valueArray);
            }
            if ((value2 = valueArray[n = n2 & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && value2.getValueType() == value.getValueType() && value.equals(value2)) {
                return value2;
            }
            valueArray[n] = value;
        }
        return value;
    }

    public static void clearCache() {
        softCache = null;
    }

    public boolean getBoolean() {
        return this.convertToBoolean().getBoolean();
    }

    public byte[] getBytes() {
        return this.convertTo(TypeInfo.TYPE_VARBINARY).getBytes();
    }

    public byte[] getBytesNoCopy() {
        return this.convertTo(TypeInfo.TYPE_VARBINARY).getBytesNoCopy();
    }

    public byte getByte() {
        return this.convertToTinyint(null).getByte();
    }

    public short getShort() {
        return this.convertToSmallint(null).getShort();
    }

    public BigDecimal getBigDecimal() {
        return this.convertTo(TypeInfo.TYPE_NUMERIC).getBigDecimal();
    }

    public double getDouble() {
        return this.convertToDouble().getDouble();
    }

    public float getFloat() {
        return this.convertToReal().getFloat();
    }

    public int getInt() {
        return this.convertToInt(null).getInt();
    }

    public long getLong() {
        return this.convertToBigint(null).getLong();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public InputStream getInputStream(long l, long l2) {
        byte[] byArray = this.getBytesNoCopy();
        long l3 = l - 1L;
        Value.rangeCheck(l3, l2, byArray.length);
        return new ByteArrayInputStream(byArray, (int)l3, (int)l2);
    }

    public Reader getReader() {
        return new StringReader(this.getString());
    }

    public Reader getReader(long l, long l2) {
        String string = this.getString();
        long l3 = l - 1L;
        Value.rangeCheck(l3, l2, string.length());
        int n = (int)l3;
        return new StringReader(string.substring(n, n + (int)l2));
    }

    public Value add(Value value) {
        throw this.getUnsupportedExceptionForOperation("+");
    }

    public int getSignum() {
        throw this.getUnsupportedExceptionForOperation("SIGNUM");
    }

    public Value negate() {
        throw this.getUnsupportedExceptionForOperation("NEG");
    }

    public Value subtract(Value value) {
        throw this.getUnsupportedExceptionForOperation("-");
    }

    public Value divide(Value value, long l) {
        throw this.getUnsupportedExceptionForOperation("/");
    }

    public Value multiply(Value value) {
        throw this.getUnsupportedExceptionForOperation("*");
    }

    public Value modulus(Value value) {
        throw this.getUnsupportedExceptionForOperation("%");
    }

    public final Value convertTo(int n) {
        return this.convertTo(TypeInfo.getTypeInfo(n), null, 0, null);
    }

    public final Value convertTo(TypeInfo typeInfo) {
        return this.convertTo(typeInfo, null, 0, null);
    }

    public final Value convertTo(int n, CastDataProvider castDataProvider) {
        return this.convertTo(TypeInfo.getTypeInfo(n), castDataProvider, 0, null);
    }

    public final Value convertTo(TypeInfo typeInfo, CastDataProvider castDataProvider) {
        return this.convertTo(typeInfo, castDataProvider, 0, null);
    }

    public final Value convertTo(TypeInfo typeInfo, CastDataProvider castDataProvider, Object object) {
        return this.convertTo(typeInfo, castDataProvider, 0, object);
    }

    public final Value castTo(TypeInfo typeInfo, CastDataProvider castDataProvider) {
        return this.convertTo(typeInfo, castDataProvider, 1, null);
    }

    public final Value convertForAssignTo(TypeInfo typeInfo, CastDataProvider castDataProvider, Object object) {
        return this.convertTo(typeInfo, castDataProvider, 2, object);
    }

    private Value convertTo(TypeInfo typeInfo, CastDataProvider castDataProvider, int n, Object object) {
        int n2;
        int n3 = this.getValueType();
        if (n3 == 0 || n3 == (n2 = typeInfo.getValueType()) && n == 0 && typeInfo.getExtTypeInfo() == null) {
            return this;
        }
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 1: {
                return this.convertToBoolean();
            }
            case 2: {
                return this.convertToTinyint(object);
            }
            case 3: {
                return this.convertToSmallint(object);
            }
            case 4: {
                return this.convertToInt(object);
            }
            case 5: {
                return this.convertToBigint(object);
            }
            case 6: {
                return this.convertToNumeric(typeInfo, castDataProvider, n, object);
            }
            case 7: {
                return this.convertToDouble();
            }
            case 8: {
                return this.convertToReal();
            }
            case 10: {
                return this.convertToDate(castDataProvider);
            }
            case 9: {
                return this.convertToTime(typeInfo, castDataProvider, n);
            }
            case 41: {
                return this.convertToTimeTimeZone(typeInfo, castDataProvider, n);
            }
            case 11: {
                return this.convertToTimestamp(typeInfo, castDataProvider, n);
            }
            case 24: {
                return this.convertToTimestampTimeZone(typeInfo, castDataProvider, n);
            }
            case 12: {
                return this.convertToVarbinary(typeInfo, n, object);
            }
            case 42: {
                return this.convertToBinary(typeInfo, n, object);
            }
            case 13: {
                return ValueVarchar.get(this.convertToVarchar(typeInfo, n, object));
            }
            case 14: {
                return ValueVarcharIgnoreCase.get(this.convertToVarchar(typeInfo, n, object));
            }
            case 21: {
                return this.convertToChar(typeInfo, n, object);
            }
            case 19: {
                return this.convertToJavaObject(typeInfo, n, object);
            }
            case 25: {
                return this.convertToEnum((ExtTypeInfoEnum)typeInfo.getExtTypeInfo());
            }
            case 15: {
                return this.convertToBlob(typeInfo, n, object);
            }
            case 16: {
                return this.convertToClob(typeInfo, n, object);
            }
            case 20: {
                return this.convertToUuid();
            }
            case 22: {
                return this.convertToGeometry((ExtTypeInfoGeometry)typeInfo.getExtTypeInfo());
            }
            case 26: 
            case 27: 
            case 32: {
                return this.convertToIntervalYearMonth(typeInfo, n, object);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return this.convertToIntervalDayTime(typeInfo, n, object);
            }
            case 40: {
                return this.convertToJson();
            }
            case 17: {
                return this.convertToArray(typeInfo, castDataProvider, n, object);
            }
            case 39: {
                return this.convertToRow();
            }
            case 18: {
                return this.convertToResultSet();
            }
        }
        throw this.getDataConversionError(n2);
    }

    public final ValueBoolean convertToBoolean() {
        switch (this.getValueType()) {
            case 1: {
                return (ValueBoolean)this;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValueBoolean.get(this.getSignum() != 0);
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
                    return ValueBoolean.TRUE;
                }
                if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n")) {
                    return ValueBoolean.FALSE;
                }
                try {
                    return ValueBoolean.get(new BigDecimal(string).signum() != 0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            default: {
                throw this.getDataConversionError(1);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueTinyint convertToTinyint(Object object) {
        switch (this.getValueType()) {
            case 2: {
                return (ValueTinyint)this;
            }
            case 1: {
                return ValueTinyint.get(this.getBoolean() ? (byte)1 : 0);
            }
            case 3: 
            case 4: 
            case 25: {
                return ValueTinyint.get(Value.convertToByte(this.getInt(), object));
            }
            case 5: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return ValueTinyint.get(Value.convertToByte(this.getLong(), object));
            }
            case 6: {
                return ValueTinyint.get(Value.convertToByte(Value.convertToLong(this.getBigDecimal(), object), object));
            }
            case 7: 
            case 8: {
                return ValueTinyint.get(Value.convertToByte(Value.convertToLong(this.getDouble(), object), object));
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return ValueTinyint.get(Byte.parseByte(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            case 12: {
                byte[] byArray = this.getBytesNoCopy();
                if (byArray.length == 1) {
                    return ValueTinyint.get(byArray[0]);
                }
            }
            default: {
                throw this.getDataConversionError(2);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueSmallint convertToSmallint(Object object) {
        switch (this.getValueType()) {
            case 3: {
                return (ValueSmallint)this;
            }
            case 1: {
                return ValueSmallint.get(this.getBoolean() ? (short)1 : 0);
            }
            case 2: {
                return ValueSmallint.get(this.getByte());
            }
            case 4: 
            case 25: {
                return ValueSmallint.get(Value.convertToShort(this.getInt(), object));
            }
            case 5: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return ValueSmallint.get(Value.convertToShort(this.getLong(), object));
            }
            case 6: {
                return ValueSmallint.get(Value.convertToShort(Value.convertToLong(this.getBigDecimal(), object), object));
            }
            case 7: 
            case 8: {
                return ValueSmallint.get(Value.convertToShort(Value.convertToLong(this.getDouble(), object), object));
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return ValueSmallint.get(Short.parseShort(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            case 12: {
                byte[] byArray = this.getBytesNoCopy();
                if (byArray.length == 2) {
                    return ValueSmallint.get((short)((byArray[0] << 8) + (byArray[1] & 0xFF)));
                }
            }
            default: {
                throw this.getDataConversionError(3);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueInteger convertToInt(Object object) {
        switch (this.getValueType()) {
            case 4: {
                return (ValueInteger)this;
            }
            case 1: {
                return ValueInteger.get(this.getBoolean() ? 1 : 0);
            }
            case 2: 
            case 3: 
            case 25: {
                return ValueInteger.get(this.getInt());
            }
            case 5: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return ValueInteger.get(Value.convertToInt(this.getLong(), object));
            }
            case 6: {
                return ValueInteger.get(Value.convertToInt(Value.convertToLong(this.getBigDecimal(), object), object));
            }
            case 7: 
            case 8: {
                return ValueInteger.get(Value.convertToInt(Value.convertToLong(this.getDouble(), object), object));
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return ValueInteger.get(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            case 12: {
                byte[] byArray = this.getBytesNoCopy();
                if (byArray.length == 4) {
                    return ValueInteger.get(Bits.readInt(byArray, 0));
                }
            }
            default: {
                throw this.getDataConversionError(4);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueBigint convertToBigint(Object object) {
        switch (this.getValueType()) {
            case 5: {
                return (ValueBigint)this;
            }
            case 1: {
                return ValueBigint.get(this.getBoolean() ? 1L : 0L);
            }
            case 2: 
            case 3: 
            case 4: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return ValueBigint.get(this.getInt());
            }
            case 6: {
                return ValueBigint.get(Value.convertToLong(this.getBigDecimal(), object));
            }
            case 7: 
            case 8: {
                return ValueBigint.get(Value.convertToLong(this.getDouble(), object));
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return ValueBigint.get(Long.parseLong(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            case 12: {
                byte[] byArray = this.getBytesNoCopy();
                if (byArray.length == 8) {
                    return ValueBigint.get(Bits.readLong(byArray, 0));
                }
            }
            default: {
                throw this.getDataConversionError(5);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    private ValueNumeric convertToNumeric(TypeInfo typeInfo, CastDataProvider castDataProvider, int n, Object object) {
        ValueNumeric valueNumeric;
        switch (this.getValueType()) {
            case 6: {
                valueNumeric = (ValueNumeric)this;
                break;
            }
            case 1: {
                valueNumeric = this.getBoolean() ? ValueNumeric.ONE : ValueNumeric.ZERO;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                valueNumeric = ValueNumeric.get(BigDecimal.valueOf(this.getInt()));
                break;
            }
            case 5: {
                valueNumeric = ValueNumeric.get(BigDecimal.valueOf(this.getLong()));
                break;
            }
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                valueNumeric = ValueNumeric.get(this.getBigDecimal());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    valueNumeric = ValueNumeric.get(new BigDecimal(string.trim()));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            default: {
                throw this.getDataConversionError(6);
            }
        }
        if (n != 0) {
            int n2 = typeInfo.getScale();
            BigDecimal bigDecimal = valueNumeric.getBigDecimal();
            int n3 = bigDecimal.scale();
            if (!(n3 == n2 || n3 < n2 && castDataProvider.getMode().convertOnlyToSmallerScale)) {
                valueNumeric = ValueNumeric.get(ValueNumeric.setScale(bigDecimal, n2));
            }
            if ((long)valueNumeric.getBigDecimal().precision() > typeInfo.getPrecision()) {
                throw valueNumeric.getValueTooLongException(typeInfo, object);
            }
        }
        return valueNumeric;
    }

    public final ValueDouble convertToDouble() {
        switch (this.getValueType()) {
            case 7: {
                return (ValueDouble)this;
            }
            case 1: {
                return this.getBoolean() ? ValueDouble.ONE : ValueDouble.ZERO;
            }
            case 2: 
            case 3: 
            case 4: {
                return ValueDouble.get(this.getInt());
            }
            case 5: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return ValueDouble.get(this.getLong());
            }
            case 6: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return ValueDouble.get(this.getBigDecimal().doubleValue());
            }
            case 8: {
                return ValueDouble.get(this.getFloat());
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return ValueDouble.get(Double.parseDouble(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            default: {
                throw this.getDataConversionError(7);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueReal convertToReal() {
        switch (this.getValueType()) {
            case 8: {
                return (ValueReal)this;
            }
            case 1: {
                return this.getBoolean() ? ValueReal.ONE : ValueReal.ZERO;
            }
            case 2: 
            case 3: 
            case 4: {
                return ValueReal.get(this.getInt());
            }
            case 5: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return ValueReal.get(this.getLong());
            }
            case 6: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return ValueReal.get(this.getBigDecimal().floatValue());
            }
            case 7: {
                return ValueReal.get((float)this.getDouble());
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return ValueReal.get(Float.parseFloat(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw DbException.get(22018, numberFormatException, string);
                }
            }
            default: {
                throw this.getDataConversionError(8);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueDate convertToDate(CastDataProvider castDataProvider) {
        switch (this.getValueType()) {
            case 10: {
                return (ValueDate)this;
            }
            case 11: {
                return ValueDate.fromDateValue(((ValueTimestamp)this).getDateValue());
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                long l = valueTimestampTimeZone.getTimeNanos();
                long l2 = DateTimeUtils.getEpochSeconds(valueTimestampTimeZone.getDateValue(), l, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromLocalSeconds(l2 + (long)castDataProvider.currentTimeZone().getTimeZoneOffsetUTC(l2)));
            }
            case 13: 
            case 14: 
            case 21: {
                return ValueDate.parse(this.getString().trim());
            }
            default: {
                throw this.getDataConversionError(10);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    private ValueTime convertToTime(TypeInfo typeInfo, CastDataProvider castDataProvider, int n) {
        int n2;
        long l;
        long l2;
        ValueTime valueTime;
        switch (this.getValueType()) {
            case 9: {
                valueTime = (ValueTime)this;
                break;
            }
            case 41: {
                valueTime = ValueTime.fromNanos(this.getLocalTimeNanos(castDataProvider));
                break;
            }
            case 11: {
                valueTime = ValueTime.fromNanos(((ValueTimestamp)this).getTimeNanos());
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                l2 = valueTimestampTimeZone.getTimeNanos();
                l = DateTimeUtils.getEpochSeconds(valueTimestampTimeZone.getDateValue(), l2, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                valueTime = ValueTime.fromNanos(DateTimeUtils.nanosFromLocalSeconds(l + (long)castDataProvider.currentTimeZone().getTimeZoneOffsetUTC(l)) + l2 % 1000000000L);
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueTime = ValueTime.parse(this.getString().trim());
                break;
            }
            default: {
                throw this.getDataConversionError(9);
            }
        }
        if (n != 0 && (n2 = typeInfo.getScale()) < 9 && (l = DateTimeUtils.convertScale(l2 = valueTime.getNanos(), n2, 86400000000000L)) != l2) {
            valueTime = ValueTime.fromNanos(l);
        }
        return valueTime;
    }

    private ValueTimeTimeZone convertToTimeTimeZone(TypeInfo typeInfo, CastDataProvider castDataProvider, int n) {
        long l;
        int n2;
        long l2;
        ValueTimeTimeZone valueTimeTimeZone;
        switch (this.getValueType()) {
            case 41: {
                valueTimeTimeZone = (ValueTimeTimeZone)this;
                break;
            }
            case 9: {
                valueTimeTimeZone = ValueTimeTimeZone.fromNanos(((ValueTime)this).getNanos(), castDataProvider.currentTimestamp().getTimeZoneOffsetSeconds());
                break;
            }
            case 11: {
                Value value = (ValueTimestamp)this;
                l2 = ((ValueTimestamp)value).getTimeNanos();
                valueTimeTimeZone = ValueTimeTimeZone.fromNanos(l2, castDataProvider.currentTimeZone().getTimeZoneOffsetLocal(((ValueTimestamp)value).getDateValue(), l2));
                break;
            }
            case 24: {
                Value value = (ValueTimestampTimeZone)this;
                valueTimeTimeZone = ValueTimeTimeZone.fromNanos(((ValueTimestampTimeZone)value).getTimeNanos(), ((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueTimeTimeZone = ValueTimeTimeZone.parse(this.getString().trim());
                break;
            }
            default: {
                throw this.getDataConversionError(41);
            }
        }
        if (n != 0 && (n2 = typeInfo.getScale()) < 9 && (l = DateTimeUtils.convertScale(l2 = valueTimeTimeZone.getNanos(), n2, 86400000000000L)) != l2) {
            valueTimeTimeZone = ValueTimeTimeZone.fromNanos(l, valueTimeTimeZone.getTimeZoneOffsetSeconds());
        }
        return valueTimeTimeZone;
    }

    private ValueTimestamp convertToTimestamp(TypeInfo typeInfo, CastDataProvider castDataProvider, int n) {
        int n2;
        long l;
        long l2;
        ValueTimestamp valueTimestamp;
        switch (this.getValueType()) {
            case 11: {
                valueTimestamp = (ValueTimestamp)this;
                break;
            }
            case 9: {
                valueTimestamp = ValueTimestamp.fromDateValueAndNanos(castDataProvider.currentTimestamp().getDateValue(), ((ValueTime)this).getNanos());
                break;
            }
            case 41: {
                valueTimestamp = ValueTimestamp.fromDateValueAndNanos(castDataProvider.currentTimestamp().getDateValue(), this.getLocalTimeNanos(castDataProvider));
                break;
            }
            case 10: {
                return ValueTimestamp.fromDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                l2 = valueTimestampTimeZone.getTimeNanos();
                l = DateTimeUtils.getEpochSeconds(valueTimestampTimeZone.getDateValue(), l2, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                l += (long)castDataProvider.currentTimeZone().getTimeZoneOffsetUTC(l);
                valueTimestamp = ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromLocalSeconds(l), DateTimeUtils.nanosFromLocalSeconds(l) + l2 % 1000000000L);
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueTimestamp = ValueTimestamp.parse(this.getString().trim(), castDataProvider);
                break;
            }
            default: {
                throw this.getDataConversionError(11);
            }
        }
        if (n != 0 && (n2 = typeInfo.getScale()) < 9) {
            l2 = valueTimestamp.getDateValue();
            l = valueTimestamp.getTimeNanos();
            long l3 = DateTimeUtils.convertScale(l, n2, l2 == 512000000415L ? 86400000000000L : Long.MAX_VALUE);
            if (l3 != l) {
                if (l3 >= 86400000000000L) {
                    l3 -= 86400000000000L;
                    l2 = DateTimeUtils.incrementDateValue(l2);
                }
                valueTimestamp = ValueTimestamp.fromDateValueAndNanos(l2, l3);
            }
        }
        return valueTimestamp;
    }

    private long getLocalTimeNanos(CastDataProvider castDataProvider) {
        ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)this;
        int n = castDataProvider.currentTimestamp().getTimeZoneOffsetSeconds();
        return DateTimeUtils.normalizeNanosOfDay(valueTimeTimeZone.getNanos() + (long)(valueTimeTimeZone.getTimeZoneOffsetSeconds() - n) * 86400000000000L);
    }

    private ValueTimestampTimeZone convertToTimestampTimeZone(TypeInfo typeInfo, CastDataProvider castDataProvider, int n) {
        int n2;
        long l;
        long l2;
        ValueTimestampTimeZone valueTimestampTimeZone;
        switch (this.getValueType()) {
            case 24: {
                valueTimestampTimeZone = (ValueTimestampTimeZone)this;
                break;
            }
            case 9: {
                long l3 = castDataProvider.currentTimestamp().getDateValue();
                long l4 = ((ValueTime)this).getNanos();
                valueTimestampTimeZone = ValueTimestampTimeZone.fromDateValueAndNanos(l3, l4, castDataProvider.currentTimeZone().getTimeZoneOffsetLocal(l3, l4));
                break;
            }
            case 41: {
                ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)this;
                valueTimestampTimeZone = ValueTimestampTimeZone.fromDateValueAndNanos(castDataProvider.currentTimestamp().getDateValue(), valueTimeTimeZone.getNanos(), valueTimeTimeZone.getTimeZoneOffsetSeconds());
                break;
            }
            case 10: {
                long l5 = ((ValueDate)this).getDateValue();
                return ValueTimestampTimeZone.fromDateValueAndNanos(l5, 0L, castDataProvider.currentTimeZone().getTimeZoneOffsetLocal(l5, 0L));
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)this;
                l2 = valueTimestamp.getDateValue();
                l = valueTimestamp.getTimeNanos();
                valueTimestampTimeZone = ValueTimestampTimeZone.fromDateValueAndNanos(l2, l, castDataProvider.currentTimeZone().getTimeZoneOffsetLocal(l2, l));
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueTimestampTimeZone = ValueTimestampTimeZone.parse(this.getString().trim(), castDataProvider);
                break;
            }
            default: {
                throw this.getDataConversionError(24);
            }
        }
        if (n != 0 && (n2 = typeInfo.getScale()) < 9) {
            l2 = valueTimestampTimeZone.getDateValue();
            l = valueTimestampTimeZone.getTimeNanos();
            long l6 = DateTimeUtils.convertScale(l, n2, l2 == 512000000415L ? 86400000000000L : Long.MAX_VALUE);
            if (l6 != l) {
                if (l6 >= 86400000000000L) {
                    l6 -= 86400000000000L;
                    l2 = DateTimeUtils.incrementDateValue(l2);
                }
                valueTimestampTimeZone = ValueTimestampTimeZone.fromDateValueAndNanos(l2, l6, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
            }
        }
        return valueTimestampTimeZone;
    }

    private ValueVarbinary convertToVarbinary(TypeInfo typeInfo, int n, Object object) {
        ValueVarbinary valueVarbinary;
        switch (this.getValueType()) {
            case 12: {
                valueVarbinary = (ValueVarbinary)this;
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 40: 
            case 42: {
                valueVarbinary = ValueVarbinary.getNoCopy(this.getBytesNoCopy());
                break;
            }
            case 20: {
                valueVarbinary = ValueVarbinary.getNoCopy(this.getBytes());
                break;
            }
            case 2: {
                valueVarbinary = ValueVarbinary.getNoCopy(new byte[]{this.getByte()});
                break;
            }
            case 3: {
                short s = this.getShort();
                valueVarbinary = ValueVarbinary.getNoCopy(new byte[]{(byte)(s >> 8), (byte)s});
                break;
            }
            case 4: {
                byte[] byArray = new byte[4];
                Bits.writeInt(byArray, 0, this.getInt());
                valueVarbinary = ValueVarbinary.getNoCopy(byArray);
                break;
            }
            case 5: {
                byte[] byArray = new byte[8];
                Bits.writeLong(byArray, 0, this.getLong());
                valueVarbinary = ValueVarbinary.getNoCopy(byArray);
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueVarbinary = ValueVarbinary.getNoCopy(this.getString().getBytes(StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw this.getDataConversionError(12);
            }
        }
        if (n != 0) {
            byte[] byArray = valueVarbinary.getBytesNoCopy();
            int n2 = byArray.length;
            int n3 = MathUtils.convertLongToInt(typeInfo.getPrecision());
            if (n == 1) {
                if (n2 > n3) {
                    valueVarbinary = ValueVarbinary.getNoCopy(Arrays.copyOf(byArray, n3));
                }
            } else if (n2 > n3) {
                throw valueVarbinary.getValueTooLongException(typeInfo, object);
            }
        }
        return valueVarbinary;
    }

    private ValueBinary convertToBinary(TypeInfo typeInfo, int n, Object object) {
        int n2;
        byte[] byArray;
        int n3;
        ValueBinary valueBinary;
        switch (this.getValueType()) {
            case 42: {
                valueBinary = (ValueBinary)this;
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 40: {
                valueBinary = ValueBinary.getNoCopy(this.getBytesNoCopy());
                break;
            }
            case 20: {
                valueBinary = ValueBinary.getNoCopy(this.getBytes());
                break;
            }
            case 2: {
                valueBinary = ValueBinary.getNoCopy(new byte[]{this.getByte()});
                break;
            }
            case 3: {
                short s = this.getShort();
                valueBinary = ValueBinary.getNoCopy(new byte[]{(byte)(s >> 8), (byte)s});
                break;
            }
            case 4: {
                byte[] byArray2 = new byte[4];
                Bits.writeInt(byArray2, 0, this.getInt());
                valueBinary = ValueBinary.getNoCopy(byArray2);
                break;
            }
            case 5: {
                byte[] byArray3 = new byte[8];
                Bits.writeLong(byArray3, 0, this.getLong());
                valueBinary = ValueBinary.getNoCopy(byArray3);
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueBinary = ValueBinary.getNoCopy(this.getString().getBytes(StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw this.getDataConversionError(12);
            }
        }
        if (n != 0 && (n3 = (byArray = valueBinary.getBytesNoCopy()).length) != (n2 = MathUtils.convertLongToInt(typeInfo.getPrecision()))) {
            if (n == 2 && n3 > n2) {
                throw valueBinary.getValueTooLongException(typeInfo, object);
            }
            valueBinary = ValueBinary.getNoCopy(Arrays.copyOf(byArray, n2));
        }
        return valueBinary;
    }

    private String convertToVarchar(TypeInfo typeInfo, int n, Object object) {
        switch (this.getValueType()) {
            case 15: 
            case 19: {
                throw this.getDataConversionError(typeInfo.getValueType());
            }
        }
        String string = this.getString();
        if (n != 0) {
            int n2 = MathUtils.convertLongToInt(typeInfo.getPrecision());
            if (string.length() > n2) {
                if (n != 1) {
                    throw this.getValueTooLongException(typeInfo, object);
                }
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    private ValueChar convertToChar(TypeInfo typeInfo, int n, Object object) {
        switch (this.getValueType()) {
            case 15: 
            case 19: {
                throw this.getDataConversionError(typeInfo.getValueType());
            }
        }
        String string = this.getString();
        int n2 = MathUtils.convertLongToInt(typeInfo.getPrecision());
        int n3 = string.length();
        if (n == 1 && n3 > n2) {
            n3 = n2;
        }
        while (n3 > 0 && string.charAt(n3 - 1) == ' ') {
            --n3;
        }
        if (n == 2 && n3 > n2) {
            throw this.getValueTooLongException(typeInfo, object);
        }
        return ValueChar.get(string.substring(0, n3));
    }

    public final ValueJavaObject convertToJavaObject(TypeInfo typeInfo, int n, Object object) {
        ValueJavaObject valueJavaObject;
        switch (this.getValueType()) {
            case 19: {
                valueJavaObject = (ValueJavaObject)this;
                break;
            }
            case 12: {
                valueJavaObject = ValueJavaObject.getNoCopy(this.getBytesNoCopy());
                break;
            }
            default: {
                throw this.getDataConversionError(19);
            }
            case 0: {
                throw DbException.throwInternalError();
            }
        }
        if (n != 0 && (long)valueJavaObject.getBytesNoCopy().length > typeInfo.getPrecision()) {
            throw valueJavaObject.getValueTooLongException(typeInfo, object);
        }
        return valueJavaObject;
    }

    public final ValueEnum convertToEnum(ExtTypeInfoEnum extTypeInfoEnum) {
        switch (this.getValueType()) {
            case 25: {
                ValueEnum valueEnum = (ValueEnum)this;
                if (extTypeInfoEnum.equals(valueEnum.getEnumerators())) {
                    return valueEnum;
                }
                return extTypeInfoEnum.getValue(valueEnum.getString());
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return extTypeInfoEnum.getValue(this.getInt());
            }
            case 13: 
            case 14: 
            case 21: {
                return extTypeInfoEnum.getValue(this.getString());
            }
            default: {
                throw this.getDataConversionError(25);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    private ValueLob convertToBlob(TypeInfo typeInfo, int n, Object object) {
        ValueLob valueLob;
        switch (this.getValueType()) {
            case 15: {
                valueLob = (ValueLob)this;
                break;
            }
            case 16: {
                valueLob = (ValueLob)this;
                DataHandler dataHandler = valueLob.getDataHandler();
                if (dataHandler != null) {
                    valueLob = dataHandler.getLobStorage().createBlob(valueLob.getInputStream(), -1L);
                    break;
                }
                valueLob = ValueLob.createSmallLob(15, valueLob.getBytesNoCopy());
                break;
            }
            case 12: 
            case 22: 
            case 40: {
                valueLob = ValueLob.createSmallLob(15, this.getBytesNoCopy());
                break;
            }
            case 20: {
                valueLob = ValueLob.createSmallLob(15, this.getBytes());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                valueLob = ValueLob.createSmallLob(15, this.getString().getBytes(StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw this.getDataConversionError(15);
            }
        }
        if (n != 0) {
            if (n == 1) {
                valueLob = valueLob.convertPrecision(typeInfo.getPrecision());
            } else if (valueLob.getPrecision() > typeInfo.getPrecision()) {
                throw valueLob.getValueTooLongException(typeInfo, object);
            }
        }
        return valueLob;
    }

    private ValueLob convertToClob(TypeInfo typeInfo, int n, Object object) {
        ValueLob valueLob;
        switch (this.getValueType()) {
            case 16: {
                valueLob = (ValueLob)this;
                break;
            }
            case 19: {
                throw this.getDataConversionError(typeInfo.getValueType());
            }
            case 15: {
                valueLob = (ValueLob)this;
                DataHandler dataHandler = valueLob.getDataHandler();
                if (dataHandler != null) {
                    valueLob = dataHandler.getLobStorage().createClob(valueLob.getReader(), -1L);
                    break;
                }
                byte[] byArray = valueLob.getSmall();
                if (byArray != null) {
                    byte[] byArray2 = new String(byArray, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8);
                    if (Arrays.equals(byArray2, byArray)) {
                        byArray2 = byArray;
                    }
                    valueLob = ValueLob.createSmallLob(16, byArray2);
                    break;
                }
            }
            default: {
                valueLob = ValueLob.createSmallLob(16, this.getString().getBytes(StandardCharsets.UTF_8));
            }
        }
        if (n != 0) {
            if (n == 1) {
                valueLob = valueLob.convertPrecision(typeInfo.getPrecision());
            } else if (valueLob.getPrecision() > typeInfo.getPrecision()) {
                throw valueLob.getValueTooLongException(typeInfo, object);
            }
        }
        return valueLob;
    }

    public final ValueUuid convertToUuid() {
        switch (this.getValueType()) {
            case 20: {
                return (ValueUuid)this;
            }
            case 12: {
                return ValueUuid.get(this.getBytesNoCopy());
            }
            case 19: {
                return JdbcUtils.deserializeUuid(this.getBytesNoCopy());
            }
            case 13: 
            case 14: 
            case 21: {
                return ValueUuid.get(this.getString());
            }
            default: {
                throw this.getDataConversionError(20);
            }
            case 0: 
        }
        throw DbException.throwInternalError();
    }

    public final ValueGeometry convertToGeometry(ExtTypeInfoGeometry extTypeInfoGeometry) {
        Integer n;
        int n2;
        ValueGeometry valueGeometry;
        switch (this.getValueType()) {
            case 22: {
                valueGeometry = (ValueGeometry)this;
                break;
            }
            case 12: {
                valueGeometry = ValueGeometry.getFromEWKB(this.getBytesNoCopy());
                break;
            }
            case 40: {
                n2 = 0;
                if (extTypeInfoGeometry != null && (n = extTypeInfoGeometry.getSrid()) != null) {
                    n2 = n;
                }
                try {
                    valueGeometry = ValueGeometry.get(GeoJsonUtils.geoJsonToEwkb(this.getBytesNoCopy(), n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw DbException.get(22018, this.getTraceSQL());
                }
            }
            case 13: 
            case 14: 
            case 21: {
                valueGeometry = ValueGeometry.get(this.getString());
                break;
            }
            default: {
                throw this.getDataConversionError(22);
            }
            case 0: {
                throw DbException.throwInternalError();
            }
        }
        if (extTypeInfoGeometry != null) {
            n2 = extTypeInfoGeometry.getType();
            n = extTypeInfoGeometry.getSrid();
            if (n2 != 0 && valueGeometry.getTypeAndDimensionSystem() != n2 || n != null && valueGeometry.getSRID() != n.intValue()) {
                throw DbException.get(23513, ExtTypeInfoGeometry.toSQL(valueGeometry.getTypeAndDimensionSystem(), valueGeometry.getSRID()) + " <> " + extTypeInfoGeometry.toString());
            }
        }
        return valueGeometry;
    }

    private ValueInterval convertToIntervalYearMonth(TypeInfo typeInfo, int n, Object object) {
        ValueInterval valueInterval = this.convertToIntervalYearMonth(typeInfo.getValueType(), object);
        if (n != 0 && !valueInterval.checkPrecision(typeInfo.getPrecision())) {
            throw valueInterval.getValueTooLongException(typeInfo, object);
        }
        return valueInterval;
    }

    private ValueInterval convertToIntervalYearMonth(int n, Object object) {
        long l;
        switch (this.getValueType()) {
            case 2: 
            case 3: 
            case 4: {
                l = this.getInt();
                break;
            }
            case 5: {
                l = this.getLong();
                break;
            }
            case 7: 
            case 8: {
                if (n == 32) {
                    return IntervalUtils.intervalFromAbsolute(IntervalQualifier.YEAR_TO_MONTH, this.getBigDecimal().multiply(BigDecimal.valueOf(12L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
                }
                l = Value.convertToLong(this.getDouble(), object);
                break;
            }
            case 6: {
                if (n == 32) {
                    return IntervalUtils.intervalFromAbsolute(IntervalQualifier.YEAR_TO_MONTH, this.getBigDecimal().multiply(BigDecimal.valueOf(12L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
                }
                l = Value.convertToLong(this.getBigDecimal(), object);
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return (ValueInterval)IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(n - 26), string).convertTo(n);
                }
                catch (Exception exception) {
                    throw DbException.get(22007, exception, "INTERVAL", string);
                }
            }
            case 26: 
            case 27: 
            case 32: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), IntervalUtils.intervalToAbsolute((ValueInterval)this));
            }
            default: {
                throw this.getDataConversionError(n);
            }
        }
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        return ValueInterval.from(IntervalQualifier.valueOf(n - 26), bl, l, 0L);
    }

    private ValueInterval convertToIntervalDayTime(TypeInfo typeInfo, int n, Object object) {
        ValueInterval valueInterval = this.convertToIntervalDayTime(typeInfo.getValueType(), object);
        if (n != 0) {
            valueInterval = valueInterval.setPrecisionAndScale(typeInfo, object);
        }
        return valueInterval;
    }

    private ValueInterval convertToIntervalDayTime(int n, Object object) {
        long l;
        switch (this.getValueType()) {
            case 2: 
            case 3: 
            case 4: {
                l = this.getInt();
                break;
            }
            case 5: {
                l = this.getLong();
                break;
            }
            case 7: 
            case 8: {
                if (n > 30) {
                    return this.convertToIntervalDayTime(this.getBigDecimal(), n);
                }
                l = Value.convertToLong(this.getDouble(), object);
                break;
            }
            case 6: {
                if (n > 30) {
                    return this.convertToIntervalDayTime(this.getBigDecimal(), n);
                }
                l = Value.convertToLong(this.getBigDecimal(), object);
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                String string = this.getString();
                try {
                    return (ValueInterval)IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(n - 26), string).convertTo(n);
                }
                catch (Exception exception) {
                    throw DbException.get(22007, exception, "INTERVAL", string);
                }
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), IntervalUtils.intervalToAbsolute((ValueInterval)this));
            }
            default: {
                throw this.getDataConversionError(n);
            }
        }
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        return ValueInterval.from(IntervalQualifier.valueOf(n - 26), bl, l, 0L);
    }

    private ValueInterval convertToIntervalDayTime(BigDecimal bigDecimal, int n) {
        long l;
        switch (n) {
            case 31: {
                l = 1000000000L;
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                l = 86400000000000L;
                break;
            }
            case 36: 
            case 37: {
                l = 3600000000000L;
                break;
            }
            case 38: {
                l = 60000000000L;
                break;
            }
            default: {
                throw this.getDataConversionError(n);
            }
        }
        return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), bigDecimal.multiply(BigDecimal.valueOf(l)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
    }

    private Value convertToJson() {
        switch (this.getValueType()) {
            case 40: {
                return this;
            }
            case 1: {
                return ValueJson.get(this.getBoolean());
            }
            case 2: 
            case 3: 
            case 4: {
                return ValueJson.get(this.getInt());
            }
            case 5: {
                return ValueJson.get(this.getLong());
            }
            case 6: 
            case 7: 
            case 8: {
                return ValueJson.get(this.getBigDecimal());
            }
            case 12: {
                return ValueJson.fromJson(this.getBytesNoCopy());
            }
            case 13: 
            case 14: 
            case 21: {
                return ValueJson.get(this.getString());
            }
            case 22: {
                ValueGeometry valueGeometry = (ValueGeometry)this;
                return ValueJson.getInternal(GeoJsonUtils.ewkbToGeoJson(valueGeometry.getBytesNoCopy(), valueGeometry.getDimensionSystem()));
            }
        }
        throw this.getDataConversionError(40);
    }

    private ValueArray convertToArray(TypeInfo typeInfo, CastDataProvider castDataProvider, int n, Object object) {
        int n2;
        Object object2;
        ValueArray valueArray;
        ExtTypeInfoArray extTypeInfoArray = (ExtTypeInfoArray)typeInfo.getExtTypeInfo();
        int n3 = this.getValueType();
        if (n3 == 17) {
            valueArray = (ValueArray)this;
        } else {
            switch (n3) {
                case 39: {
                    object2 = ((ValueRow)this).getList();
                    break;
                }
                case 15: {
                    object2 = new Value[]{ValueVarbinary.get(this.getBytesNoCopy())};
                    break;
                }
                case 16: 
                case 18: {
                    object2 = new Value[]{ValueVarchar.get(this.getString())};
                    break;
                }
                default: {
                    object2 = new Value[]{this};
                }
            }
            valueArray = ValueArray.get(object2);
        }
        if (extTypeInfoArray != null) {
            object2 = extTypeInfoArray.getComponentType();
            Value[] valueArray2 = valueArray.getList();
            n2 = valueArray2.length;
            for (int i = 0; i < n2; ++i) {
                Value value = valueArray2[i];
                Value value2 = value.convertTo((TypeInfo)object2, castDataProvider, n, object);
                if (value == value2) continue;
                Value[] valueArray3 = new Value[n2];
                System.arraycopy(valueArray2, 0, valueArray3, 0, i);
                valueArray3[i] = value2;
                while (++i < n2) {
                    valueArray3[i] = valueArray2[i].convertTo((TypeInfo)object2, castDataProvider, n, object);
                }
                valueArray = ValueArray.get(valueArray3);
                break;
            }
        }
        if (n != 0) {
            object2 = valueArray.getList();
            int n4 = ((Value[])object2).length;
            if (n == 1) {
                n2 = MathUtils.convertLongToInt(typeInfo.getPrecision());
                if (n4 > n2) {
                    valueArray = ValueArray.get(valueArray.getComponentType(), Arrays.copyOf(object2, n2));
                }
            } else if ((long)n4 > typeInfo.getPrecision()) {
                throw valueArray.getValueTooLongException(typeInfo, object);
            }
        }
        return valueArray;
    }

    private Value convertToRow() {
        Value[] valueArray;
        switch (this.getValueType()) {
            case 39: {
                return this;
            }
            case 18: {
                ResultInterface resultInterface = this.getResult();
                if (resultInterface.hasNext()) {
                    valueArray = resultInterface.currentRow();
                    if (!resultInterface.hasNext()) break;
                    throw DbException.get(90053);
                }
                return ValueNull.INSTANCE;
            }
            default: {
                valueArray = new Value[]{this};
            }
        }
        return ValueRow.get(valueArray);
    }

    public final ValueResultSet convertToResultSet() {
        SimpleResult simpleResult;
        switch (this.getValueType()) {
            case 18: {
                return (ValueResultSet)this;
            }
            case 39: {
                simpleResult = new SimpleResult();
                Value[] valueArray = ((ValueRow)this).getList();
                int n = 0;
                while (n < valueArray.length) {
                    Value value = valueArray[n++];
                    String string = "C" + n;
                    simpleResult.addColumn(string, string, value.getType());
                }
                simpleResult.addRow(valueArray);
                break;
            }
            default: {
                simpleResult = new SimpleResult();
                simpleResult.addColumn("X", "X", this.getType());
                simpleResult.addRow(this);
                break;
            }
            case 0: {
                throw DbException.throwInternalError();
            }
        }
        return ValueResultSet.get(simpleResult);
    }

    final DbException getDataConversionError(int n) {
        DataType dataType = DataType.getDataType(this.getValueType());
        DataType dataType2 = DataType.getDataType(n);
        throw DbException.get(22018, (dataType != null ? dataType.name : "type=" + this.getValueType()) + " to " + (dataType2 != null ? dataType2.name : "type=" + n));
    }

    final DbException getValueTooLongException(TypeInfo typeInfo, Object object) {
        String string = this.getTraceSQL();
        if (string.length() > 127) {
            string = string.substring(0, 128) + "...";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            stringBuilder.append(object).append(' ');
        }
        typeInfo.getSQL(stringBuilder);
        return DbException.get(22001, stringBuilder.toString(), string + " (" + this.getType().getPrecision() + ')');
    }

    public abstract int compareTypeSafe(Value var1, CompareMode var2, CastDataProvider var3);

    public final int compareTo(Value value, CastDataProvider castDataProvider, CompareMode compareMode) {
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        return this.compareToNotNullable(value, castDataProvider, compareMode);
    }

    private int compareToNotNullable(Value value, CastDataProvider castDataProvider, CompareMode compareMode) {
        int n;
        Value value2 = this;
        int n2 = value2.getValueType();
        if (n2 != (n = value.getValueType()) || n2 == 25) {
            int n3 = Value.getHigherOrder(n2, n);
            if (n3 == 25) {
                ExtTypeInfoEnum extTypeInfoEnum = ExtTypeInfoEnum.getEnumeratorsForBinaryOperation(value2, value);
                value2 = value2.convertToEnum(extTypeInfoEnum);
                value = value.convertToEnum(extTypeInfoEnum);
            } else {
                value2 = value2.convertTo(n3, castDataProvider);
                value = value.convertTo(n3, castDataProvider);
            }
        }
        return value2.compareTypeSafe(value, compareMode, castDataProvider);
    }

    public int compareWithNull(Value value, boolean bl, CastDataProvider castDataProvider, CompareMode compareMode) {
        if (this == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
            return Integer.MIN_VALUE;
        }
        return this.compareToNotNullable(value, castDataProvider, compareMode);
    }

    public boolean containsNull() {
        return false;
    }

    private static byte convertToByte(long l, Object object) {
        if (l > 127L || l < -128L) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (byte)l;
    }

    private static short convertToShort(long l, Object object) {
        if (l > 32767L || l < -32768L) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (short)l;
    }

    public static int convertToInt(long l, Object object) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw DbException.get(22004, Long.toString(l), Value.getColumnName(object));
        }
        return (int)l;
    }

    private static long convertToLong(double d, Object object) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw DbException.get(22004, Double.toString(d), Value.getColumnName(object));
        }
        return Math.round(d);
    }

    private static long convertToLong(BigDecimal bigDecimal, Object object) {
        if (bigDecimal.compareTo(MAX_LONG_DECIMAL) > 0 || bigDecimal.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw DbException.get(22004, bigDecimal.toString(), Value.getColumnName(object));
        }
        return bigDecimal.setScale(0, RoundingMode.HALF_UP).longValue();
    }

    private static String getColumnName(Object object) {
        return object == null ? "" : object.toString();
    }

    public String toString() {
        return this.getTraceSQL();
    }

    protected final DbException getUnsupportedExceptionForOperation(String string) {
        return DbException.getUnsupportedException(DataType.getDataType((int)this.getValueType()).name + " " + string);
    }

    public ResultInterface getResult() {
        SimpleResult simpleResult = new SimpleResult();
        simpleResult.addColumn("X", "X", this.getType());
        simpleResult.addRow(this);
        return simpleResult;
    }

    static {
        MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
        MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    }
}

