/*
 * Decompiled with CFR 0.152.
 */
package org.h2.pagestore.db;

import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

public final class PageStoreRow {
    static final Row[] EMPTY_ARRAY = new Row[0];
    static final SearchRow[] EMPTY_SEARCH_ARRAY = new SearchRow[0];

    private PageStoreRow() {
    }

    static final class RemovedRow
    extends Row {
        RemovedRow(long l) {
            this.setKey(l);
        }

        @Override
        public Value getValue(int n) {
            if (n == -1) {
                return ValueBigint.get(this.key);
            }
            throw DbException.throwInternalError();
        }

        @Override
        public void setValue(int n, Value value) {
            if (n == -1) {
                this.key = value.getLong();
            } else {
                DbException.throwInternalError();
            }
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public String toString() {
            return "( /* key:" + this.key + " */ )";
        }

        @Override
        public int getMemory() {
            return 40;
        }

        @Override
        public Value[] getValueList() {
            return null;
        }

        @Override
        public void copyFrom(SearchRow searchRow) {
            this.setKey(searchRow.getKey());
        }
    }
}

