/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.JSR310Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueTime
extends Value {
    public static final int DEFAULT_PRECISION = 8;
    public static final int MAXIMUM_PRECISION = 18;
    public static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 9;
    private final long nanos;

    private ValueTime(long l) {
        this.nanos = l;
    }

    public static ValueTime fromNanos(long l) {
        if (l < 0L || l >= 86400000000000L) {
            StringBuilder stringBuilder = new StringBuilder();
            DateTimeUtils.appendTime(stringBuilder, l);
            throw DbException.get(22007, "TIME", stringBuilder.toString());
        }
        return (ValueTime)Value.cache(new ValueTime(l));
    }

    public static ValueTime parse(String string) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(string, 0, string.length()));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIME", string);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIME;
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(18);
        DateTimeUtils.appendTime(stringBuilder, this.nanos);
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        DateTimeUtils.appendTime(stringBuilder.append("TIME '"), this.nanos);
        return stringBuilder.append('\'');
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Long.compare(this.nanos, ((ValueTime)value).nanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ValueTime && this.nanos == ((ValueTime)object).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return JSR310Utils.valueToLocalTime(this, null);
    }

    @Override
    public Value add(Value value) {
        ValueTime valueTime = (ValueTime)value;
        return ValueTime.fromNanos(this.nanos + valueTime.getNanos());
    }

    @Override
    public Value subtract(Value value) {
        ValueTime valueTime = (ValueTime)value;
        return ValueTime.fromNanos(this.nanos - valueTime.getNanos());
    }

    @Override
    public Value multiply(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos * value.getDouble()));
    }

    @Override
    public Value divide(Value value, long l) {
        return ValueTime.fromNanos((long)((double)this.nanos / value.getDouble()));
    }
}

