/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.util.Bits;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

abstract class ValueBytesBase
extends Value {
    byte[] value;
    int hash;

    ValueBytesBase(byte[] byArray) {
        this.value = byArray;
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public final byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        byte[] byArray = ((ValueBytesBase)value).value;
        int n = this.getValueType();
        if (n == 22 || n == 40 || compareMode.isBinaryUnsigned()) {
            return Bits.compareNotNullUnsigned(this.value, byArray);
        }
        return Bits.compareNotNullSigned(this.value, byArray);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        return StringUtils.convertBytesToHex(stringBuilder.append("X'"), this.getBytesNoCopy()).append('\'');
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = this.getClass().hashCode() ^ Utils.getByteArrayHash(this.value);
            if (n == 0) {
                n = 1234570417;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && Arrays.equals(this.value, ((ValueBytesBase)object).value);
    }
}

