/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.LongDBDataType;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.RowDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.VersionedValue;

public class MVPrimaryIndex
extends BaseIndex
implements MVIndex<Long, SearchRow> {
    private final MVTable mvTable;
    private final String mapName;
    private final TransactionMap<Long, SearchRow> dataMap;
    private final AtomicLong lastKey = new AtomicLong();
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database database, MVTable mVTable, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(mVTable, n, mVTable.getName() + "_DATA", indexColumnArray, indexType);
        this.mvTable = mVTable;
        LongDBDataType longDBDataType = new LongDBDataType();
        RowDataType rowDataType = mVTable.getRowFactory().getRowDataType();
        this.mapName = "table." + this.getId();
        assert (database.isStarting() || !database.getStore().getMvStore().getMetaMap().containsKey("name." + this.mapName));
        Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(this.mapName, longDBDataType, rowDataType);
        this.dataMap.map.setVolatile(!mVTable.isPersistData() || !indexType.isPersistent());
        transaction.commit();
        Long l = (Long)this.dataMap.map.lastKey();
        this.lastKey.set(l == null ? 0L : l);
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), 3).append(".tableScan").toString();
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        long l;
        Value value;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(this.lastKey.incrementAndGet());
            }
        } else {
            long l2 = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(l2);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value2 = row.getValue(i);
                if (!(value2 instanceof ValueLob)) continue;
                value = ((ValueLob)value2).copy(this.database, this.getId());
                session.removeAtCommitStop((ValueLob)value);
                if (value2 == value) continue;
                row.setValue(i, value);
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        long l3 = row.getKey();
        try {
            value = (Row)transactionMap.putIfAbsent(l3, row);
            if (value != null) {
                int n = 90131;
                if (transactionMap.getImmediate(l3) != null || transactionMap.getFromSnapshot(l3) != null) {
                    n = 23505;
                }
                DbException dbException = DbException.get(n, this.getDuplicatePrimaryKeyMessage(this.mainIndexColumn).append(' ').append(value).toString());
                dbException.setSource(this);
                throw dbException;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        while (l3 > (l = this.lastKey.get()) && !this.lastKey.compareAndSet(l, l3)) {
        }
    }

    @Override
    public void remove(Session session, Row row) {
        Object object;
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                object = row.getValue(i);
                if (!(object instanceof ValueLob)) continue;
                session.removeAtCommit((ValueLob)object);
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        try {
            Row row2 = (Row)transactionMap.remove(row.getKey());
            if (row2 == null) {
                object = new StringBuilder();
                this.getSQL((StringBuilder)object, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, ((StringBuilder)object).toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public void update(Session session, Row row, Row row2) {
        Object object;
        long l;
        if (this.mainIndexColumn != -1) {
            l = row2.getValue(this.mainIndexColumn).getLong();
            row2.setKey(l);
        }
        l = row.getKey();
        assert (this.mainIndexColumn != -1 || l != 0L);
        assert (l == row2.getKey()) : l + " != " + row2.getKey();
        if (this.mvTable.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value;
                object = row.getValue(i);
                if (object == (value = row2.getValue(i))) continue;
                if (object instanceof ValueLob) {
                    session.removeAtCommit((ValueLob)object);
                }
                if (!(value instanceof ValueLob)) continue;
                ValueLob valueLob = ((ValueLob)value).copy(this.database, this.getId());
                session.removeAtCommitStop(valueLob);
                if (value == valueLob) continue;
                row2.setValue(i, valueLob);
            }
        }
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        try {
            Row row3 = (Row)transactionMap.put(l, row2);
            if (row3 == null) {
                object = new StringBuilder();
                this.getSQL((StringBuilder)object, 3).append(": ").append(l);
                throw DbException.get(90112, ((StringBuilder)object).toString());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        if (row2.getKey() > this.lastKey.get()) {
            this.lastKey.set(row2.getKey());
        }
    }

    Row lockRow(Session session, Row row) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        long l = row.getKey();
        return this.lockRow(transactionMap, l);
    }

    private Row lockRow(TransactionMap<Long, SearchRow> transactionMap, long l) {
        try {
            Row row = (Row)transactionMap.lock(l);
            this.ensureRowKey(row, l);
            return row;
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l = this.extractPKFromRow(searchRow, Long.MIN_VALUE);
        long l2 = this.extractPKFromRow(searchRow2, Long.MAX_VALUE);
        return this.find(session, l, l2);
    }

    private long extractPKFromRow(SearchRow searchRow, long l) {
        Value value;
        long l2 = searchRow == null ? l : (this.mainIndexColumn == -1 ? searchRow.getKey() : ((value = searchRow.getValue(this.mainIndexColumn)) == null ? searchRow.getKey() : value.getLong()));
        return l2;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(Session session, long l) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        Row row = (Row)transactionMap.getFromSnapshot(l);
        if (row == null) {
            throw DbException.get(90143, this.getTraceSQL(), String.valueOf(l));
        }
        this.ensureRowKey(row, l);
        return row;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilterArray, n, sortOrder, true, allColumnsForPlan);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void remove(Session session) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            Transaction transaction = session.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.getMap(session).clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        Long l = bl ? transactionMap.firstKey() : transactionMap.lastKey();
        Row row = null;
        if (l != null) {
            row = (Row)transactionMap.getFromSnapshot(l);
            this.ensureRowKey(row, l);
        }
        return new SingleRowCursor(row);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return this.getMap(session).sizeAsLong();
    }

    public long getRowCountMax() {
        return this.dataMap.sizeAsLongMax();
    }

    @Override
    public long getRowCountApproximation() {
        return this.getRowCountMax();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.dataMap.map.getRootPage().getDiskSpaceUsed();
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw new UnsupportedOperationException();
    }

    Cursor find(Session session, Value value, Value value2) {
        long l = value == null || value == ValueNull.INSTANCE ? Long.MIN_VALUE : value.getLong();
        long l2 = value2 == null || value2 == ValueNull.INSTANCE ? Long.MAX_VALUE : value2.getLong();
        return this.find(session, l, l2);
    }

    private Cursor find(Session session, Long l, Long l2) {
        TransactionMap<Long, SearchRow> transactionMap = this.getMap(session);
        if (l != null && l2 != null && l.longValue() == l2.longValue()) {
            Row row = (Row)transactionMap.getFromSnapshot(l);
            this.ensureRowKey(row, l);
            return new SingleRowCursor(row);
        }
        return new MVStoreCursor(transactionMap.entryIterator(l, l2));
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionMap<Long, SearchRow> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction transaction = session.getTransaction();
        return this.dataMap.getInstance(transaction);
    }

    @Override
    public MVMap<Long, VersionedValue<SearchRow>> getMVMap() {
        return this.dataMap.map;
    }

    private void ensureRowKey(Row row, long l) {
        if (this.mainIndexColumn != -1 && row != null && row.getKey() == 0L) {
            long l2 = row.getValue(this.mainIndexColumn).getLong();
            assert (l2 == l) : l2 + " <> " + l;
            row.setKey(l);
        }
    }

    static final class MVStoreCursor
    implements Cursor {
        private final Iterator<Map.Entry<Long, SearchRow>> it;
        private Map.Entry<Long, SearchRow> current;
        private Row row;

        public MVStoreCursor(Iterator<Map.Entry<Long, SearchRow>> iterator) {
            this.it = iterator;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                this.row = (Row)this.current.getValue();
                if (this.row.getKey() == 0L) {
                    this.row.setKey(this.current.getKey());
                }
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

