/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.SimplePredicate;
import org.h2.index.IndexCondition;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class BooleanTest
extends SimplePredicate {
    private final Boolean right;

    public BooleanTest(Expression expression, boolean bl, Boolean bl2) {
        super(expression, bl);
        this.right = bl2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        return this.left.getSQL(stringBuilder.append('('), n).append(this.not ? " IS NOT " : " IS ").append(this.right == null ? "UNKNOWN)" : (this.right != false ? "TRUE)" : "FALSE)"));
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        return ValueBoolean.get((value == ValueNull.INSTANCE ? this.right == null : this.right != null && this.right.booleanValue() == value.getBoolean()) ^ this.not);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new BooleanTest(this.left, !this.not, this.right);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        ExpressionColumn expressionColumn;
        if (!tableFilter.getTable().isQueryComparable()) {
            return;
        }
        if (this.left instanceof ExpressionColumn && (expressionColumn = (ExpressionColumn)this.left).getType().getValueType() == 1 && tableFilter == expressionColumn.getTableFilter()) {
            if (this.not) {
                if (this.right == null && expressionColumn.getColumn().isNullable()) {
                    ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
                    arrayList.add(ValueExpression.FALSE);
                    arrayList.add(ValueExpression.TRUE);
                    tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, arrayList));
                }
            } else {
                tableFilter.addIndexCondition(IndexCondition.get(16, expressionColumn, this.right == null ? TypedValueExpression.UNKNOWN : ValueExpression.getBoolean(this.right)));
            }
        }
    }
}

