/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.schema.Sequence;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class SequenceOptions {
    private Expression start;
    private Expression restart;
    private Expression increment;
    private Expression maxValue;
    private Expression minValue;
    private Boolean cycle;
    private Expression cacheSize;

    private static Long getLong(Session session, Expression expression) {
        Value value;
        if (expression != null && (value = expression.optimize(session).getValue(session)) != ValueNull.INSTANCE) {
            return value.getLong();
        }
        return null;
    }

    public Long getStartValue(Session session) {
        return SequenceOptions.getLong(session, this.start);
    }

    public void setStartValue(Expression expression) {
        this.start = expression;
    }

    public Long getRestartValue(Session session, long l) {
        return this.restart == ValueExpression.DEFAULT ? Long.valueOf(l) : SequenceOptions.getLong(session, this.restart);
    }

    public void setRestartValue(Expression expression) {
        this.restart = expression;
    }

    public Long getIncrement(Session session) {
        return SequenceOptions.getLong(session, this.increment);
    }

    public void setIncrement(Expression expression) {
        this.increment = expression;
    }

    public Long getMaxValue(Sequence sequence, Session session) {
        if (this.maxValue == ValueExpression.NULL && sequence != null) {
            return Sequence.getDefaultMaxValue(this.getCurrentStart(sequence, session), this.increment != null ? this.getIncrement(session).longValue() : sequence.getIncrement());
        }
        return SequenceOptions.getLong(session, this.maxValue);
    }

    public void setMaxValue(Expression expression) {
        this.maxValue = expression;
    }

    public Long getMinValue(Sequence sequence, Session session) {
        if (this.minValue == ValueExpression.NULL && sequence != null) {
            return Sequence.getDefaultMinValue(this.getCurrentStart(sequence, session), this.increment != null ? this.getIncrement(session).longValue() : sequence.getIncrement());
        }
        return SequenceOptions.getLong(session, this.minValue);
    }

    public void setMinValue(Expression expression) {
        this.minValue = expression;
    }

    public Boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(Boolean bl) {
        this.cycle = bl;
    }

    public Long getCacheSize(Session session) {
        return SequenceOptions.getLong(session, this.cacheSize);
    }

    public void setCacheSize(Expression expression) {
        this.cacheSize = expression;
    }

    boolean isRangeSet() {
        return this.restart != null || this.start != null || this.minValue != null || this.maxValue != null || this.increment != null;
    }

    private long getCurrentStart(Sequence sequence, Session session) {
        return this.start != null ? this.getStartValue(session) : sequence.getCurrentValue() + sequence.getIncrement();
    }
}

