/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterDomainAddConstraint;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintDomain;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.Table;

public class DropDomain
extends SchemaCommand {
    private String typeName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropDomain(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Schema schema = this.getSchema();
        Domain domain = schema.findDomain(this.typeName);
        if (domain == null) {
            if (!this.ifExists) {
                throw DbException.get(90120, this.typeName);
            }
        } else {
            ArrayList<ConstraintDomain> arrayList;
            Object object;
            Column column = domain.getColumn();
            for (SchemaObject schemaObject : database.getAllSchemaObjects(12)) {
                Domain domain2 = (Domain)schemaObject;
                Column[] columnArray = domain2.getColumn();
                if (columnArray.getDomain() != domain) continue;
                if (this.dropAction == ConstraintActionType.RESTRICT) {
                    throw DbException.get(90107, this.typeName, domain2.getTraceSQL());
                }
                ArrayList<ConstraintDomain> arrayList2 = domain.getConstraints();
                if (arrayList2 != null && !arrayList2.isEmpty()) {
                    for (ConstraintDomain constraintDomain : arrayList2) {
                        object = constraintDomain.getCheckConstraint(this.session, null);
                        arrayList = new AlterDomainAddConstraint(this.session, domain2.getSchema(), false);
                        ((AlterDomainAddConstraint)((Object)arrayList)).setDomainName(domain2.getName());
                        ((AlterDomainAddConstraint)((Object)arrayList)).setCheckExpression((Expression)object);
                        ((AlterDomainAddConstraint)((Object)arrayList)).update();
                    }
                }
                columnArray.setOriginalSQL(domain.getColumn().getOriginalSQL());
                columnArray.setDomain(column.getDomain());
                database.updateMeta(this.session, domain2);
            }
            for (Table table : database.getAllTablesAndViews(false)) {
                boolean bl = false;
                for (Column column2 : table.getColumns()) {
                    if (column2.getDomain() != domain) continue;
                    if (this.dropAction == ConstraintActionType.RESTRICT) {
                        throw DbException.get(90107, this.typeName, table.getCreateSQL());
                    }
                    object = column2.getName();
                    arrayList = domain.getConstraints();
                    if (arrayList != null && !arrayList.isEmpty()) {
                        for (ConstraintDomain constraintDomain : arrayList) {
                            Expression expression = constraintDomain.getCheckConstraint(this.session, (String)object);
                            AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, table.getSchema(), 3, false);
                            alterTableAddConstraint.setTableName(table.getName());
                            alterTableAddConstraint.setCheckExpression(expression);
                            alterTableAddConstraint.update();
                        }
                    }
                    column2.setOriginalSQL(domain.getColumn().getOriginalSQL());
                    column2.setDomain(column.getDomain());
                    bl = true;
                }
                if (!bl) continue;
                database.updateMeta(this.session, table);
            }
            this.session.getDatabase().removeSchemaObject(this.session, domain);
        }
        return 0;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    @Override
    public int getType() {
        return 47;
    }
}

