/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.HasSQL;
import org.h2.util.IntIntHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;

public class Analyze
extends DefineCommand {
    private int sampleRows;
    private Table table;

    public Analyze(Session session) {
        super(session);
        this.sampleRows = session.getDatabase().getSettings().analyzeSample;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.table != null) {
            Analyze.analyzeTable(this.session, this.table, this.sampleRows, true);
        } else {
            for (Table table : database.getAllTablesAndViews(false)) {
                Analyze.analyzeTable(this.session, table, this.sampleRows, true);
            }
        }
        return 0;
    }

    public static void analyzeTable(Session session, Table table, int n, boolean bl) {
        if (table.getTableType() != TableType.TABLE || table.isHidden() || session == null || !bl && (session.getDatabase().isSysTableLocked() || table.hasSelectTrigger()) || table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null || table.isLockedExclusively() && !table.isLockedExclusivelyBy(session) || !session.getUser().hasRight(table, 1) || session.getCancel() != 0L) {
            return;
        }
        table.lock(session, false, false);
        Column[] columnArray = table.getColumns();
        int n2 = columnArray.length;
        if (n2 == 0) {
            return;
        }
        Cursor cursor = table.getScanIndex(session).find(session, null, null);
        if (cursor.next()) {
            HasSQL hasSQL;
            int n3;
            SelectivityData[] selectivityDataArray = new SelectivityData[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                hasSQL = columnArray[n3];
                if (DataType.isLargeObject(((Column)hasSQL).getType().getValueType())) continue;
                selectivityDataArray[n3] = new SelectivityData();
            }
            n3 = 0;
            do {
                hasSQL = cursor.get();
                for (int i = 0; i < n2; ++i) {
                    SelectivityData selectivityData = selectivityDataArray[i];
                    if (selectivityData == null) continue;
                    selectivityData.add(((SearchRow)hasSQL).getValue(i));
                }
            } while ((n <= 0 || ++n3 < n) && cursor.next());
            for (int i = 0; i < n2; ++i) {
                SelectivityData selectivityData = selectivityDataArray[i];
                if (selectivityData == null) continue;
                columnArray[i].setSelectivity(selectivityData.getSelectivity());
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                columnArray[i].setSelectivity(0);
            }
        }
        session.getDatabase().updateMeta(session, table);
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }

    @Override
    public int getType() {
        return 21;
    }

    private static final class SelectivityData {
        private long count;
        private long distinctCount;
        private final IntIntHashMap distinctHashes = new IntIntHashMap(false);

        SelectivityData() {
        }

        void add(Value value) {
            ++this.count;
            int n = this.distinctHashes.size();
            if (n >= 10000) {
                this.distinctHashes.clear();
                this.distinctCount += (long)n;
            }
            this.distinctHashes.put(value.hashCode(), 1);
        }

        int getSelectivity() {
            int n;
            if (this.count == 0L) {
                n = 0;
            } else {
                n = (int)(100L * (this.distinctCount + (long)this.distinctHashes.size()) / this.count);
                if (n <= 0) {
                    n = 1;
                }
            }
            return n;
        }
    }
}

