/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterTableRenameColumn
extends SchemaCommand {
    private boolean ifTableExists;
    private boolean ifExists;
    private String tableName;
    private String oldName;
    private String newName;

    public AlterTableRenameColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setOldColumnName(String string) {
        this.oldName = string;
    }

    public void setNewColumnName(String string) {
        this.newName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        Column column = table.getColumn(this.oldName, this.ifExists);
        if (column == null) {
            return 0;
        }
        this.session.getUser().checkRight(table, 15);
        table.checkSupportAlter();
        table.renameColumn(column, this.newName);
        table.setModified();
        database.updateMeta(this.session, table);
        for (DbObject dbObject : table.getChildren()) {
            if (!(dbObject instanceof ConstraintReferential)) continue;
            ConstraintReferential constraintReferential = (ConstraintReferential)dbObject;
            constraintReferential.updateOnTableColumnRename();
        }
        for (DbObject dbObject : table.getChildren()) {
            if (dbObject.getCreateSQL() == null) continue;
            database.updateMeta(this.session, dbObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 16;
    }
}

