/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationAlgorithm;
import org.poly2tri.triangulation.TriangulationConstraint;
import org.poly2tri.triangulation.TriangulationDebugContext;
import org.poly2tri.triangulation.TriangulationMode;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;

public abstract class TriangulationContext<A extends TriangulationDebugContext> {
    protected A _debug;
    protected boolean _debugEnabled = false;
    protected ArrayList<DelaunayTriangle> _triList = new ArrayList();
    protected ArrayList<TriangulationPoint> _points = new ArrayList(200);
    protected TriangulationMode _triangulationMode;
    protected Triangulatable _triUnit;
    private boolean _terminated = false;
    private boolean _waitUntilNotified;
    private int _stepTime = -1;
    private int _stepCount = 0;

    public int getStepCount() {
        return this._stepCount;
    }

    public void done() {
        ++this._stepCount;
    }

    public abstract TriangulationAlgorithm algorithm();

    public void prepareTriangulation(Triangulatable t) {
        this._triUnit = t;
        this._triangulationMode = t.getTriangulationMode();
        t.prepareTriangulation(this);
    }

    public abstract TriangulationConstraint newConstraint(TriangulationPoint var1, TriangulationPoint var2);

    public void addToList(DelaunayTriangle triangle) {
        this._triList.add(triangle);
    }

    public List<DelaunayTriangle> getTriangles() {
        return this._triList;
    }

    public Triangulatable getTriangulatable() {
        return this._triUnit;
    }

    public List<TriangulationPoint> getPoints() {
        return this._points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(String message) {
        if (this._debugEnabled) {
            try {
                TriangulationContext triangulationContext = this;
                synchronized (triangulationContext) {
                    ++this._stepCount;
                    if (this._stepTime > 0) {
                        this.wait(this._stepTime);
                        if (this._waitUntilNotified) {
                            this.wait();
                        }
                    } else {
                        this.wait();
                    }
                    this._waitUntilNotified = false;
                }
            }
            catch (InterruptedException e) {
                this.update("Triangulation was interrupted");
            }
        }
        if (this._terminated) {
            throw new RuntimeException("Triangulation process terminated before completion");
        }
    }

    public void clear() {
        this._points.clear();
        this._terminated = false;
        if (this._debug != null) {
            ((TriangulationDebugContext)this._debug).clear();
        }
        this._stepCount = 0;
    }

    public TriangulationMode getTriangulationMode() {
        return this._triangulationMode;
    }

    public synchronized void waitUntilNotified(boolean b) {
        this._waitUntilNotified = b;
    }

    public void terminateTriangulation() {
        this._terminated = true;
    }

    public boolean isDebugEnabled() {
        return this._debugEnabled;
    }

    public abstract void isDebugEnabled(boolean var1);

    public A getDebugContext() {
        return this._debug;
    }

    public void addPoints(Collection<TriangulationPoint> points) {
        this._points.addAll(points);
    }
}

