/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueInteger;
import org.h2.value.ValueVarchar;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.TableLocation;

public class FindGeometryMetadata
extends DeterministicScalarFunction {
    public FindGeometryMetadata() {
        this.addProperty("remarks", "Extract geometry metadata from its create table signature.eg : GEOMETRY; GEOMETRY(POINT); GEOMETRY(POINT Z); GEOMETRY(POINTZ, 4326)...");
    }

    public String getJavaStaticMethod() {
        return "extractMetadata";
    }

    public static ValueArray extractMetadata(Connection connection, String catalogName, String schemaName, String tableName, String columnName, String geometryTableSignature) throws SQLException {
        GeometryMetaData geomMeta = GeometryMetaData.getMetaData((String)geometryTableSignature);
        int srid = geomMeta.getSRID();
        Value[] values = new Value[4];
        if (srid == 0) {
            try (Statement st = connection.createStatement();
                 ResultSet rs = st.executeQuery(String.format("select ST_SRID(%s) from %s LIMIT 1;", StringUtils.quoteJavaString((String)columnName.toUpperCase()), new TableLocation(catalogName, schemaName, tableName)));){
                if (rs.next()) {
                    srid = rs.getInt(1);
                }
            }
        }
        values[0] = ValueInteger.get((int)geomMeta.getGeometryTypeCode());
        values[1] = ValueInteger.get((int)geomMeta.getDimension());
        values[2] = ValueInteger.get((int)srid);
        values[3] = ValueVarchar.get((String)geomMeta.getSfs_geometryType());
        return ValueArray.get((Value[])values);
    }
}

