/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.value.ValueGeometry;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_LineFromWKB
extends DeterministicScalarFunction {
    public ST_LineFromWKB() {
        this.addProperty("remarks", "Convert Well Known Binary into a LINESTRING.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toLineString";
    }

    public static Geometry toLineString(byte[] bytes) throws SQLException, IOException {
        return ST_LineFromWKB.toLineString(bytes, 0);
    }

    public static Geometry toLineString(byte[] bytes, int srid) throws SQLException, IOException {
        if (bytes == null) {
            return null;
        }
        ValueGeometry valueGeometry = ValueGeometry.get((byte[])bytes);
        if (valueGeometry.getTypeAndDimensionSystem() != 2) {
            throw new SQLException("Provided WKB is not a POINT.");
        }
        Geometry geometry = valueGeometry.getGeometry();
        geometry.setSRID(srid);
        return geometry;
    }
}

