/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.cts.parser.prj.PrjParser;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PRJUtil {
    private static final Logger log = LoggerFactory.getLogger(PRJUtil.class);

    public static int getSRID(File prjFile) throws IOException {
        int srid = 0;
        if (prjFile == null) {
            log.debug("This prj file is null. \n A default srid equals to 0 will be added.");
        } else {
            PrjParser parser = new PrjParser();
            String prjString = PRJUtil.readPRJFile(prjFile);
            if (!prjString.isEmpty()) {
                Map p = parser.getParameters(prjString);
                String authorityWithCode = (String)p.get("refname");
                if (authorityWithCode != null) {
                    String[] authorityNameWithKey = authorityWithCode.split(":");
                    srid = Integer.valueOf(authorityNameWithKey[1]);
                }
            } else {
                log.debug("The prj is empty. \n A default srid equals to 0 will be added.");
            }
        }
        return srid;
    }

    public static int getValidSRID(Connection connection, File prjFile) throws SQLException, IOException {
        int srid = PRJUtil.getSRID(prjFile);
        if (!PRJUtil.isSRIDValid(srid, connection)) {
            srid = 0;
        }
        return srid;
    }

    private static String readPRJFile(File prjFile) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(prjFile);){
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.defaultCharset()));
            StringBuilder b = new StringBuilder();
            while (r.ready()) {
                b.append(r.readLine());
            }
            String string = b.toString();
            return string;
        }
    }

    public static void writePRJ(Connection connection, TableLocation location, String geomField, File fileName) throws SQLException, FileNotFoundException {
        int srid = GeometryTableUtilities.getSRID((Connection)connection, (TableLocation)location, (String)geomField);
        PRJUtil.writePRJ(connection, srid, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePRJ(Connection connection, int srid, File fileName) throws SQLException, FileNotFoundException {
        if (srid != 0) {
            StringBuilder sb = new StringBuilder("SELECT SRTEXT FROM ");
            sb.append("PUBLIC.SPATIAL_REF_SYS ").append(" WHERE SRID = ?");
            PreparedStatement ps = connection.prepareStatement(sb.toString());
            ps.setInt(1, srid);
            PrintWriter printWriter = null;
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
                if (rs.next()) {
                    printWriter = new PrintWriter(fileName);
                    printWriter.println(rs.getString(1));
                } else {
                    log.warn("This SRID { " + srid + " } is not supported. \n The PRJ file won't be created.");
                }
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (rs != null) {
                    rs.close();
                }
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSRIDValid(int srid, Connection connection) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String queryCheck = "SELECT count(SRID) from PUBLIC.SPATIAL_REF_SYS WHERE SRID = ?";
        try {
            ps = connection.prepareStatement(queryCheck);
            ps.setInt(1, srid);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) != 0;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return false;
    }
}

