/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.kml;

import java.sql.SQLException;
import org.h2gis.functions.io.kml.AltitudeMode;
import org.h2gis.functions.io.kml.ExtrudeMode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class KMLGeometry {
    private KMLGeometry() {
    }

    public static void toKMLGeometry(Geometry geom, StringBuilder sb) throws SQLException {
        KMLGeometry.toKMLGeometry(geom, ExtrudeMode.NONE, 0, sb);
    }

    public static void toKMLGeometry(Geometry geometry, ExtrudeMode extrude, int altitudeModeEnum, StringBuilder sb) throws SQLException {
        if (geometry instanceof Point) {
            KMLGeometry.toKMLPoint((Point)geometry, extrude, altitudeModeEnum, sb);
        } else if (geometry instanceof LineString) {
            KMLGeometry.toKMLLineString((LineString)geometry, extrude, altitudeModeEnum, sb);
        } else if (geometry instanceof Polygon) {
            KMLGeometry.toKMLPolygon((Polygon)geometry, extrude, altitudeModeEnum, sb);
        } else if (geometry instanceof GeometryCollection) {
            KMLGeometry.toKMLMultiGeometry((GeometryCollection)geometry, extrude, altitudeModeEnum, sb);
        } else {
            throw new SQLException("This geometry type is not supported : " + geometry.toString());
        }
    }

    public static void toKMLPoint(Point point, ExtrudeMode extrude, int altitudeModeEnum, StringBuilder sb) {
        sb.append("<Point>");
        KMLGeometry.appendExtrude(extrude, sb);
        KMLGeometry.appendAltitudeMode(altitudeModeEnum, sb);
        sb.append("<coordinates>");
        Coordinate coord = point.getCoordinate();
        sb.append(coord.x).append(",").append(coord.y);
        if (!Double.isNaN(coord.z)) {
            sb.append(",").append(coord.z);
        }
        sb.append("</coordinates>").append("</Point>");
    }

    public static void toKMLLineString(LineString lineString, ExtrudeMode extrude, int altitudeModeEnum, StringBuilder sb) {
        sb.append("<LineString>");
        KMLGeometry.appendExtrude(extrude, sb);
        KMLGeometry.appendAltitudeMode(altitudeModeEnum, sb);
        KMLGeometry.appendKMLCoordinates(lineString.getCoordinates(), sb);
        sb.append("</LineString>");
    }

    public static void toKMLLinearRing(LineString lineString, ExtrudeMode extrude, int altitudeModeEnum, StringBuilder sb) {
        sb.append("<LinearRing>");
        KMLGeometry.appendExtrude(extrude, sb);
        KMLGeometry.appendAltitudeMode(altitudeModeEnum, sb);
        KMLGeometry.appendKMLCoordinates(lineString.getCoordinates(), sb);
        sb.append("</LinearRing>");
    }

    public static void toKMLPolygon(Polygon polygon, ExtrudeMode extrude, int altitudeModeEnum, StringBuilder sb) {
        sb.append("<Polygon>");
        KMLGeometry.appendExtrude(extrude, sb);
        KMLGeometry.appendAltitudeMode(altitudeModeEnum, sb);
        sb.append("<outerBoundaryIs>");
        KMLGeometry.toKMLLinearRing(polygon.getExteriorRing(), extrude, altitudeModeEnum, sb);
        sb.append("</outerBoundaryIs>");
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            sb.append("<innerBoundaryIs>");
            KMLGeometry.toKMLLinearRing(polygon.getInteriorRingN(i), extrude, altitudeModeEnum, sb);
            sb.append("</innerBoundaryIs>");
        }
        sb.append("</Polygon>");
    }

    public static void toKMLMultiGeometry(GeometryCollection gc, ExtrudeMode extrude, int altitudeModeEnum, StringBuilder sb) {
        sb.append("<MultiGeometry>");
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry geom = gc.getGeometryN(i);
            if (geom instanceof Point) {
                KMLGeometry.toKMLPoint((Point)geom, extrude, altitudeModeEnum, sb);
                continue;
            }
            if (geom instanceof LineString) {
                KMLGeometry.toKMLLineString((LineString)geom, extrude, altitudeModeEnum, sb);
                continue;
            }
            if (!(geom instanceof Polygon)) continue;
            KMLGeometry.toKMLPolygon((Polygon)geom, extrude, altitudeModeEnum, sb);
        }
        sb.append("</MultiGeometry>");
    }

    public static void appendKMLCoordinates(Coordinate[] coords, StringBuilder sb) {
        sb.append("<coordinates>");
        for (int i = 0; i < coords.length; ++i) {
            Coordinate coord = coords[i];
            sb.append(coord.x).append(",").append(coord.y);
            if (!Double.isNaN(coord.z)) {
                sb.append(",").append(coord.z);
            }
            if (i >= coords.length - 1) continue;
            sb.append(" ");
        }
        sb.append("</coordinates>");
    }

    private static void appendExtrude(ExtrudeMode extrude, StringBuilder sb) {
        if (extrude.equals((Object)ExtrudeMode.TRUE)) {
            sb.append("<extrude>").append(1).append("</extrude>");
        } else if (extrude.equals((Object)ExtrudeMode.FALSE)) {
            sb.append("<extrude>").append(0).append("</extrude>");
        }
    }

    private static void appendAltitudeMode(int altitudeModeEnum, StringBuilder sb) {
        AltitudeMode.append(altitudeModeEnum, sb);
    }
}

