/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.table.Column;
import org.h2.util.JdbcUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.dbf.internal.DBFDriver;
import org.h2gis.functions.io.dbf.internal.DbaseFileException;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.file_table.FileEngine;
import org.h2gis.utilities.FileUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class DBFDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "dBase III format";
    private static final int BATCH_MAX_SIZE = 200;

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    /*
     * Loose catch block
     */
    public String[] exportTable(Connection connection, String tableReference, File fileName, String options, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        Throwable throwable;
        ResultSet rs;
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        if (!FileUtilities.isExtensionWellFormated((File)fileName, (String)"dbf")) {
            throw new SQLException("Only .dbf extension is supported");
        }
        if (deleteFiles) {
            Files.deleteIfExists(fileName.toPath());
        } else if (fileName.exists()) {
            throw new IOException("The dbf file already exist.");
        }
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableReference);
        if (matcher.find()) {
            if (tableReference.startsWith("(") && tableReference.endsWith(")")) {
                PreparedStatement ps = connection.prepareStatement(tableReference, 1004, 1007);
                JDBCUtilities.attachCancelResultSet((Statement)ps, (ProgressVisitor)progress);
                ResultSet rs2 = ps.executeQuery();
                int recordCount = 0;
                rs2.last();
                recordCount = rs2.getRow();
                rs2.beforeFirst();
                ProgressVisitor copyProgress = progress.subProcess(recordCount);
                ResultSetMetaData resultSetMetaData = rs2.getMetaData();
                ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
                DbaseFileHeader header = DBFDriverFunction.dBaseHeaderFromMetaData(resultSetMetaData, columnIndexes);
                if (options != null && !options.isEmpty()) {
                    header.setEncoding(options);
                }
                header.setNumRecords(recordCount);
                DBFDriver dbfDriver = new DBFDriver();
                dbfDriver.initDriver(fileName, header);
                Object[] row = new Object[header.getNumFields()];
                while (rs2.next()) {
                    int i = 0;
                    for (Integer index : columnIndexes) {
                        row[i++] = rs2.getObject(index);
                    }
                    dbfDriver.insertRow(row);
                    if (copyProgress == null) continue;
                    copyProgress.endStep();
                }
                dbfDriver.close();
                return new String[]{tableReference};
            }
            throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
        }
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        String outputTable = TableLocation.parse((String)tableReference, (DBTypes)dbType).toString(dbType);
        int recordCount = JDBCUtilities.getRowCount((Connection)connection, (String)outputTable);
        Statement st = connection.createStatement();
        JDBCUtilities.attachCancelResultSet((Statement)st, (ProgressVisitor)progress);
        ProgressVisitor lineProgress = null;
        if (!(progress instanceof EmptyProgressVisitor)) {
            rs = st.executeQuery(String.format("select count(*) from %s", outputTable));
            throwable = null;
            try {
                if (rs.next()) {
                    lineProgress = progress.subProcess(rs.getInt(1));
                }
            }
            catch (Throwable dbfDriver) {
                throwable = dbfDriver;
                throw dbfDriver;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable dbfDriver) {
                            throwable.addSuppressed(dbfDriver);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        try {
            rs = st.executeQuery(String.format("select * from %s", outputTable));
            throwable = null;
            try {
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
                DbaseFileHeader header = DBFDriverFunction.dBaseHeaderFromMetaData(resultSetMetaData, columnIndexes);
                if (options != null && !options.isEmpty()) {
                    header.setEncoding(options);
                }
                header.setNumRecords(recordCount);
                DBFDriver dbfDriver = new DBFDriver();
                dbfDriver.initDriver(fileName, header);
                Object[] row = new Object[header.getNumFields()];
                while (rs.next()) {
                    int i = 0;
                    for (Integer index : columnIndexes) {
                        row[i++] = rs.getObject(index);
                    }
                    dbfDriver.insertRow(row);
                    if (lineProgress == null) continue;
                    lineProgress.endStep();
                }
                dbfDriver.close();
                String[] stringArray = new String[]{outputTable};
                return stringArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
        finally {
            st.close();
        }
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, encoding, false, progress);
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("dbf")) {
            return DESCRIPTION;
        }
        return "";
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"dbf", "dbf.gz"};
    }

    public String[] getExportFormats() {
        return new String[]{"dbf", "dbf.gz"};
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String forceFileEncoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, forceFileEncoding, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, deleteTables, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        if (FileUtilities.isFileImportable((File)fileName, (String)"dbf")) {
            DBTypes dbType = DBUtils.getDBType((Connection)connection);
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
            String outputTable = requestedTable.toString(dbType);
            if (deleteTables) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + outputTable);
                stmt.close();
            }
            DBFDriver dbfDriver = new DBFDriver();
            dbfDriver.initDriverFromFile(fileName, options);
            DbaseFileHeader dbfHeader = dbfDriver.getDbaseFileHeader();
            ProgressVisitor copyProgress = progress.subProcess((int)(dbfDriver.getRowCount() / 200L));
            if (dbfHeader.getNumFields() == 0) {
                JDBCUtilities.createEmptyTable((Connection)connection, (String)outputTable);
            } else {
                try {
                    try (Statement st = connection.createStatement();){
                        ArrayList<Column> otherCols = new ArrayList<Column>(dbfHeader.getNumFields() + 1);
                        String types = DBFDriverFunction.getSQLColumnTypes(dbfHeader, DBUtils.getDBType((Connection)connection), otherCols);
                        String pkColName = FileEngine.getUniqueColumnName("PK", otherCols);
                        st.execute(String.format("CREATE TABLE %s (" + pkColName + " SERIAL PRIMARY KEY, %s)", outputTable, types));
                    }
                    try {
                        connection.setAutoCommit(false);
                        int columnCount = dbfDriver.getFieldCount();
                        try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s VALUES ( %s )", outputTable, DBFDriverFunction.getQuestionMark(dbfHeader.getNumFields() + 1)));){
                            JDBCUtilities.attachCancelResultSet((Statement)preparedStatement, (ProgressVisitor)progress);
                            long batchSize = 0L;
                            int rowId = 0;
                            while ((long)rowId < dbfDriver.getRowCount()) {
                                preparedStatement.setObject(1, rowId + 1);
                                for (int columnId = 0; columnId < columnCount; ++columnId) {
                                    JdbcUtils.set((PreparedStatement)preparedStatement, (int)(columnId + 2), (Value)dbfDriver.getField(rowId, columnId), null);
                                }
                                preparedStatement.addBatch();
                                if (++batchSize >= 200L) {
                                    preparedStatement.executeBatch();
                                    connection.commit();
                                    preparedStatement.clearBatch();
                                    batchSize = 0L;
                                    copyProgress.endStep();
                                }
                                ++rowId;
                            }
                            if (batchSize > 0L) {
                                preparedStatement.executeBatch();
                                connection.commit();
                                preparedStatement.clearBatch();
                            }
                            connection.setAutoCommit(true);
                        }
                    }
                    catch (Exception ex) {
                        connection.createStatement().execute("DROP TABLE IF EXISTS " + outputTable);
                        throw new SQLException(ex.getLocalizedMessage(), ex);
                    }
                }
                finally {
                    dbfDriver.close();
                    copyProgress.endOfProgress();
                }
                return new String[]{outputTable};
            }
        }
        return null;
    }

    public static String getQuestionMark(int count) {
        StringBuilder qMark = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                qMark.append(", ");
            }
            qMark.append("?");
        }
        return qMark.toString();
    }

    public static String getSQLColumnTypes(DbaseFileHeader header, DBTypes dbTypes, List<Column> cols) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int idColumn = 0; idColumn < header.getNumFields(); ++idColumn) {
            if (idColumn > 0) {
                stringBuilder.append(", ");
            }
            String columnName = header.getFieldName(idColumn);
            String fieldName = TableLocation.capsIdentifier((String)columnName, (DBTypes)dbTypes);
            stringBuilder.append(TableLocation.quoteIdentifier((String)fieldName, (DBTypes)dbTypes));
            stringBuilder.append(" ");
            switch (header.getFieldType(idColumn)) {
                case 'L': 
                case 'l': {
                    stringBuilder.append("BOOLEAN");
                    cols.add(new Column(columnName, TypeInfo.TYPE_BOOLEAN));
                    continue block7;
                }
                case 'C': 
                case 'c': {
                    cols.add(new Column(columnName, TypeInfo.TYPE_VARCHAR));
                    stringBuilder.append("VARCHAR(");
                    int length = header.getFieldLength(idColumn);
                    stringBuilder.append(length);
                    stringBuilder.append(")");
                    continue block7;
                }
                case 'D': 
                case 'd': {
                    cols.add(new Column(columnName, TypeInfo.TYPE_DATE));
                    stringBuilder.append("DATE");
                    continue block7;
                }
                case 'N': 
                case 'n': {
                    if (header.getFieldDecimalCount(idColumn) == 0) {
                        if (header.getFieldLength(idColumn) >= 0 && header.getFieldLength(idColumn) < 10) {
                            stringBuilder.append("INT4");
                            cols.add(new Column(columnName, TypeInfo.TYPE_INTEGER));
                            continue block7;
                        }
                        stringBuilder.append("INT8");
                        cols.add(new Column(columnName, TypeInfo.TYPE_BIGINT));
                        continue block7;
                    }
                    stringBuilder.append("FLOAT8");
                    cols.add(new Column(columnName, TypeInfo.TYPE_DOUBLE));
                    continue block7;
                }
                case 'F': 
                case 'O': 
                case 'f': 
                case 'o': {
                    stringBuilder.append("FLOAT8");
                    cols.add(new Column(columnName, TypeInfo.TYPE_DOUBLE));
                    continue block7;
                }
                default: {
                    throw new IOException("Unknown DBF field type " + header.getFieldType(idColumn));
                }
            }
        }
        return stringBuilder.toString();
    }

    public static DbaseFileHeader dBaseHeaderFromMetaData(ResultSetMetaData metaData, List<Integer> retainedColumns) throws SQLException {
        DbaseFileHeader dbaseFileHeader = new DbaseFileHeader();
        for (int fieldId = 1; fieldId <= metaData.getColumnCount(); ++fieldId) {
            String fieldTypeName = metaData.getColumnTypeName(fieldId);
            if (fieldTypeName.equalsIgnoreCase("geometry")) continue;
            DBFType dbfType = DBFDriverFunction.getDBFType(metaData.getColumnType(fieldId), fieldTypeName, metaData.getColumnDisplaySize(fieldId), metaData.getPrecision(fieldId));
            try {
                dbaseFileHeader.addColumn(metaData.getColumnName(fieldId), dbfType.type, dbfType.fieldLength, dbfType.decimalCount);
                retainedColumns.add(fieldId);
                continue;
            }
            catch (DbaseFileException ex) {
                throw new SQLException(ex.getLocalizedMessage(), ex);
            }
        }
        return dbaseFileHeader;
    }

    private static DBFType getDBFType(int sqlTypeId, String sqlTypeName, int length, int precision) throws SQLException {
        switch (sqlTypeId) {
            case 16: {
                return new DBFType('l', 1, 0);
            }
            case -7: {
                return new DBFType('n', Math.min(3, length), 0);
            }
            case 91: {
                return new DBFType('d', 8, 0);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return new DBFType('f', Math.min(20, length + 1), Math.min(18, precision));
            }
            case 4: {
                return new DBFType('n', Math.min(10, length), 0);
            }
            case -5: {
                return new DBFType('n', Math.min(18, length), 0);
            }
            case 5: {
                return new DBFType('n', Math.min(5, length), 0);
            }
            case -15: 
            case 1: 
            case 12: {
                return new DBFType('c', Math.min(254, length), 0);
            }
        }
        throw new SQLException("Field type not supported by DBF : " + sqlTypeName);
    }

    private static class DBFType {
        char type;
        int fieldLength;
        int decimalCount;

        DBFType(char type, int fieldLength, int decimalCount) {
            this.type = type;
            this.fieldLength = fieldLength;
            this.decimalCount = decimalCount;
        }
    }
}

