/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.asc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.asc.AscReaderDriver;
import org.h2gis.functions.io.utility.PRJUtil;
import org.h2gis.utilities.URIUtilities;
import org.locationtech.jts.geom.Geometry;

public class AscRead
extends AbstractFunction
implements ScalarFunction {
    public AscRead() {
        this.addProperty("remarks", "Import ESRI ASCII Raster file as point geometries\nPixels are converted into PointZ with Z as the pixel value\nCALL ASCREAD('dem.asc');\nCALL ASCREAD('dem.asc',TYPE);\nTYPE of z data 1 for integer, 2 for double (default 2)\nCALL ASCREAD('dem.asc', 'MYTABLE');\nCALL ASCREAD('dem.asc', 'MYTABLE', TYPE);\nTYPE of z data 1 for integer, 2 for double (default 2)CALL ASCREAD('dem.asc', 'MYTABLE', GEOM_FILTER, DOWNSCALE_INT, AS_POLYGONS);\nGEOM_FILTER - Extract only pixels that intersects the provided geometry envelope, null to disable filter\nDOWNSCALE_INT - Coefficient used for exporting less cells (1 all cells, 2 for size / 2)\nAS_POLYGONS - If true pixels are converted to polygons. (default false return points)\n");
    }

    public String getJavaStaticMethod() {
        return "readAscii";
    }

    public static void readAscii(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).toUpperCase().replace(".", "_");
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        AscRead.readAscii(connection, fileName, ValueVarchar.get((String)tableName));
    }

    public static void readAscii(Connection connection, String fileName, Value option) throws IOException, SQLException {
        int zType = 2;
        String tableReference = null;
        boolean deletTable = false;
        Geometry envelope = null;
        if (option instanceof ValueInteger) {
            zType = option.getInt();
            if (zType != 1 && zType != 2) {
                throw new SQLException("Please use 1 for integer or 2 for double conversion");
            }
        } else if (option instanceof ValueVarchar) {
            tableReference = option.getString();
        } else if (option instanceof ValueBoolean) {
            deletTable = option.getBoolean();
        } else if (option instanceof ValueGeometry) {
            envelope = ((ValueGeometry)option).getGeometry();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is integer for z type or varchar for table name");
        }
        File outputFile = URIUtilities.fileFromString((String)fileName);
        if (tableReference == null) {
            String name = outputFile.getName();
            String tableName = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
            if (tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
                tableReference = tableName;
            } else {
                throw new SQLException("The file name contains unsupported characters");
            }
        }
        AscReaderDriver ascReaderDriver = new AscReaderDriver();
        if (envelope != null && !envelope.isEmpty()) {
            ascReaderDriver.setExtractEnvelope(envelope.getEnvelopeInternal());
        }
        ascReaderDriver.setZType(zType);
        ascReaderDriver.setDeleteTable(deletTable);
        AscRead.importFile(connection, tableReference, outputFile, (ProgressVisitor)new EmptyProgressVisitor(), ascReaderDriver);
    }

    public static void readAscii(Connection connection, String fileName, String tableReference, Value option) throws IOException, SQLException {
        int zType = 2;
        boolean deletTable = false;
        Geometry envelope = null;
        if (option instanceof ValueInteger) {
            zType = option.getInt();
            if (zType != 1 && zType != 2) {
                throw new SQLException("Please use 1 for integer or 2 for double conversion");
            }
        } else if (option instanceof ValueBoolean) {
            deletTable = option.getBoolean();
        } else if (option instanceof ValueGeometry) {
            envelope = ((ValueGeometry)option).getGeometry();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is integer for z type or varchar for table name");
        }
        AscReaderDriver ascReaderDriver = new AscReaderDriver();
        if (envelope != null && !envelope.isEmpty()) {
            ascReaderDriver.setExtractEnvelope(envelope.getEnvelopeInternal());
        }
        ascReaderDriver.setAs3DPoint(true);
        ascReaderDriver.setZType(zType);
        ascReaderDriver.setDeleteTable(deletTable);
        AscRead.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor(), ascReaderDriver);
    }

    private static void importFile(Connection connection, String tableReference, File outputFile, ProgressVisitor progress, AscReaderDriver ascReaderDriver) throws IOException, SQLException {
        int dotIndex;
        int srid = 0;
        String filePath = outputFile.getAbsolutePath();
        String fileNamePrefix = filePath.substring(0, dotIndex = filePath.lastIndexOf(46));
        File prjFile = new File(fileNamePrefix + ".prj");
        if (prjFile.exists()) {
            srid = PRJUtil.getSRID(prjFile);
        }
        ascReaderDriver.read(connection, outputFile, progress, tableReference, srid);
    }

    public static void readAscii(Connection connection, String fileName, String tableReference, Geometry envelope, int downScale, boolean extractAsPolygons) throws IOException, SQLException {
        AscReaderDriver ascReaderDriver = new AscReaderDriver();
        if (envelope != null && !envelope.isEmpty()) {
            ascReaderDriver.setExtractEnvelope(envelope.getEnvelopeInternal());
        }
        if (downScale > 1) {
            ascReaderDriver.setDownScale(downScale);
        }
        ascReaderDriver.setAs3DPoint(!extractAsPolygons);
        AscRead.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor(), ascReaderDriver);
    }

    public static void readAscii(Connection connection, String fileName, String tableReference, Geometry envelope, int downScale, boolean extractAsPolygons, boolean deleteTable) throws IOException, SQLException {
        AscReaderDriver ascReaderDriver = new AscReaderDriver();
        if (envelope != null && !envelope.isEmpty()) {
            ascReaderDriver.setExtractEnvelope(envelope.getEnvelopeInternal());
        }
        if (downScale > 1) {
            ascReaderDriver.setDownScale(downScale);
        }
        ascReaderDriver.setAs3DPoint(!extractAsPolygons);
        ascReaderDriver.setDeleteTable(deleteTable);
        AscRead.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor(), ascReaderDriver);
    }

    public static void readAscii(Connection connection, String fileName, String tableReference, Geometry envelope, int downScale, boolean extractAsPolygons, boolean deleteTable, String encoding, int zType) throws IOException, SQLException {
        AscReaderDriver ascReaderDriver = new AscReaderDriver();
        if (envelope != null && !envelope.isEmpty()) {
            ascReaderDriver.setExtractEnvelope(envelope.getEnvelopeInternal());
        }
        if (downScale > 1) {
            ascReaderDriver.setDownScale(downScale);
        }
        ascReaderDriver.setAs3DPoint(!extractAsPolygons);
        ascReaderDriver.setEncoding(encoding);
        ascReaderDriver.setZType(zType);
        ascReaderDriver.setDeleteTable(deleteTable);
        AscRead.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor(), ascReaderDriver);
    }
}

